/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tingeltangel.tools.Binary;
import tingeltangel.tools.Language;

public class TTS {
    public static final int UNKNOWN = 0;
    public static final int FEMALE = 1;
    public static final int MALE = 2;
    private static final File ESPEAK;
    private static final File LAME;
    private static final boolean ENABLED;
    private static final Map<String, Language> voices;
    private static final Map<String, Language> variants;
    private static final SortedSet<String> voiceIDs;
    private static final SortedSet<String> variantIDs;
    private static final Logger LOG;

    public static SortedSet<String> getVoiceIDs() {
        return voiceIDs;
    }

    public static SortedSet<String> getVariantIDs() {
        return variantIDs;
    }

    public static String getVoiceName(String id) {
        return TTS.voices.get((Object)id).name + " (" + id + ")";
    }

    public static String getVariantName(String id) {
        return TTS.variants.get((Object)id).name;
    }

    public static int getVoiceGender(String id) {
        return TTS.voices.get((Object)id).gender;
    }

    public static int getVariantGender(String id) {
        return TTS.variants.get((Object)id).gender;
    }

    private static void getLanguages(String eSpeakArgument) throws IOException {
        String row;
        String[] cmd1 = new String[]{ESPEAK.getCanonicalPath(), eSpeakArgument};
        Process process = new ProcessBuilder(cmd1).start();
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        in.readLine();
        while ((row = in.readLine()) != null) {
            String[] r = row.trim().split("[ ]+");
            Language lang = new Language();
            lang.lang = r[1];
            if (r[2].endsWith("F") || r[2].endsWith("M") || r[2].endsWith("-")) {
                lang.id = r[4];
                lang.name = r[3];
                lang.gender = r[2].endsWith("F") ? 1 : (r[2].endsWith("M") ? 2 : 0);
            } else {
                lang.id = r[3];
                lang.name = r[2];
                lang.gender = 0;
            }
            voiceIDs.add(lang.id);
            voices.put(lang.id, lang);
        }
    }

    public static void play(final String text, int amplitude, int pitch, int speed, String voice, String variant) throws IOException {
        if (!ENABLED) {
            LOG.error("tts is not enabled");
            return;
        }
        speed = Math.max(Math.min(speed, 450), 80);
        amplitude = Math.max(Math.min(amplitude, 20), 0);
        pitch = Math.max(Math.min(pitch, 99), 0);
        variant = variant == null || ((String)variant).isEmpty() ? "" : "+" + (String)variant;
        String[] cmd = new String[]{ESPEAK.getCanonicalPath(), "--stdin", "-b", "1", "-z", "-a", Integer.toString(amplitude), "-p", Integer.toString(pitch), "-s", Integer.toString(speed), "-v", voice + (String)variant};
        final Process p = new ProcessBuilder(cmd).start();
        new Thread(){

            @Override
            public void run() {
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes(Charset.forName("UTF-8")));
                    OutputStream out = p.getOutputStream();
                    TTS.copyStream(in, null, out);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }.start();
    }

    public static void generate(final String text, int amplitude, int pitch, int speed, String voice, String variant, final File mp3) throws IOException {
        Object _p2;
        boolean PADDING = false;
        if (!ENABLED) {
            LOG.error("tts is not enabled");
            return;
        }
        speed = Math.max(Math.min(speed, 450), 80);
        amplitude = Math.max(Math.min(amplitude, 20), 0);
        pitch = Math.max(Math.min(pitch, 99), 0);
        variant = variant == null || ((String)variant).isEmpty() ? "" : "+" + (String)variant;
        String[] cmd1 = new String[]{ESPEAK.getCanonicalPath(), "--stdin", "--stdout", "-b", "1", "-z", "-a", Integer.toString(amplitude), "-p", Integer.toString(pitch), "-s", Integer.toString(speed), "-v", voice + (String)variant};
        String[] cmd2 = new String[]{"sox", "-", "-t", "wav", "-", "pad", "0", "1"};
        String[] cmd3 = new String[]{LAME.getCanonicalPath(), "-", "-"};
        final Process p1 = new ProcessBuilder(cmd1).start();
        Object p2 = _p2 = null;
        final Process p3 = new ProcessBuilder(cmd3).start();
        new Thread(){

            @Override
            public void run() {
                try {
                    InputStream in = p3.getInputStream();
                    InputStream err = p3.getErrorStream();
                    FileOutputStream out = new FileOutputStream(mp3);
                    TTS.copyStream(in, err, out);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                try {
                    InputStream in = p1.getInputStream();
                    InputStream err = p1.getErrorStream();
                    OutputStream out = p3.getOutputStream();
                    TTS.copyStream(in, err, out);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes(Charset.forName("UTF-8")));
                    OutputStream out = p1.getOutputStream();
                    TTS.copyStream(in, null, out);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }.start();
        try {
            p3.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void copyStream(InputStream in, final InputStream err, OutputStream out) throws IOException {
        if (err != null) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        int i;
                        byte[] b = new byte[4096];
                        while ((i = err.read(b)) >= 0) {
                        }
                        return;
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        return;
                    }
                }
            }.start();
        }
        byte[] buffer = new byte[4096];
        int c = 0;
        while (true) {
            int i;
            if ((i = in.read(buffer)) < 0) {
                out.close();
                return;
            }
            c += i;
            out.write(buffer, 0, i);
            out.flush();
        }
    }

    static {
        voices = new HashMap<String, Language>();
        variants = new HashMap<String, Language>();
        voiceIDs = new TreeSet<String>();
        variantIDs = new TreeSet<String>();
        LOG = LogManager.getLogger((String)TTS.class.getCanonicalName());
        try {
            ESPEAK = Binary.getBinary("espeak");
            LAME = Binary.getBinary("lame");
            boolean bl = ENABLED = ESPEAK != null && LAME != null;
            if (ENABLED) {
                String row;
                TTS.getLanguages("--voices");
                HashSet<String> langs = new HashSet<String>();
                Iterator<Language> langIt = voices.values().iterator();
                while (langIt.hasNext()) {
                    langs.add(langIt.next().lang);
                }
                Iterator langSIt = langs.iterator();
                while (langSIt.hasNext()) {
                    TTS.getLanguages("--voice=" + (String)langSIt.next());
                }
                String[] cmd2 = new String[]{ESPEAK.getCanonicalPath(), "--voices=variant"};
                Process process = new ProcessBuilder(cmd2).start();
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                in.readLine();
                while ((row = in.readLine()) != null) {
                    String[] r = row.trim().split("[ ]+");
                    Language lang = new Language();
                    if (r[2].endsWith("F") || r[2].endsWith("M") || r[2].endsWith("-")) {
                        lang.id = r[4].substring(3);
                        lang.name = r[3];
                        lang.gender = r[2].endsWith("F") ? 1 : (r[2].endsWith("M") ? 2 : 0);
                    } else {
                        lang.id = r[3].substring(3);
                        lang.name = r[2];
                        lang.gender = 0;
                    }
                    if (lang.gender == 1) {
                        lang.name = lang.name + " (Frau)";
                    } else if (lang.gender == 2) {
                        lang.name = lang.name + " (Mann)";
                    }
                    variantIDs.add(lang.id);
                    variants.put(lang.id, lang);
                }
            } else {
                LOG.warn("tts is not enabled");
                if (LAME == null) {
                    LOG.warn("'lame' is not found");
                }
                if (ESPEAK == null) {
                    LOG.warn("'eSpeak' is not found");
                }
            }
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
    }
}

