/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.UUID;

public class FileEnvironment {
    private static boolean test = false;

    public static void test() {
        test = true;
    }

    public static File getHomeDirectory() {
        return new File(System.getProperty("user.home"));
    }

    public static File getAndersichtDirectory() {
        File f = FileEnvironment.getWorkingDirectory("andersicht");
        if (!f.exists()) {
            f.mkdir();
        }
        return f;
    }

    public static File getAndersichtBookDirectory(String name) {
        File f = new File(FileEnvironment.getAndersichtDirectory(), name);
        if (!f.exists()) {
            f.mkdir();
            new File(f, "audio").mkdir();
        }
        return f;
    }

    public static File getAndersichtBookFile(String name) {
        return new File(FileEnvironment.getAndersichtBookDirectory(name), "book.def");
    }

    public static File getAndersichtAudioDirectory(String name) {
        return new File(FileEnvironment.getAndersichtBookDirectory(name), "audio");
    }

    public static File getBooksDirectory() {
        if (test) {
            return FileEnvironment.getWorkingDirectory("books-test");
        }
        return FileEnvironment.getWorkingDirectory("books");
    }

    public static File getBookDirectory(int id) {
        Object _id = Integer.toString(id);
        while (((String)_id).length() < 5) {
            _id = "0" + (String)_id;
        }
        File bd = new File(FileEnvironment.getBooksDirectory(), (String)_id);
        if (bd.exists()) {
            if (!bd.isDirectory()) {
                throw new Error(bd.getAbsolutePath() + " exists but is not a directory");
            }
        } else if (!bd.mkdirs()) {
            throw new Error("can't create directory " + bd.getAbsolutePath());
        }
        return bd;
    }

    public static File getRepositoryDirectory() {
        return FileEnvironment.getWorkingDirectory("repository");
    }

    public static File getAudioDirectory(int id) {
        return FileEnvironment.getBookSubDirectory(id, "audio");
    }

    public static File getDistDirectory(int id) {
        return FileEnvironment.getBookSubDirectory(id, "dist");
    }

    public static File getBinDirectory(int id) {
        return FileEnvironment.getBookSubDirectory(id, "bin");
    }

    public static File getCodesDirectory(int id) {
        return FileEnvironment.getBookSubDirectory(id, "codes");
    }

    public static File getPagesDirectory(int id) {
        return FileEnvironment.getBookSubDirectory(id, "pages");
    }

    public static File getBinObjectFile(int mid, int oid) {
        return new File(FileEnvironment.getBinDirectory(mid), Integer.toString(oid) + ".bin");
    }

    private static File getBookSubDirectory(int id, String subDirectory) {
        File codes = new File(FileEnvironment.getBookDirectory(id), subDirectory);
        if (codes.exists()) {
            if (!codes.isDirectory()) {
                throw new Error(codes.getAbsolutePath() + " exists but is not a directory");
            }
        } else if (!codes.mkdirs()) {
            throw new Error("can't create directory " + codes.getAbsolutePath());
        }
        return codes;
    }

    public static File getXML(int id) {
        return new File(FileEnvironment.getBookDirectory(id), "book.xml");
    }

    private static File getWorkingDirectory(String subDirectory) {
        File wd = new File(FileEnvironment.getWorkingDirectoryRoot(), subDirectory);
        if (wd.exists()) {
            if (!wd.isDirectory()) {
                throw new Error(wd.getAbsolutePath() + " exists but is not a directory");
            }
        } else if (!wd.mkdirs()) {
            throw new Error("can't create directory " + wd.getAbsolutePath());
        }
        return wd;
    }

    public static File getWorkingDirectoryRoot() {
        File wd = System.getProperty("tt_home") != null ? new File(System.getProperty("tt_home")) : new File(FileEnvironment.getHomeDirectory(), ".tingeltangel");
        if (wd.exists()) {
            if (!wd.isDirectory()) {
                throw new Error(wd.getAbsolutePath() + " exists but is not a directory");
            }
        } else if (!wd.mkdirs()) {
            throw new Error("can't create directory " + wd.getAbsolutePath());
        }
        return wd;
    }

    public static File getFreeFileName(File directory, String fileExtension) {
        File f = new File(directory, UUID.randomUUID().toString() + fileExtension);
        while (f.exists()) {
            f = new File(directory, UUID.randomUUID().toString() + fileExtension);
        }
        return f;
    }

    public static void copy(File source, File destination) throws IOException {
        FileChannel sourceChannel = null;
        FileOutputStream fout = null;
        try {
            sourceChannel = new FileInputStream(source).getChannel();
            fout = new FileOutputStream(destination);
            FileChannel destChannel = fout.getChannel();
            destChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }
}

