/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import tingeltangel.core.Properties;
import tingeltangel.core.Tupel;
import tingeltangel.tools.TTS;

public class TTSPreferences
extends JDialog {
    public static final String PROPERTY_DEFAULT_VOICE = "default_voice";
    public static final String PROPERTY_DEFAULT_VARIANT = "default_variant";
    private JComboBox defaultLanguage;
    private JComboBox defaultVariant;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JButton okButton;

    public TTSPreferences() {
        this.initComponents();
        this.setDefaultCloseOperation(2);
        String voiceID = Properties.getStringProperty(PROPERTY_DEFAULT_VOICE);
        Iterator voices = TTS.getVoiceIDs().iterator();
        DefaultComboBoxModel voiceModel = (DefaultComboBoxModel)this.defaultLanguage.getModel();
        while (voices.hasNext()) {
            String id = (String)voices.next();
            Tupel<String, String> tupel = new Tupel<String, String>(id, TTS.getVoiceName(id));
            voiceModel.addElement(tupel);
            if (!id.equals(voiceID)) continue;
            voiceModel.setSelectedItem(tupel);
        }
        this.defaultLanguage.setRenderer(new MyRenderer(this));
        String variantID = Properties.getStringProperty(PROPERTY_DEFAULT_VARIANT);
        Iterator variants = TTS.getVariantIDs().iterator();
        DefaultComboBoxModel variantModel = (DefaultComboBoxModel)this.defaultVariant.getModel();
        Tupel<String, String> noVariant = new Tupel<String, String>("", "keine Variante");
        variantModel.addElement(noVariant);
        if (variantID == null || variantID.isEmpty()) {
            variantModel.setSelectedItem(noVariant);
        }
        while (variants.hasNext()) {
            String id = (String)variants.next();
            Tupel<String, String> tupel = new Tupel<String, String>(id, TTS.getVariantName(id));
            variantModel.addElement(tupel);
            if (!id.equals(variantID)) continue;
            variantModel.setSelectedItem(tupel);
        }
        this.defaultVariant.setRenderer(new MyRenderer(this));
    }

    public static String getDefaultVoice() {
        return Properties.getStringProperty(PROPERTY_DEFAULT_VOICE);
    }

    public static String getDefaultVariant() {
        return Properties.getStringProperty(PROPERTY_DEFAULT_VARIANT);
    }

    private void initComponents() {
        this.defaultLanguage = new JComboBox();
        this.jLabel1 = new JLabel();
        this.okButton = new JButton();
        this.jLabel2 = new JLabel();
        this.defaultVariant = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.defaultLanguage.setModel(new DefaultComboBoxModel());
        this.jLabel1.setText("Standardsprache:");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TTSPreferences.this.okButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Standardvariante:");
        this.defaultVariant.setModel(new DefaultComboBoxModel());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultLanguage, 0, -1, Short.MAX_VALUE).addComponent(this.defaultVariant, 0, 178, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.defaultLanguage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.defaultVariant, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.okButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String langID = (String)((Tupel)this.defaultLanguage.getSelectedItem()).a;
        String varID = (String)((Tupel)this.defaultVariant.getSelectedItem()).a;
        Properties.setProperty(PROPERTY_DEFAULT_VOICE, langID);
        Properties.setProperty(PROPERTY_DEFAULT_VARIANT, varID);
        this.setVisible(false);
    }

    class MyRenderer
    implements ListCellRenderer {
        MyRenderer(TTSPreferences this$0) {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Tupel tupel = (Tupel)value;
            return new JLabel((String)tupel.b);
        }
    }
}

