/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import tingeltangel.core.Repository;
import tingeltangel.core.Tupel;
import tingeltangel.tools.Callback;

public class BookIDChooser
extends JDialog {
    private final LinkedList<Tupel<Integer, String>> idList = new LinkedList();
    private final MyListModel model = new MyListModel();
    private final Callback<Integer> callback;
    private JButton button;
    private ButtonGroup buttonGroup1;
    private JScrollPane jScrollPane1;
    private JList list;

    public BookIDChooser(Frame parent, Callback<Integer> callback) {
        super(parent, false);
        this.initComponents();
        this.callback = callback;
        this.fillIDList();
        this.list.setModel(this.model);
        this.setVisible(true);
    }

    public BookIDChooser(Dialog parent, Callback<Integer> callback) {
        super(parent, false);
        this.initComponents();
        this.callback = callback;
        this.fillIDList();
        this.list.setModel(this.model);
        this.setVisible(true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.button = new JButton();
        this.setDefaultCloseOperation(2);
        this.list.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        this.button.setText("OK");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookIDChooser.this.buttonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 376, Short.MAX_VALUE).addComponent(this.button))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 317, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.button).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void fillIDList() {
        Integer[] ids = Repository.getIDs();
        for (int i = 0; i < ids.length; ++i) {
            this.idList.add(new Tupel<Integer, String>(ids[i], this.renderName(ids[i])));
        }
    }

    private String renderName(int id) {
        Object name = Integer.toString(id);
        while (((String)name).length() < 5) {
            name = "0" + (String)name;
        }
        HashMap<String, String> txt = Repository.getBookTxt(id);
        if (txt != null) {
            name = (String)name + " " + txt.get("Name") + " (" + txt.get("Author") + ")";
        }
        return name;
    }

    private void buttonActionPerformed(ActionEvent evt) {
        int index = this.list.getSelectedIndex();
        if (index != -1) {
            int id = (Integer)this.idList.get((int)index).a;
            this.callback.callback(id);
            this.setVisible(false);
        }
    }

    class MyListModel
    implements ListModel {
        private LinkedList<ListDataListener> listeners = new LinkedList();

        MyListModel() {
        }

        @Override
        public int getSize() {
            return BookIDChooser.this.idList.size();
        }

        public Object getElementAt(int index) {
            return BookIDChooser.this.idList.get((int)index).b;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        public void refresh() {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((ListDataListener)i.next()).contentsChanged(null);
            }
        }
    }
}

