/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tingeltangel.core.Repository;
import tingeltangel.core.Stick;
import tingeltangel.tools.OS;
import tingeltangel.tools.ProgressDialog;

public class BookiiStick
extends Stick {
    private static final String BOOK_DIR = "BOOK";
    private static final String CONFIG_DIR = "CONFIGURE";
    private static final String SETTINGS_FILE = "SETTINGS.INI";
    private static final String TBD_FILE = "TBD.TXT";
    private final File path;
    private File tbdFile = null;
    private File settingsFile = null;
    private File bookDir = null;
    private static final Logger LOG = LogManager.getLogger((String)BookiiStick.class.getCanonicalName());

    @Override
    public String getType() {
        return "Bookii";
    }

    @Override
    public boolean isBookii() {
        return true;
    }

    private BookiiStick(File path) {
        this.path = path;
        File[] content = path.listFiles();
        File configDir = null;
        for (int i = 0; i < content.length; ++i) {
            if (content[i].isDirectory() && content[i].getName().toUpperCase().equals(BOOK_DIR)) {
                this.bookDir = content[i];
            }
            if (!content[i].isDirectory() || !content[i].getName().toUpperCase().equals(CONFIG_DIR)) continue;
            configDir = content[i];
        }
        File[] configContent = configDir.listFiles();
        for (int i = 0; i < configContent.length; ++i) {
            if (configContent[i].isFile() && configContent[i].getName().toUpperCase().equals(SETTINGS_FILE)) {
                this.settingsFile = configContent[i];
            }
            if (!configContent[i].isFile() || !configContent[i].getName().toUpperCase().equals(TBD_FILE)) continue;
            this.tbdFile = configContent[i];
        }
    }

    private static boolean checkForStick(File path) {
        File[] content = path.listFiles();
        if (content != null) {
            File bookDir = null;
            File configDir = null;
            for (int i = 0; i < content.length; ++i) {
                if (content[i].isDirectory() && content[i].getName().toUpperCase().equals(BOOK_DIR)) {
                    bookDir = content[i];
                }
                if (!content[i].isDirectory() || !content[i].getName().toUpperCase().equals(CONFIG_DIR)) continue;
                configDir = content[i];
            }
            if (configDir == null || bookDir == null) {
                return false;
            }
            File[] configContent = configDir.listFiles();
            boolean foundSettings = false;
            boolean foundTbd = false;
            for (int i = 0; i < configContent.length; ++i) {
                if (configContent[i].isFile() && configContent[i].getName().toUpperCase().equals(SETTINGS_FILE)) {
                    foundSettings = true;
                }
                if (!configContent[i].isFile() || !configContent[i].getName().toUpperCase().equals(TBD_FILE)) continue;
                foundTbd = true;
            }
            if (!foundSettings) {
                return false;
            }
            return foundTbd;
        }
        return false;
    }

    @Override
    public long getFreeSpace() {
        return this.path.getUsableSpace();
    }

    @Override
    public File getTBDFile() {
        return this.tbdFile;
    }

    @Override
    public HashSet<Integer> getTBD() throws IOException {
        String row;
        if (!this.tbdFile.canRead()) {
            throw new FileNotFoundException(this.tbdFile.getAbsolutePath());
        }
        HashSet<Integer> tbd = new HashSet<Integer>();
        BufferedReader in = new BufferedReader(new FileReader(this.tbdFile));
        while ((row = in.readLine()) != null) {
            if ((row = row.trim()).isEmpty()) continue;
            try {
                tbd.add(Integer.parseInt(row));
            }
            catch (NumberFormatException nfe) {
                LOG.warn("invalid row in " + this.tbdFile.getAbsolutePath() + ": " + row);
            }
        }
        in.close();
        return tbd;
    }

    @Override
    public LinkedList<Integer> getBooks() throws IOException {
        if (!this.bookDir.canRead()) {
            throw new FileNotFoundException(this.bookDir.getAbsolutePath());
        }
        LinkedList<Integer> books = new LinkedList<Integer>();
        File[] files = this.bookDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getName().endsWith("_en.kii") || files[i].getName().length() != "_en.kii".length() + 5) continue;
            books.add(Integer.parseInt(files[i].getName().substring(0, 5)));
        }
        return books;
    }

    @Override
    public File getBookDir() {
        return this.bookDir;
    }

    @Override
    public void setSettings(HashMap<String, String> settings) throws IOException {
        if (!this.settingsFile.canWrite()) {
            throw new FileNotFoundException(this.settingsFile.getAbsolutePath());
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.settingsFile), "UTF-16");
        TreeSet<String> sortedKeys = new TreeSet<String>();
        sortedKeys.addAll(settings.keySet());
        for (String key : sortedKeys) {
            out.append(key + "=" + settings.get(key) + "\r\n");
        }
        out.close();
    }

    @Override
    public HashMap<String, String> getSettings() throws IOException {
        String row;
        if (!this.settingsFile.canRead()) {
            throw new FileNotFoundException(this.settingsFile.getAbsolutePath());
        }
        HashMap<String, String> settings = new HashMap<String, String>();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.settingsFile), Charset.forName("UTF-16")));
        while ((row = in.readLine()) != null) {
            if ((row = row.trim()).isEmpty()) continue;
            int p = row.indexOf("=");
            if (p == -1) {
                throw new IOException("bad row in " + this.settingsFile.getAbsolutePath() + ": " + row);
            }
            String key = row.substring(0, p).trim();
            String value = row.substring(p + 1).trim();
            settings.put(key, value);
        }
        in.close();
        return settings;
    }

    @Override
    public int getBookVersion(int id) throws IOException {
        String row;
        Object _id = Integer.toString(id);
        while (((String)_id).length() < 5) {
            _id = "0" + (String)_id;
        }
        File txt = new File(this.getBookDir(), (String)_id + "_en.txt");
        if (!txt.exists()) {
            return -1;
        }
        BufferedReader in = new BufferedReader(new FileReader(txt));
        while ((row = in.readLine()) != null) {
            if (!(row = row.trim()).startsWith("Book Version:")) continue;
            row = row.substring("Book Version:".length()).trim();
            in.close();
            return Integer.parseInt(row);
        }
        in.close();
        return -1;
    }

    @Override
    public void delete(int id) {
        Object _id = Integer.toString(id);
        while (((String)_id).length() < 5) {
            _id = "0" + (String)_id;
        }
        File txt = new File(this.getBookDir(), (String)_id + "_en.txt");
        File png = new File(this.getBookDir(), (String)_id + "_en.png");
        File ouf = new File(this.getBookDir(), (String)_id + "_en.kii");
        File src = new File(this.getBookDir(), (String)_id + "_en.src");
        txt.delete();
        png.delete();
        ouf.delete();
        if (src.exists()) {
            src.delete();
        }
    }

    @Override
    public void copyFromRepositoryToStick(int mid) throws IOException {
        Object _id = Integer.toString(mid);
        while (((String)_id).length() < 5) {
            _id = "0" + (String)_id;
        }
        File txt = new File(this.getBookDir(), (String)_id + "_en.txt");
        File png = new File(this.getBookDir(), (String)_id + "_en.png");
        File kii = new File(this.getBookDir(), (String)_id + "_en.kii");
        File src = new File(this.getBookDir(), (String)_id + "_en.src");
        File srcKii = Repository.getBookKii(mid);
        LOG.info("srcKii=" + String.valueOf(srcKii));
        if (srcKii == null || !srcKii.canRead()) {
            LOG.info("kii not found. try ouf...");
            srcKii = Repository.getBookOuf(mid);
        }
        LOG.info("copy kii...");
        BookiiStick.fileCopy(srcKii, kii);
        LOG.info("copy png...");
        BookiiStick.fileCopy(Repository.getBookPng(mid), png);
        File rSrc = Repository.getBookSrc(mid);
        if (rSrc != null && rSrc.exists()) {
            LOG.info("copy src...");
            BookiiStick.fileCopy(rSrc, src);
        }
        LOG.info("copy txt...");
        BookiiStick.fileCopy(Repository.getBookTxtFile(mid), txt);
    }

    @Override
    public void setTBD(LinkedList<Integer> newTbd) throws IOException {
        if (!this.tbdFile.canWrite()) {
            throw new FileNotFoundException(this.tbdFile.getAbsolutePath());
        }
        PrintWriter out = new PrintWriter(new FileWriter(this.tbdFile));
        Iterator i = newTbd.iterator();
        while (i.hasNext()) {
            Object id = Integer.toString((Integer)i.next());
            while (((String)id).length() < 5) {
                id = "0" + (String)id;
            }
            out.println((String)id);
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(ZipOutputStream zos, File file, LinkedList<String> stack) throws IOException {
        FileInputStream fis = null;
        if (file.isDirectory()) {
            stack.addLast(file.getName());
            File[] childs = file.listFiles();
            for (int i = 0; i < childs.length; ++i) {
                BookiiStick.zip(zos, childs[i], stack);
            }
            stack.pollLast();
        } else {
            try {
                int len;
                Object prefix = "";
                Iterator stackIt = stack.iterator();
                stackIt.next();
                while (stackIt.hasNext()) {
                    prefix = (String)prefix + (String)stackIt.next() + "/";
                }
                zos.putNextEntry(new ZipEntry((String)prefix + file.getName()));
                byte[] buffer = new byte[4096];
                fis = new FileInputStream(file);
                while ((len = fis.read(buffer, 0, buffer.length)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveStick(File target) throws IOException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(target));
            LinkedList<String> stack = new LinkedList<String>();
            BookiiStick.zip(zos, this.path, stack);
        }
        finally {
            if (zos != null) {
                try {
                    zos.closeEntry();
                    zos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void restoreStick(File source) throws IOException {
        ZipFile zipFile = new ZipFile(source);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        TreeSet<String> files = new TreeSet<String>(new Comparator<String>(this){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() < o2.length()) {
                    return -1;
                }
                if (o1.length() > o2.length()) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            files.add(zipEntry.getName());
        }
        for (String fileName : files) {
            int len;
            int p = fileName.lastIndexOf("/");
            if (p != -1) {
                new File(this.path, fileName.substring(0, p)).mkdirs();
            }
            FileOutputStream out = new FileOutputStream(new File(this.path, fileName));
            InputStream in = zipFile.getInputStream(zipFile.getEntry(fileName));
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer, 0, buffer.length)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        zipFile.close();
    }

    public static BookiiStick getStick() throws IOException {
        Set<BookiiStick> sticks = BookiiStick.getSticks();
        if (sticks.isEmpty()) {
            return null;
        }
        return sticks.iterator().next();
    }

    public static Set<BookiiStick> getSticks() throws IOException {
        File[] mounts;
        if (OS.isWindows()) {
            mounts = File.listRoots();
        } else {
            String row;
            LinkedList<File> mountList = new LinkedList<File>();
            Process process = new ProcessBuilder(OS.getMountCommand()).start();
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((row = in.readLine()) != null) {
                if (!(row = row.trim()).startsWith("/dev/")) continue;
                int p = row.indexOf(" on ");
                row = row.substring(p + " on ".length());
                p = row.indexOf(" ");
                row = row.substring(0, p);
                mountList.add(new File(row));
            }
            mounts = mountList.toArray(new File[0]);
        }
        HashSet<BookiiStick> sticks = new HashSet<BookiiStick>();
        for (File mount : mounts) {
            if (!BookiiStick.checkForStick(mount)) continue;
            sticks.add(new BookiiStick(mount));
        }
        return sticks;
    }

    @Override
    public void update(ProgressDialog progress) {
        this.update(null, progress);
    }

    @Override
    public boolean update(JFrame frame, ProgressDialog progress) {
        boolean result;
        block27: {
            result = true;
            try {
                LinkedList<Integer> books = this.getBooks();
                if (progress != null) {
                    progress.setMax(books.size());
                }
                Iterator ids = books.iterator();
                int c = 0;
                while (ids.hasNext()) {
                    if (progress != null) {
                        progress.setVal(c++);
                    }
                    int id = (Integer)ids.next();
                    LOG.info("checking id=" + id + "...");
                    try {
                        Repository.update(id, null);
                        LOG.info("repository update done");
                        HashMap<String, String> bookTxt = Repository.getBookTxt(id);
                        if (bookTxt == null) {
                            LOG.info("skipping book " + id + ". not found in repository");
                            continue;
                        }
                        int repositoryVersion = Integer.parseInt(Repository.getBookTxt(id).get("Book Version"));
                        LOG.info("repository version=" + repositoryVersion);
                        int stickVersion = -1;
                        try {
                            stickVersion = this.getBookVersion(id);
                        }
                        catch (IOException ioe) {
                            LOG.warn("failed to get book version from stick (mid=" + id + ")", (Throwable)ioe);
                        }
                        LOG.info("stick version=" + stickVersion);
                        if (stickVersion >= repositoryVersion) continue;
                        try {
                            LOG.info("copyFromRepositoryToStick...");
                            this.copyFromRepositoryToStick(id);
                            LOG.info("copy done");
                        }
                        catch (IOException ioe) {
                            LOG.warn("failed to copy book " + id + " from repository to stick", (Throwable)ioe);
                            if (frame != null) {
                                JOptionPane.showMessageDialog(frame, "Das Buch " + id + " konnte nicht auf den Stift kopiert werden");
                            }
                            result = false;
                        }
                    }
                    catch (IOException fnfe) {
                        LOG.info("book not found in repository (mid=" + id + "): perhaps a bookii only file", (Object)fnfe.toString());
                    }
                }
            }
            catch (IOException ioe) {
                LOG.warn("failed to get stick content: ", (Throwable)ioe);
                if (frame != null) {
                    JOptionPane.showMessageDialog(frame, "Auf den Stift konnte nicht zugegriffen werden");
                }
                result = false;
            }
            try {
                HashSet<Integer> tbdSet = this.getTBD();
                Iterator<Integer> tbds = tbdSet.iterator();
                if (progress != null) {
                    progress.restart("Verarbeite TBD.TXT");
                    progress.setMax(tbdSet.size());
                }
                LinkedList<Integer> newTbds = new LinkedList<Integer>();
                int c = 0;
                while (tbds.hasNext()) {
                    int id;
                    if (progress != null) {
                        progress.setVal(c++);
                    }
                    if (!Repository.txtExists(id = tbds.next().intValue())) {
                        Repository.search(id);
                    }
                    if (!Repository.txtExists(id)) {
                        newTbds.add(id);
                        continue;
                    }
                    try {
                        Repository.update(id, null);
                        this.copyFromRepositoryToStick(id);
                    }
                    catch (IOException ioe) {
                        LOG.warn("failed to copy book " + id + " from repository to stick", (Throwable)ioe);
                        if (frame != null) {
                            JOptionPane.showMessageDialog(frame, "Das Buch " + id + " konnte nicht auf den Stift kopiert werden");
                        }
                        result = false;
                        newTbds.add(id);
                    }
                }
                try {
                    this.setTBD(newTbds);
                }
                catch (IOException ioe) {
                    LOG.warn("failed to write TBD.TXT", (Throwable)ioe);
                }
            }
            catch (IOException ioe) {
                LOG.warn("unable to read TBD.TXT", (Throwable)ioe);
                if (frame == null) break block27;
                JOptionPane.showMessageDialog(frame, "Die Datei TBD.TXT auf dem Stift kann nicht gelesen werden");
                result = false;
            }
        }
        if (progress != null) {
            progress.done();
        }
        LOG.info("update on bookii stick done");
        return result;
    }

    @Override
    public void activateBook(int id) throws IOException {
    }

    @Override
    public File getBookOufOrKii(int mid) {
        Object _id = Integer.toString(mid);
        while (((String)_id).length() < 5) {
            _id = "0" + (String)_id;
        }
        return new File(this.getBookDir(), (String)_id + "_en.kii");
    }
}

