/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import tingeltangel.cli_ng.CLI;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.Book;

class DeleteBook
extends CliCmd {
    DeleteBook() {
    }

    @Override
    String getName() {
        return "delete-book";
    }

    @Override
    String getDescription() {
        return "delete-book <mid>";
    }

    @Override
    int execute(String[] args) {
        int mid;
        if (args.length != 1) {
            return this.error("falsche Anzahl von Parametern");
        }
        try {
            mid = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            return this.error("keine Zahl (1-9999) als Parameter angegeben");
        }
        if (mid < 1 || mid > 9999) {
            return this.error("ung\u00fcltige MID angegeben (1-9999)");
        }
        Book current = CLI.getBook();
        if (current.getID() == mid) {
            return this.error("Buch ist ge\u00f6ffnet. Ein ge\u00f6ffnetes Buch kann nicht gel\u00f6scht werden.");
        }
        if (!current.deleteBook(mid)) {
            return this.error("das Buch konnte nicht gel\u00f6scht werden.");
        }
        return this.ok();
    }
}

