/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.BookiiStickerConfig;
import tingeltangel.core.Codes;

public class BookiiSticker
extends CliCmd {
    @Override
    String getName() {
        return "bookii-sticker";
    }

    @Override
    String getDescription() {
        return "bookii-sticker 600|1200 <size in mm> <sticker id> <directory> [<override parity>]";
    }

    @Override
    int execute(String[] args) {
        int stickerId;
        int size;
        if (args.length < 4 || args.length > 5) {
            return this.error("falsche Anzahl von Parametern");
        }
        File dir = new File(args[3].trim());
        if (args[0].toLowerCase().equals("600")) {
            Codes.setResolution(0);
        } else if (args[0].toLowerCase().equals("1200")) {
            Codes.setResolution(1);
        } else {
            return this.error("Syntax Fehler");
        }
        try {
            size = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            return this.error("ung\u00fcltige Gro\u00dfe angegeben (5-500)");
        }
        if (size < 5 || size > 500) {
            return this.error("ung\u00fcltige Gro\u00dfe angegeben (5-500)");
        }
        try {
            stickerId = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException nfe) {
            return this.error("ung\u00fcltige Sticker-ID angegeben");
        }
        if (stickerId < 0 || stickerId > 65535) {
            return this.error("ung\u00fcltige Sticker-ID angegeben (0-65535)");
        }
        BookiiStickerConfig bsc = new BookiiStickerConfig();
        if (args.length == 5) {
            try {
                int pari = Integer.parseInt(args[4]);
                if (pari < 0 || pari > 3) {
                    return this.error("ung\u00fcltige Parit\u00e4t angegeben");
                }
                bsc.setPariForTesting(pari);
            }
            catch (NumberFormatException nfe) {
                return this.error("ung\u00fcltige Parit\u00e4t angegeben");
            }
        }
        try {
            String filename = "bookii_sticker_" + stickerId + ".png";
            FileOutputStream out = new FileOutputStream(new File(dir, filename));
            Codes.drawBookiiStickerPng(stickerId, size, size, bsc, out);
            out.close();
        }
        catch (IOException ioe) {
            return this.error("Sticker konnten nicht erzeugt werden", ioe);
        }
        return this.ok();
    }
}

