/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.andersicht.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tingeltangel.Tingeltangel;
import tingeltangel.andersicht.AndersichtBook;
import tingeltangel.andersicht.AndersichtLanguageLayer;
import tingeltangel.andersicht.gui.AndersichtChooseLabel;
import tingeltangel.andersicht.gui.AndersichtMainFrame;
import tingeltangel.andersicht.gui.DocumentAdapter;
import tingeltangel.tools.Callback;
import tingeltangel.tools.FileEnvironment;

public class AndersichtConfigureLanguageLayer
extends JDialog {
    private static final Logger LOG = LogManager.getLogger((String)AndersichtConfigureLanguageLayer.class.getCanonicalName());
    private JList languageList = new JList();
    private final JScrollPane jScrollPane = new JScrollPane();
    private JTextField name = new JTextField();
    private JTextField mp3 = new JTextField();
    private JTextArea description = new JTextArea();
    private JButton label = new JButton();
    private final AndersichtBook book;

    public AndersichtConfigureLanguageLayer(final AndersichtMainFrame parent, final AndersichtBook book) {
        super((Frame)parent, false);
        this.setTitle(Tingeltangel.MAIN_FRAME_TITLE + " - Sprachlayer");
        this.book = book;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.description.setRows(10);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 18;
        JButton setMp3Button = new JButton("MP3 ausw\u00e4hlen");
        setMp3Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndersichtLanguageLayer lLayer = (AndersichtLanguageLayer)AndersichtConfigureLanguageLayer.this.languageList.getSelectedValue();
                JFileChooser fc = new JFileChooser();
                fc.setFileFilter(new FileNameExtensionFilter("MP3 (*.mp3)", "mp3"));
                if (fc.showOpenDialog(parent) == 0) {
                    int bookId = book.getBookId();
                    File source = fc.getSelectedFile();
                    File targetDir = FileEnvironment.getAndersichtAudioDirectory(Integer.toString(bookId));
                    String uid = Integer.toString(targetDir.list().length);
                    File target = new File(targetDir, uid + "-" + source.getName());
                    try {
                        FileEnvironment.copy(source, target);
                        lLayer.setMP3(target);
                        if (lLayer.getInternalMP3() == null) {
                            AndersichtConfigureLanguageLayer.this.mp3.setText("<kein MP3>");
                        } else {
                            AndersichtConfigureLanguageLayer.this.mp3.setText(lLayer.getInternalMP3().getName());
                        }
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(parent, "Fehler importieren des MP3: " + ioe.getMessage());
                    }
                }
            }
        });
        gbc.weightx = 0.3;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel("Name"), gbc);
        gbc.gridy = 1;
        panel.add((Component)new JLabel("Beschreibung"), gbc);
        gbc.gridy = 2;
        panel.add((Component)new JLabel("Label"), gbc);
        gbc.gridy = 4;
        panel.add((Component)new JLabel("MP3"), gbc);
        gbc.weightx = 2.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        panel.add((Component)this.name, gbc);
        gbc.gridy = 1;
        panel.add((Component)this.description, gbc);
        gbc.gridy = 2;
        panel.add((Component)this.label, gbc);
        gbc.gridy = 3;
        panel.add((Component)setMp3Button, gbc);
        gbc.gridy = 4;
        panel.add((Component)this.mp3, gbc);
        final MyListModel model = new MyListModel();
        this.languageList.setModel(model);
        this.name.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void change() {
                AndersichtLanguageLayer lLayer = (AndersichtLanguageLayer)AndersichtConfigureLanguageLayer.this.languageList.getSelectedValue();
                if (lLayer != null) {
                    lLayer.setName(AndersichtConfigureLanguageLayer.this.name.getText());
                    model.refresh();
                    int selectedIndex = AndersichtConfigureLanguageLayer.this.languageList.getSelectedIndex();
                    DefaultComboBoxModel cbModel = parent.getAndersichtPanel().getLanguageChooserModel();
                    cbModel.removeElementAt(selectedIndex);
                    cbModel.insertElementAt(lLayer, selectedIndex);
                    AndersichtConfigureLanguageLayer.this.languageList.setSelectedIndex(selectedIndex);
                }
            }
        });
        this.description.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void change() {
                AndersichtLanguageLayer lLayer = (AndersichtLanguageLayer)AndersichtConfigureLanguageLayer.this.languageList.getSelectedValue();
                if (lLayer != null) {
                    lLayer.setDescription(AndersichtConfigureLanguageLayer.this.description.getText());
                }
            }
        });
        this.label.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AndersichtChooseLabel((Frame)parent, book.getPen(), new Callback<Integer>(){

                    @Override
                    public void callback(Integer _label) {
                        AndersichtLanguageLayer lLayer = (AndersichtLanguageLayer)AndersichtConfigureLanguageLayer.this.languageList.getSelectedValue();
                        if (lLayer != null) {
                            lLayer.setLabel(_label);
                            AndersichtConfigureLanguageLayer.this.label.setText(Integer.toString(_label));
                        }
                    }
                });
            }
        });
        JPanel buttonPanel = new JPanel();
        JButton addButton = new JButton("hinzuf\u00fcgen");
        JButton removeButton = new JButton("entfernen");
        JButton okButton = new JButton("OK");
        buttonPanel.add(addButton);
        buttonPanel.add(removeButton);
        buttonPanel.add(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndersichtConfigureLanguageLayer.this.dispose();
            }
        });
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndersichtLanguageLayer lLayer = book.addLanguageLayer("Name", "Beschreibung");
                model.refresh();
                DefaultComboBoxModel cbModel = parent.getAndersichtPanel().getLanguageChooserModel();
                cbModel.addElement(lLayer);
            }
        });
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndersichtLanguageLayer lLayer = (AndersichtLanguageLayer)AndersichtConfigureLanguageLayer.this.languageList.getSelectedValue();
                if (lLayer != null && model.getSize() > 1) {
                    book.removeLanguageLayer(lLayer);
                    model.refresh();
                    DefaultComboBoxModel cbModel = parent.getAndersichtPanel().getLanguageChooserModel();
                    cbModel.removeElement(lLayer);
                }
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        JPanel split = new JPanel();
        split.setLayout(new GridLayout(2, 1));
        split.add(this.jScrollPane);
        split.add(panel);
        this.getContentPane().add((Component)split, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.jScrollPane.setViewportView(this.languageList);
        this.languageList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AndersichtLanguageLayer lLayer = (AndersichtLanguageLayer)AndersichtConfigureLanguageLayer.this.languageList.getSelectedValue();
                AndersichtConfigureLanguageLayer.this.label.setText(book.getPen().fromTingId(lLayer.getLabel()));
                AndersichtConfigureLanguageLayer.this.name.setText(lLayer.getName());
                AndersichtConfigureLanguageLayer.this.description.setText(lLayer.getDescription());
                if (lLayer.getInternalMP3() == null) {
                    AndersichtConfigureLanguageLayer.this.mp3.setText("<kein MP3>");
                } else {
                    AndersichtConfigureLanguageLayer.this.mp3.setText(lLayer.getInternalMP3().getName());
                }
            }
        });
        this.setDefaultCloseOperation(2);
        AndersichtLanguageLayer lLayer = book.getLanguageLayer(0);
        this.languageList.setSelectedIndex(0);
        this.label.setText(book.getPen().fromTingId(lLayer.getLabel()));
        this.name.setText(lLayer.getName());
        this.description.setText(lLayer.getDescription());
        if (lLayer.getInternalMP3() == null) {
            this.mp3.setText("<kein MP3>");
        } else {
            this.mp3.setText(lLayer.getInternalMP3().getName());
        }
        model.refresh();
        this.setFocusable(false);
        this.setSize(500, 400);
        this.setVisible(true);
    }

    class MyListModel
    implements ListModel {
        private LinkedList<ListDataListener> listeners = new LinkedList();

        MyListModel() {
        }

        @Override
        public int getSize() {
            return AndersichtConfigureLanguageLayer.this.book.getLanguageLayerCount();
        }

        public Object getElementAt(int index) {
            return AndersichtConfigureLanguageLayer.this.book.getLanguageLayer(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        public void refresh() {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((ListDataListener)i.next()).contentsChanged(null);
            }
        }
    }
}

