/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.andersicht.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tingeltangel.Tingeltangel;
import tingeltangel.andersicht.AndersichtBook;
import tingeltangel.andersicht.AndersichtDescriptionLayer;
import tingeltangel.andersicht.gui.AndersichtMainFrame;
import tingeltangel.andersicht.gui.DocumentAdapter;

public class AndersichtConfigureDescriptionLayer
extends JDialog {
    private static final Logger LOG = LogManager.getLogger((String)AndersichtConfigureDescriptionLayer.class.getCanonicalName());
    private JList descriptionList = new JList();
    private final JScrollPane jScrollPane = new JScrollPane();
    private JTextField name = new JTextField();
    private JTextArea description = new JTextArea();
    private final AndersichtBook book;

    public AndersichtConfigureDescriptionLayer(final AndersichtMainFrame parent, final AndersichtBook book) {
        super((Frame)parent, false);
        this.setTitle(Tingeltangel.MAIN_FRAME_TITLE + " - Beschreibungslayer");
        this.book = book;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.3;
        panel.add((Component)new JLabel("Name"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        panel.add((Component)this.name, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.3;
        panel.add((Component)new JLabel("Beschreibung"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 2.0;
        panel.add((Component)this.description, gbc);
        final MyListModel model = new MyListModel();
        this.descriptionList.setModel(model);
        this.name.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void change() {
                AndersichtDescriptionLayer dLayer = (AndersichtDescriptionLayer)AndersichtConfigureDescriptionLayer.this.descriptionList.getSelectedValue();
                if (dLayer != null) {
                    dLayer.setName(AndersichtConfigureDescriptionLayer.this.name.getText());
                    model.refresh();
                }
            }
        });
        this.description.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            public void change() {
                AndersichtDescriptionLayer dLayer = (AndersichtDescriptionLayer)AndersichtConfigureDescriptionLayer.this.descriptionList.getSelectedValue();
                if (dLayer != null) {
                    dLayer.setDescription(AndersichtConfigureDescriptionLayer.this.description.getText());
                    model.refresh();
                }
            }
        });
        this.description.setRows(10);
        JPanel buttonPanel = new JPanel();
        JButton addButton = new JButton("hinzuf\u00fcgen");
        JButton removeButton = new JButton("entfernen");
        JButton okButton = new JButton("OK");
        buttonPanel.add(addButton);
        buttonPanel.add(removeButton);
        buttonPanel.add(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                parent.getAndersichtPanel().refresh();
                AndersichtConfigureDescriptionLayer.this.dispose();
            }
        });
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                book.addDescriptionLayer("Name", "Beschreibung");
                model.refresh();
            }
        });
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndersichtDescriptionLayer dLayer = (AndersichtDescriptionLayer)AndersichtConfigureDescriptionLayer.this.descriptionList.getSelectedValue();
                if (dLayer != null && model.getSize() > 1) {
                    book.removeDescriptionLayer(dLayer);
                    model.refresh();
                }
            }
        });
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridLayout(2, 1));
        centerPanel.add(this.jScrollPane);
        centerPanel.add(panel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)centerPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.jScrollPane.setViewportView(this.descriptionList);
        this.descriptionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AndersichtDescriptionLayer dLayer = (AndersichtDescriptionLayer)AndersichtConfigureDescriptionLayer.this.descriptionList.getSelectedValue();
                AndersichtConfigureDescriptionLayer.this.name.setText(dLayer.getName());
                AndersichtConfigureDescriptionLayer.this.description.setText(dLayer.getDescription());
            }
        });
        this.setDefaultCloseOperation(2);
        AndersichtDescriptionLayer dLayer = book.getDescriptionLayer(0);
        this.descriptionList.setSelectedIndex(0);
        this.name.setText(dLayer.getName());
        this.description.setText(dLayer.getDescription());
        model.refresh();
        this.setFocusable(false);
        this.setSize(500, 400);
        this.setVisible(true);
    }

    class MyListModel
    implements ListModel {
        private LinkedList<ListDataListener> listeners = new LinkedList();

        MyListModel() {
        }

        @Override
        public int getSize() {
            return AndersichtConfigureDescriptionLayer.this.book.getDescriptionLayerCount();
        }

        public Object getElementAt(int index) {
            return AndersichtConfigureDescriptionLayer.this.book.getDescriptionLayer(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        public void refresh() {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((ListDataListener)i.next()).contentsChanged(null);
            }
        }
    }
}

