/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public class MD5Sum {
    private static final HashMap<String, String> CACHE = new HashMap();

    private static String getFileID(File file) {
        String id = file.getAbsolutePath() + "|" + file.length() + "|" + file.lastModified();
        return id;
    }

    private static byte[] createChecksum(File file) throws IOException {
        int numRead;
        MessageDigest complete;
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        try {
            complete = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new Error(ex);
        }
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    public static String md5sum(File file) throws IOException {
        String fileID = MD5Sum.getFileID(file);
        String md5 = CACHE.get(fileID);
        if (md5 != null) {
            return md5;
        }
        byte[] b = MD5Sum.createChecksum(file);
        Object result = "";
        for (int i = 0; i < b.length; ++i) {
            result = (String)result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        CACHE.put(fileID, (String)result);
        System.out.println("md5(" + fileID + ")=" + (String)result);
        return result;
    }
}

