/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import tingeltangel.core.scripting.Command;
import tingeltangel.core.scripting.Commands;
import tingeltangel.gui.EditorFrame;

public class ReferenceFrame
extends JInternalFrame {
    private JEditorPane text = new JEditorPane();

    public ReferenceFrame(EditorFrame frame) {
        super("Code Referenz", true, true, true, true);
        this.setVisible(false);
        this.setBounds(315, 5, 600, 400);
        this.setDefaultCloseOperation(1);
        this.text.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        this.text.setEditable(false);
        this.setContentPane(new JScrollPane(this.text));
        StringBuilder r = new StringBuilder();
        Iterator<Command> i = Commands.iterator();
        while (i.hasNext()) {
            Command c = i.next();
            Object args = "";
            if (c.getNumberOfArguments() > 0) {
                if (c.firstArgumentIsLabel()) {
                    args = "[Label]";
                } else if (c.firstArgumentIsRegister()) {
                    args = "[Register]";
                } else if (c.firstArgumentIsValue()) {
                    args = "[Value]";
                }
            }
            if (c.getNumberOfArguments() > 1) {
                if (c.secondArgumentIsRegister()) {
                    args = (String)args + " [Register]";
                } else if (c.secondArgumentIsValue()) {
                    args = (String)args + " [Value]";
                }
            }
            Object hex = Integer.toHexString(c.getCode());
            while (((String)hex).length() < 4) {
                hex = "0" + (String)hex;
            }
            r.append("<tr><td>").append(c.getAsm()).append(" ").append((String)args).append("</td><td>");
            r.append(c.getDescription()).append("</td><td>0x").append((String)hex);
            r.append("</td></tr>");
        }
        try {
            String row;
            BufferedReader in = new BufferedReader(new FileReader("html/reference.html"));
            StringBuilder s = new StringBuilder();
            while ((row = in.readLine()) != null) {
                s.append(row.replace("%%REFERENCE%%", r.toString()));
            }
            in.close();
            this.text.setText(s.toString());
            this.text.setCaretPosition(0);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

