/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JPanel;

public class PushBorderLayout
implements LayoutManager2 {
    public static final Position LINE_START = Position.LINE_START;
    public static final Position LINE_END = Position.LINE_END;
    public static final Position PAGE_START = Position.PAGE_START;
    public static final Position PAGE_END = Position.PAGE_END;
    public static final Position CENTER = Position.CENTER;
    private final ArrayList<Element> elements = new ArrayList();

    private boolean closed() {
        return !this.elements.isEmpty() && this.elements.get((int)(this.elements.size() - 1)).position == Position.CENTER;
    }

    public static Component pad(int size) {
        JPanel p = new JPanel();
        p.setPreferredSize(new Dimension(size, size));
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints == null) {
                constraints = Position.CENTER;
            }
            if (this.closed()) {
                throw new IllegalStateException("Cannot add more components to a " + this.getClass().getName() + " after having added something in " + Position.CENTER.name() + " (or without parameter)");
            }
            if (!(constraints instanceof Position)) {
                throw new IllegalArgumentException("Only " + Position.class.getCanonicalName() + " constraints are allowed, found " + constraints.getClass().getCanonicalName());
            }
            for (Element e : this.elements) {
                if (e.component != comp) continue;
                throw new IllegalArgumentException("Cannot add a given component twice, check your code.");
            }
            this.elements.add(new Element(comp, (Position)((Object)constraints)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            for (Element e : this.elements) {
                if (e.component != comp) continue;
                this.elements.remove(e);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            Rectangle available = new Rectangle(insets.left, insets.top, target.getWidth() - insets.right - insets.left, target.getHeight() - insets.bottom - insets.top);
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            for (Element e : this.elements) {
                Component c = e.component;
                switch (e.position.asLeftToRight(ltr).ordinal()) {
                    case 0: {
                        c.setSize(c.getWidth(), available.height);
                        Dimension pref = c.getPreferredSize();
                        c.setBounds(available.x, available.y, pref.width, available.height);
                        available.x += pref.width;
                        available.width -= pref.width;
                        break;
                    }
                    case 1: {
                        c.setSize(c.getWidth(), available.height);
                        Dimension pref = c.getPreferredSize();
                        c.setBounds(available.x + available.width - pref.width, available.y, pref.width, available.height);
                        available.width -= pref.width;
                        break;
                    }
                    case 2: {
                        c.setSize(available.width, c.getHeight());
                        Dimension pref = c.getPreferredSize();
                        c.setBounds(available.x, available.y, available.width, pref.height);
                        available.y += pref.height;
                        available.height -= pref.height;
                        break;
                    }
                    case 3: {
                        c.setSize(available.width, c.getHeight());
                        Dimension pref = c.getPreferredSize();
                        c.setBounds(available.x, available.y + available.height - pref.height, available.width, pref.height);
                        available.height -= pref.height;
                        break;
                    }
                    case 4: {
                        c.setBounds(available.x, available.y, available.width, available.height);
                    }
                }
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return new Dimension(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension usedSize = new Dimension();
            Dimension minimalInsideSize = new Dimension();
            boolean sanityCheckStopped = false;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            for (Element e : this.elements) {
                if (sanityCheckStopped) {
                    throw new IllegalStateException("Internal illegal state, wrong components order.");
                }
                Component c = e.component;
                Dimension cDim = c.getPreferredSize();
                switch (e.position.asLeftToRight(ltr).ordinal()) {
                    case 4: {
                        sanityCheckStopped = true;
                        usedSize.width += cDim.width;
                        usedSize.height += cDim.height;
                        break;
                    }
                    case 0: 
                    case 1: {
                        usedSize.width += cDim.width;
                        minimalInsideSize.width = Math.max(0, minimalInsideSize.width - cDim.width);
                        minimalInsideSize.height = Math.max(minimalInsideSize.height, cDim.height);
                        break;
                    }
                    case 2: 
                    case 3: {
                        usedSize.height += cDim.height;
                        minimalInsideSize.width = Math.max(minimalInsideSize.width, cDim.width);
                        minimalInsideSize.height = Math.max(0, minimalInsideSize.height - cDim.height);
                    }
                }
            }
            usedSize.width += minimalInsideSize.width;
            usedSize.height += minimalInsideSize.height;
            Insets insets = target.getInsets();
            usedSize.width += insets.left + insets.right;
            usedSize.height += insets.top + insets.bottom;
            return usedSize;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new UnsupportedOperationException();
    }

    private static class Element {
        Component component;
        Position position;

        public Element(Component component, Position position) {
            this.component = component;
            this.position = position;
        }
    }

    public static enum Position {
        LINE_START,
        LINE_END,
        PAGE_START,
        PAGE_END,
        CENTER;


        private Position asLeftToRight(boolean leftToRight) {
            if (leftToRight) {
                return this;
            }
            switch (this.ordinal()) {
                case 0: {
                    return PAGE_START;
                }
                case 1: {
                    return PAGE_END;
                }
                case 2: {
                    return LINE_START;
                }
                case 3: {
                    return LINE_END;
                }
                case 4: {
                    return CENTER;
                }
            }
            throw new RuntimeException("Should not be possible");
        }
    }
}

