/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import java.util.logging.Logger;
import javax.swing.JFrame;
import tingeltangel.core.BookiiStick;
import tingeltangel.core.TingStick;
import tingeltangel.tools.MD5Sum;
import tingeltangel.tools.ProgressDialog;

public abstract class Stick {
    private static final Logger log = Logger.getLogger("tingeltangel");
    private static final String UID_FILE = "tt.uid";
    private static final String UNNAMED = "unnamed";

    public abstract String getType();

    public static Stick getAnyStick() throws IOException {
        Stick stick = TingStick.getStick();
        if (stick != null) {
            return stick;
        }
        stick = BookiiStick.getStick();
        if (stick != null) {
            return stick;
        }
        return null;
    }

    public String getUID() throws IOException {
        String row;
        File uidFile = new File(this.getBookDir(), UID_FILE);
        if (!uidFile.exists()) {
            String uid = UUID.randomUUID().toString();
            PrintWriter out = new PrintWriter(new FileWriter(uidFile));
            out.println("uid:" + uid);
            out.println("name:unnamed");
            out.close();
            return uid;
        }
        BufferedReader in = new BufferedReader(new FileReader(uidFile));
        while ((row = in.readLine()) != null) {
            int p = row.indexOf(":");
            if (p == -1) continue;
            String key = row.substring(0, p).trim();
            String value = row.substring(p + 1).trim();
            if (!key.equals("uid")) continue;
            in.close();
            return value;
        }
        in.close();
        uidFile.delete();
        return this.getUID();
    }

    public String getName() throws IOException {
        String row;
        File uidFile = new File(this.getBookDir(), UID_FILE);
        if (!uidFile.exists()) {
            return UNNAMED;
        }
        BufferedReader in = new BufferedReader(new FileReader(uidFile));
        while ((row = in.readLine()) != null) {
            int p = row.indexOf(":");
            if (p == -1) continue;
            String key = row.substring(0, p).trim();
            String value = row.substring(p + 1).trim();
            if (!key.equals("name")) continue;
            in.close();
            return value;
        }
        in.close();
        uidFile.delete();
        return UNNAMED;
    }

    public void setName(String name) throws IOException {
        String uid = this.getUID();
        File uidFile = new File(this.getBookDir(), UID_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(uidFile));
        out.println("uid:" + uid);
        out.println("name:" + name);
        out.close();
    }

    public abstract boolean isBookii();

    public abstract long getFreeSpace();

    public abstract File getTBDFile();

    public abstract HashSet<Integer> getTBD() throws IOException;

    public abstract LinkedList<Integer> getBooks() throws IOException;

    public abstract File getBookDir();

    public File getPngFile(int mid) {
        Object _id = Integer.toString(mid);
        while (((String)_id).length() < 5) {
            _id = "0" + (String)_id;
        }
        return new File(this.getBookDir(), (String)_id + "_en.png");
    }

    static final void fileCopy(File source, File target) throws IOException {
        int k;
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(target);
        byte[] buffer = new byte[4096];
        while ((k = ((InputStream)in).read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, k);
        }
        ((OutputStream)out).close();
        ((InputStream)in).close();
    }

    public HashMap<String, String> getBookTxt(int mid) throws IOException {
        String row;
        Object _id = Integer.toString(mid);
        while (((String)_id).length() < 5) {
            _id = "0" + (String)_id;
        }
        File txt = new File(this.getBookDir(), (String)_id + "_en.txt");
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(txt), "UTF-8"));
        HashMap<String, String> data = new HashMap<String, String>();
        while ((row = in.readLine()) != null) {
            if ((row = row.trim()).isEmpty()) continue;
            int p = row.indexOf(":");
            if (p > 0) {
                String key = row.substring(0, p).trim();
                String value = row.substring(p + 1).trim();
                data.put(key, value);
                continue;
            }
            throw new IOException("txt file broken");
        }
        in.close();
        return data;
    }

    public abstract void setSettings(HashMap<String, String> var1) throws IOException;

    public abstract HashMap<String, String> getSettings() throws IOException;

    public abstract int getBookVersion(int var1) throws IOException;

    public abstract void delete(int var1);

    public abstract void copyFromRepositoryToStick(int var1) throws IOException;

    public abstract void setTBD(LinkedList<Integer> var1) throws IOException;

    public abstract void saveStick(File var1) throws IOException;

    public abstract void restoreStick(File var1) throws IOException;

    public abstract void update(ProgressDialog var1);

    public abstract boolean update(JFrame var1, ProgressDialog var2);

    public abstract void activateBook(int var1) throws IOException;

    public abstract File getBookOufOrKii(int var1);

    public String validateBooks(ProgressDialog progress) throws IOException {
        LinkedList<Integer> bookList = this.getBooks();
        if (progress != null) {
            progress.restart("erstelle Pr\u00fcfsummen");
            progress.setMax(bookList.size());
        }
        int c = 0;
        Object msg = "";
        Iterator books = this.getBooks().iterator();
        while (books.hasNext()) {
            int mid = (Integer)books.next();
            if (progress != null) {
                progress.setVal(++c);
            }
            try {
                File oufOrKii;
                String md5_file;
                HashMap<String, String> txt = this.getBookTxt(mid);
                if (txt == null) continue;
                String md5_txt = txt.get("FileMD5").toLowerCase();
                String bookName = txt.get("Name");
                if (md5_txt == null || md5_txt.equals(md5_file = MD5Sum.md5sum(oufOrKii = this.getBookOufOrKii(mid)).toLowerCase())) continue;
                msg = (String)msg + "Pr\u00fcfsummenfehler f\u00fcr Buch '" + bookName + "' (mid=" + mid + ")\n";
            }
            catch (IOException ioe) {
                log.warning("error validation book (mid=" + mid + "):" + ioe.toString());
            }
        }
        if (((String)msg).isEmpty()) {
            msg = null;
        }
        return msg;
    }
}

