/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tingeltangel.tools.Preferences;

public class Properties {
    private static final String PROPERTY_FILE = "tt.properties";
    private static final Logger LOG = LogManager.getLogger((String)Properties.class.getCanonicalName());
    private static final HashMap<String, String> PROPERTIES = new HashMap();

    private static void save() {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(PROPERTY_FILE));
            for (String key : PROPERTIES.keySet()) {
                out.println(key + " = " + PROPERTIES.get(key));
            }
            out.close();
        }
        catch (IOException ioe) {
            LOG.warn("property file can not be saved. Your changes will be lost on next start.", (Throwable)ioe);
        }
    }

    private static void setProperty(String name, String value, boolean save) {
        name = name.trim();
        if (value == null) {
            PROPERTIES.remove(name);
        } else {
            PROPERTIES.put(name, value.trim());
        }
        if (save) {
            Properties.save();
        }
    }

    public static void setProperty(String name, int value) {
        Properties.setProperty(name, Integer.toString(value), true);
    }

    public static void setProperty(String name, String value) {
        Properties.setProperty(name, value, true);
    }

    public static String getStringProperty(String name) {
        return PROPERTIES.get(name.trim());
    }

    public static void setProperty(String name, boolean value) {
        Properties.setProperty(name, Boolean.toString(value), true);
    }

    public static int getIntegerProperty(String name) {
        try {
            return Integer.parseInt(PROPERTIES.get(name));
        }
        catch (NumberFormatException nfe) {
            throw new Error("property '" + name.trim() + "' is not of type int");
        }
    }

    public static boolean getBooleanProperty(String name) {
        try {
            return Boolean.parseBoolean(PROPERTIES.get(name));
        }
        catch (NumberFormatException nfe) {
            throw new Error("property '" + name.trim() + "' is not of type bool");
        }
    }

    static {
        try {
            String row;
            File propertyFile = new File(PROPERTY_FILE);
            if (propertyFile.createNewFile()) {
                for (String key : Preferences.getKeys()) {
                    Properties.setProperty(key, Preferences.getDefault(key), false);
                }
                Properties.save();
            }
            BufferedReader in = new BufferedReader(new FileReader(propertyFile));
            while ((row = in.readLine()) != null) {
                if ((row = row.trim()).isEmpty() || row.startsWith("#")) continue;
                int p = row.indexOf("=");
                if (p == -1) {
                    throw new IOException();
                }
                PROPERTIES.put(row.substring(0, p).trim(), row.substring(p + 1).trim());
            }
            in.close();
            for (String key : Preferences.getKeys()) {
                if (PROPERTIES.containsKey(key)) continue;
                Properties.setProperty(key, Preferences.getDefault(key), false);
            }
            Properties.save();
        }
        catch (IOException ioe) {
            LOG.error("unable to read property file", (Throwable)ioe);
            throw new Error(ioe);
        }
    }
}

