/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import tingeltangel.cli_ng.CLI;
import tingeltangel.cli_ng.CliCmd;

class GetEntryScript
extends CliCmd {
    GetEntryScript() {
    }

    @Override
    String getName() {
        return "get-entry-script";
    }

    @Override
    String getDescription() {
        return "get-entry-script <oid>";
    }

    @Override
    int execute(String[] args) {
        int oid;
        if (args.length != 1) {
            return this.error("falsche Anzahl von Parametern");
        }
        try {
            oid = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            return this.error("OID keine Zahl zw. 15001 und 65535");
        }
        if (oid < 15001 || oid > 65535) {
            return this.error("OID keine Zahl zw. 15001 und 65535");
        }
        if (!CLI.bookOpened()) {
            return this.error("kein Buch ge\u00f6ffnet");
        }
        if (!CLI.getBook().entryForTingIDExists(oid)) {
            return this.error("OID nicht gefunden");
        }
        if (!CLI.getBook().getEntryByOID(oid).isTTS()) {
            return this.error("OID ist nicht vom Typ Script oder Sub-Script");
        }
        System.out.println(CLI.getBook().getEntryByOID(oid).getScript().toString());
        return this.ok();
    }
}

