/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.Codes;

class GenerateCodesPage
extends CliCmd {
    GenerateCodesPage() {
    }

    @Override
    public String getName() {
        return "generate-codes-page";
    }

    @Override
    public String getDescription() {
        return "generate-codes-page 600|1200 <code width in mm> <code height in mm> <png file> <list of codes>";
    }

    @Override
    public int execute(String[] args) {
        String[] elements;
        int height;
        int width;
        if (args.length != 5) {
            return this.error("falsche Anzahl von Parametern angegeben");
        }
        File file = new File(args[3].trim());
        if (args[0].toLowerCase().equals("600")) {
            Codes.setResolution(0);
        } else if (args[0].toLowerCase().equals("1200")) {
            Codes.setResolution(1);
        } else {
            return this.error("Syntax Fehler");
        }
        try {
            width = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            return this.error("ung\u00fcltige Gro\u00dfe angegeben (5-100)");
        }
        if (width < 5 || width > 100) {
            return this.error("ung\u00fcltige Gro\u00dfe angegeben (5-100)");
        }
        try {
            height = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            return this.error("ung\u00fcltige Gro\u00dfe angegeben (5-100)");
        }
        if (height < 5 || height > 100) {
            return this.error("ung\u00fcltige Gro\u00dfe angegeben (5-100)");
        }
        LinkedList<Integer> _codes = new LinkedList<Integer>();
        for (String element : elements = args[4].split(",")) {
            int p = element.indexOf("-");
            if (p == -1) {
                int c = Integer.parseInt(element.trim());
                _codes.add(c);
                continue;
            }
            int s = Integer.parseInt(element.substring(0, p).trim());
            int e = Integer.parseInt(element.substring(p + 1).trim());
            for (int k = s; k <= e; ++k) {
                _codes.add(k);
            }
        }
        int[] codes = new int[_codes.size()];
        for (int i = 0; i < codes.length; ++i) {
            codes[i] = (Integer)_codes.get(i);
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            Codes.drawPagePNG(codes, width, height, out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            return this.error("Codes konnten nicht erzeugt werden", e);
        }
        return this.ok();
    }
}

