/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import tingeltangel.cli_ng.CLI;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.Book;
import tingeltangel.tools.FileEnvironment;

class ChangeMid
extends CliCmd {
    ChangeMid() {
    }

    @Override
    String getName() {
        return "change-mid";
    }

    @Override
    String getDescription() {
        return "change-mid <new mid>";
    }

    @Override
    int execute(String[] args) {
        int mid;
        if (args.length != 1) {
            return this.error("falsche Anzahl von Parametern");
        }
        try {
            mid = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            return this.error("MID keine Zahl zw. 1 und " + Integer.toString(9999));
        }
        if (mid < 1 || mid > 9999) {
            return this.error("MID keine Zahl zw. 1 und " + Integer.toString(9999));
        }
        if (!CLI.bookOpened()) {
            return this.error("kein Buch ge\u00f6ffnet");
        }
        if (CLI.getBook().getID() == mid) {
            return this.error("gleiche MID angegeben");
        }
        if (Book.getBookMIDs().contains(mid)) {
            return this.error("MID wird schon von einem anderen Buch genutzt");
        }
        Object _id = Integer.toString(mid);
        while (((String)_id).length() < 5) {
            _id = "0" + (String)_id;
        }
        try {
            Book book = CLI.getBook();
            int oldID = book.getID();
            book.setID(mid);
            book.save();
            File[] audios = FileEnvironment.getAudioDirectory(oldID).listFiles(new FilenameFilter(this){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".mp3");
                }
            });
            File destAudioDir = FileEnvironment.getAudioDirectory(mid);
            for (int i = 0; i < audios.length; ++i) {
                FileEnvironment.copy(audios[i], new File(destAudioDir, audios[i].getName()));
            }
            book.clear();
            book.setID(mid);
            Book.loadXML(FileEnvironment.getXML(mid), book, null);
            book.resetChangeMade();
            book.deleteBook(oldID);
        }
        catch (IOException e) {
            return this.error("MID konnte nicht ge\u00e4ndert werden", e);
        }
        return this.ok();
    }
}

