/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.andersicht.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tingeltangel.andersicht.gui.AndersichtBookDefinition;
import tingeltangel.andersicht.pen.Pen;
import tingeltangel.andersicht.pen.Pens;
import tingeltangel.tools.Callback;
import tingeltangel.tools.FileEnvironment;

public class AndersichtNewBook
extends JDialog {
    private final LinkedList<Integer> idList = new LinkedList();
    private static final Logger LOG = LogManager.getLogger((String)AndersichtNewBook.class.getCanonicalName());
    private JList bookList = new JList();
    private JButton button = new JButton();
    private JScrollPane jScrollPane = new JScrollPane();
    private JTextField bookName = new JTextField();
    private JTextField bookDescription = new JTextField();
    private JComboBox penChooser;

    public AndersichtNewBook(Frame parent, final Callback<AndersichtBookDefinition> callback) {
        super(parent, false);
        int i;
        this.bookName.setText("Buchname");
        this.bookDescription.setText("Buchbeschreibung");
        this.penChooser = new JComboBox<Pen>(Pens.getPenArray());
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new GridLayout(4, 2));
        southPanel.add(new JLabel("Buchname"));
        southPanel.add(this.bookName);
        southPanel.add(new JLabel("Buchbeschreibung"));
        southPanel.add(this.bookDescription);
        southPanel.add(new JLabel("Labeltyp"));
        southPanel.add(this.penChooser);
        southPanel.add(new JLabel(""));
        southPanel.add(this.button);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        this.getContentPane().add((Component)southPanel, "South");
        this.jScrollPane.setViewportView(this.bookList);
        MyListModel model = new MyListModel();
        this.bookList.setModel(model);
        this.button.setText("OK");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = AndersichtNewBook.this.bookList.getSelectedIndex();
                if (index != -1) {
                    AndersichtBookDefinition def = new AndersichtBookDefinition();
                    def.bookId = AndersichtNewBook.this.idList.get(index);
                    def.name = AndersichtNewBook.this.bookName.getText();
                    def.description = AndersichtNewBook.this.bookDescription.getText();
                    def.pen = (Pen)AndersichtNewBook.this.penChooser.getSelectedItem();
                    callback.callback(def);
                    AndersichtNewBook.this.setVisible(false);
                }
            }
        });
        this.setDefaultCloseOperation(2);
        HashSet<Integer> inUse = new HashSet<Integer>();
        File[] books = FileEnvironment.getAndersichtDirectory().listFiles();
        for (i = 0; i < books.length; ++i) {
            if (!books[i].isDirectory()) continue;
            try {
                int id = Integer.parseInt(books[i].getName());
                if (id == 15000) continue;
                inUse.add(id);
                continue;
            }
            catch (NumberFormatException nfe) {
                LOG.warn("unable to parse book", (Throwable)nfe);
            }
        }
        for (i = 1; i < 10000; ++i) {
            if (inUse.contains(i)) continue;
            this.idList.add(i);
        }
        model.refresh();
        this.setFocusable(false);
        this.pack();
        this.setVisible(true);
    }

    class MyListModel
    implements ListModel {
        private LinkedList<ListDataListener> listeners = new LinkedList();

        MyListModel() {
        }

        @Override
        public int getSize() {
            return AndersichtNewBook.this.idList.size();
        }

        public Object getElementAt(int index) {
            return AndersichtNewBook.this.idList.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        public void refresh() {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((ListDataListener)i.next()).contentsChanged(null);
            }
        }
    }
}

