/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.andersicht;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import tingeltangel.andersicht.AndersichtBook;
import tingeltangel.andersicht.AndersichtDescriptionLayer;
import tingeltangel.andersicht.AndersichtObject;
import tingeltangel.tools.FileEnvironment;

public class AndersichtTrack
implements TreeNode {
    private File internalFile = null;
    private String transcript = "Transkript";
    private final AndersichtObject object;
    private final AndersichtDescriptionLayer descriptionLayer;

    AndersichtTrack(AndersichtObject object, AndersichtDescriptionLayer descriptionLayer) {
        this.descriptionLayer = descriptionLayer;
        this.object = object;
    }

    public AndersichtObject getObject() {
        return this.object;
    }

    public String toString() {
        Object _t = this.transcript;
        if (((String)_t).length() > 20) {
            _t = ((String)_t).substring(0, 17) + "...";
        }
        return String.valueOf(this.descriptionLayer) + ": " + (String)_t;
    }

    public String getTranscript() {
        return this.transcript;
    }

    public void setTranscript(String transcript) {
        if (!this.transcript.equals(transcript)) {
            this.transcript = transcript;
            this.getBook().changeMade();
        }
    }

    void load(DataInputStream in, int bookId) throws IOException {
        File audioDir = FileEnvironment.getAndersichtAudioDirectory(Integer.toString(bookId));
        String fn = in.readUTF();
        if (!fn.isEmpty()) {
            this.internalFile = new File(audioDir, fn);
            if (!this.internalFile.canRead()) {
                throw new IOException("Kann MP3 " + this.internalFile.getAbsolutePath() + " nicht finden");
            }
        } else {
            this.internalFile = null;
        }
        this.transcript = in.readUTF();
    }

    void save(DataOutputStream out) throws IOException {
        if (this.internalFile == null) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.internalFile.getName());
        }
        out.writeUTF(this.transcript);
    }

    private AndersichtBook getBook() {
        return this.object.getGroup().getBook();
    }

    public void setMP3(File file) throws IOException {
        if (this.internalFile == null || !this.internalFile.getAbsolutePath().equals(file.getAbsolutePath())) {
            this.internalFile = file;
            this.getBook().changeMade();
        }
    }

    public File getInternalMP3() {
        return this.internalFile;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public TreeNode getParent() {
        return this.object;
    }

    @Override
    public int getIndex(TreeNode node) {
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public Enumeration children() {
        return new Enumeration(this){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
    }
}

