/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.andersicht;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import tingeltangel.andersicht.AndersichtBook;
import tingeltangel.andersicht.AndersichtDescriptionLayer;
import tingeltangel.andersicht.AndersichtGroup;
import tingeltangel.andersicht.AndersichtLanguageLayer;
import tingeltangel.andersicht.AndersichtObject;
import tingeltangel.andersicht.AndersichtTrack;
import tingeltangel.core.Book;
import tingeltangel.core.Entry;
import tingeltangel.core.Script;
import tingeltangel.core.Translator;
import tingeltangel.core.Tripel;
import tingeltangel.core.scripting.SyntaxError;

public class AndersichtBookGenerator {
    private final AndersichtBook book;
    private final File ouf;

    private AndersichtBookGenerator(AndersichtBook book, File ouf) {
        this.book = book;
        this.ouf = ouf;
    }

    static void generate(AndersichtBook book, File ouf) throws IOException {
        new AndersichtBookGenerator(book, ouf).generate();
    }

    private void generate() throws IOException {
        int oid;
        int d;
        AndersichtObject object;
        int g;
        int l;
        int i;
        TreeSet<Integer> freeIDsSet = new TreeSet<Integer>();
        for (i = Translator.getMinObjectCode(); i < 65536; ++i) {
            freeIDsSet.add(i);
        }
        for (i = 0; i < this.book.getLanguageLayerCount(); ++i) {
            freeIDsSet.remove(this.book.getLanguageLayer(i).getLabel());
        }
        for (int g2 = 0; g2 < this.book.getGroupCount(); ++g2) {
            AndersichtGroup group = this.book.getGroup(g2);
            for (int o = 0; o < group.getObjectCount(); ++o) {
                AndersichtObject object2 = group.getObject(o);
                for (l = 0; l < this.book.getDescriptionLayerCount(); ++l) {
                    freeIDsSet.remove(object2.getLabelAsInt(this.book.getDescriptionLayer(l)));
                }
            }
        }
        Iterator freeIDs = freeIDsSet.iterator();
        Book _book = new Book(this.book.getBookId());
        HashMap<Tripel<AndersichtObject, AndersichtLanguageLayer, AndersichtDescriptionLayer>, Integer> objectTracks = new HashMap<Tripel<AndersichtObject, AndersichtLanguageLayer, AndersichtDescriptionLayer>, Integer>();
        HashMap<AndersichtLanguageLayer, Integer> languageTracks = new HashMap<AndersichtLanguageLayer, Integer>();
        for (g = 0; g < this.book.getGroupCount(); ++g) {
            AndersichtGroup group = this.book.getGroup(g);
            for (int o = 0; o < group.getObjectCount(); ++o) {
                object = group.getObject(o);
                for (d = 0; d < this.book.getDescriptionLayerCount(); ++d) {
                    for (int l2 = 0; l2 < this.book.getLanguageLayerCount(); ++l2) {
                        oid = (Integer)freeIDs.next();
                        Tripel<AndersichtObject, AndersichtLanguageLayer, AndersichtDescriptionLayer> key = new Tripel<AndersichtObject, AndersichtLanguageLayer, AndersichtDescriptionLayer>(object, this.book.getLanguageLayer(l2), this.book.getDescriptionLayer(d));
                        objectTracks.put(key, oid);
                        AndersichtTrack aTrack = object.getTrack(this.book.getLanguageLayer(l2), this.book.getDescriptionLayer(d));
                        _book.addEntry(oid);
                        Entry entry = _book.getEntryByOID(oid);
                        entry.setMP3(aTrack.getInternalMP3());
                    }
                }
            }
        }
        for (l = 0; l < this.book.getLanguageLayerCount(); ++l) {
            int oid2 = (Integer)freeIDs.next();
            languageTracks.put(this.book.getLanguageLayer(l), oid2);
            _book.addEntry(oid2);
            Entry entry = _book.getEntryByOID(oid2);
            entry.setMP3(this.book.getLanguageLayer(l).getInternalMP3());
        }
        for (l = 0; l < this.book.getLanguageLayerCount(); ++l) {
            AndersichtLanguageLayer lLayer = this.book.getLanguageLayer(l);
            _book.addEntry(lLayer.getLabel());
            Entry entry = _book.getEntryByOID(lLayer.getLabel());
            Object code = "";
            code = (String)code + "set V0, " + lLayer.getId() + "\n";
            code = (String)code + "playoid " + String.valueOf(languageTracks.get(lLayer)) + "\n";
            code = (String)code + "end\n";
            entry.setScript(new Script((String)code, entry));
        }
        for (g = 0; g < this.book.getGroupCount(); ++g) {
            AndersichtGroup group = this.book.getGroup(g);
            for (int o = 0; o < group.getObjectCount(); ++o) {
                object = group.getObject(o);
                for (d = 0; d < this.book.getDescriptionLayerCount(); ++d) {
                    AndersichtDescriptionLayer dLayer = this.book.getDescriptionLayer(d);
                    oid = object.getLabelAsInt(dLayer);
                    _book.addEntry(oid);
                    Entry entry = _book.getEntryByOID(oid);
                    Object code = "";
                    int labelCounter = 0;
                    for (int l3 = 0; l3 < this.book.getLanguageLayerCount(); ++l3) {
                        AndersichtLanguageLayer lLayer = this.book.getLanguageLayer(l3);
                        Tripel<AndersichtObject, AndersichtLanguageLayer, AndersichtDescriptionLayer> key = new Tripel<AndersichtObject, AndersichtLanguageLayer, AndersichtDescriptionLayer>(object, lLayer, dLayer);
                        int playoid = (Integer)objectTracks.get(key);
                        code = (String)code + "cmp v0, " + Integer.toString(lLayer.getId()) + "\n";
                        code = (String)code + "jne L" + Integer.toString(labelCounter) + "\n";
                        code = (String)code + "playoid " + Integer.toString(playoid) + "\n";
                        code = (String)code + "jmp end\n";
                        code = (String)code + ":L" + Integer.toString(labelCounter) + "\n";
                        ++labelCounter;
                    }
                    code = (String)code + ":end\n";
                    code = (String)code + "end\n";
                    entry.setScript(new Script((String)code, entry));
                }
            }
        }
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this.ouf));
        try {
            _book.generateOufFile(out, null);
        }
        catch (SyntaxError se) {
            throw new IOException(se);
        }
    }
}

