/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel;

import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tingeltangel.andersicht.gui.AndersichtMainFrame;
import tingeltangel.cli_ng.CLI;
import tingeltangel.core.Codes;
import tingeltangel.core.Properties;
import tingeltangel.core.Repository;
import tingeltangel.gui.EditorFrame;
import tingeltangel.gui.ManagerFrame;

public class Tingeltangel {
    public static int MAIN_FRAME_POS_X = 50;
    public static int MAIN_FRAME_POS_Y = 50;
    public static int MAIN_FRAME_WIDTH = 1200;
    public static int MAIN_FRAME_HEIGHT = 700;
    public static String MAIN_FRAME_TITLE = "Tingeltangel";
    public static String ANDERSICHT_FRAME_TITLE = "Tingeltangel (Andersicht GUI)";
    public static String MAIN_FRAME_VERSION = " v0.9";
    public static final String BASE_URL = "http://13.80.138.170/book-files";
    public static final String DEFAULT_AREA_CODE = "en";
    private static final Logger LOG = LogManager.getLogger((String)Tingeltangel.class.getCanonicalName());

    public static void main(String[] args) throws Exception {
        LOG.info("Starting Tingeltangel" + MAIN_FRAME_VERSION);
        LOG.info("\tos.name     : " + System.getProperty("os.name"));
        LOG.info("\tos.version  : " + System.getProperty("os.version"));
        LOG.info("\tos.arch     : " + System.getProperty("os.arch"));
        LOG.info("\tjava.version: " + System.getProperty("java.version"));
        LOG.info("\tjava.vendor : " + System.getProperty("java.vendor"));
        boolean startEditor = false;
        boolean startManager = false;
        boolean startAndersicht = false;
        if (args.length > 0 && args[0].toLowerCase().equals("gui-editor") || args.length == 0) {
            startEditor = true;
        }
        if (args.length > 0 && args[0].toLowerCase().equals("gui-manager")) {
            startManager = true;
        }
        if (args.length > 0 && args[0].toLowerCase().equals("andersicht")) {
            startAndersicht = true;
        }
        boolean doInitialUpdate = true;
        if (args.length > 1 && args[1].toLowerCase().equals("disable-official-books") || startAndersicht) {
            doInitialUpdate = false;
        }
        final boolean _doInitialUpdate = doInitialUpdate;
        if (Properties.getStringProperty("resolution").equals("1200")) {
            Codes.setResolution(1);
        } else {
            Codes.setResolution(0);
        }
        Codes.loadProperties();
        final boolean _startEditor = startEditor;
        if (startManager || startEditor) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Repository.getIDs().length == 0 && _doInitialUpdate) {
                        Tingeltangel.startGUI(_startEditor);
                    } else {
                        Tingeltangel.startGUI(_startEditor);
                    }
                }
            });
        } else if (args.length > 0 && args[0].toLowerCase().equals("cli")) {
            CLI.init();
            String clicmd = "";
            if (args.length > 1) {
                clicmd = args[1];
            }
            CLI.run(clicmd);
        } else if (startAndersicht) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new AndersichtMainFrame();
                }
            });
        } else if (args.length == 0) {
            CLI.init();
            CLI.run("");
        }
    }

    private static void startGUI(boolean startEditor) {
        if (startEditor) {
            new EditorFrame();
        } else {
            new ManagerFrame();
        }
    }
}

