/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import tingeltangel.core.Codes;
import tingeltangel.core.Translator;

public class GenerateTestCodes {
    private static final int TING_ID = 9999;
    private static final int CODE_ID = Translator.ting2code(9999);

    public static void main(String[] args) throws Exception {
        GenerateTestCodes.generate600dpi();
        GenerateTestCodes.generate1200dpi(1);
        GenerateTestCodes.generate1200dpi(2);
        GenerateTestCodes.generate1200dpi(3);
    }

    private static void generate1200dpi(int page) throws Exception {
        int patternMin = 12;
        int patternMax = 14;
        if (page == 2) {
            patternMin = 15;
            patternMax = 17;
        } else if (page == 3) {
            patternMin = 18;
            patternMax = 20;
        }
        int PATTERN_WIDTH = 10;
        int PATTERN_HEIGHT = 10;
        int PATTERN_DX = 10;
        int PATTERN_DY = 30;
        Codes.setResolution(1);
        float ppm = Codes.PNG_PIXEL_PER_MM[1];
        int imageWidth = Codes.A4_WIDTH[1];
        int imageHeight = Codes.A4_HEIGHT[1];
        BufferedImage image1200 = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D graphics1200 = image1200.createGraphics();
        graphics1200.setColor(Color.white);
        graphics1200.fillRect(0, 0, imageWidth, imageHeight);
        graphics1200.setColor(Color.black);
        graphics1200.setFont(new Font("TimesRoman", 0, 400));
        graphics1200.drawString("Ting Testcodes 1200dpi [Seite " + page + "/3] (code=9999)", 400, 600);
        graphics1200.setFont(new Font("TimesRoman", 0, 300));
        graphics1200.drawString("  (ps=Rastergr\u00f6\u00dfe / ds=Punktgr\u00f6\u00dfe / de=Verschiebung)", 400, 900);
        graphics1200.setFont(new Font("TimesRoman", 0, 200));
        int dx = (int)((float)(PATTERN_WIDTH + PATTERN_DX) * ppm);
        int dy = (int)((float)(PATTERN_HEIGHT + PATTERN_DY) * ppm);
        int px = 200;
        int py = 1000;
        for (int patternSize = patternMin; patternSize <= patternMax; ++patternSize) {
            Codes.setPatternSize1200(patternSize);
            for (int dotSize = 1; dotSize <= 4; ++dotSize) {
                Codes.setDotSize1200(dotSize);
                for (int deltaSize = 1; deltaSize <= 4; ++deltaSize) {
                    Codes.setDeltaSize1200(deltaSize);
                    Codes.drawPattern(CODE_ID, px, py, PATTERN_WIDTH, PATTERN_HEIGHT, null, graphics1200);
                    graphics1200.drawString("ps = " + patternSize, px, py + (int)((float)PATTERN_HEIGHT * ppm) + 480);
                    graphics1200.drawString("ds = " + dotSize, px, py + (int)((float)PATTERN_HEIGHT * ppm) + 640);
                    graphics1200.drawString("de = " + deltaSize, px, py + (int)((float)PATTERN_HEIGHT * ppm) + 800);
                    graphics1200.drawRect(px, py, (int)((float)PATTERN_WIDTH * ppm) + 420, (int)((float)PATTERN_HEIGHT * ppm) + 840);
                    if ((px += dx) <= imageWidth - 600) continue;
                    px = 200;
                    py += dy;
                }
            }
        }
        FileOutputStream out = new FileOutputStream("codetest/test1200dpi_" + page + ".png");
        Codes.writePng(image1200, out);
        out.close();
    }

    private static void generate600dpi() throws Exception {
        int PATTERN_WIDTH = 10;
        int PATTERN_HEIGHT = 10;
        int PATTERN_DX = 10;
        int PATTERN_DY = 30;
        Codes.setResolution(0);
        float ppm = Codes.PNG_PIXEL_PER_MM[0];
        int imageWidth = Codes.A4_WIDTH[0];
        int imageHeight = Codes.A4_HEIGHT[0];
        BufferedImage image600 = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D graphics600 = image600.createGraphics();
        graphics600.setColor(Color.white);
        graphics600.fillRect(0, 0, imageWidth, imageHeight);
        graphics600.setColor(Color.black);
        graphics600.setFont(new Font("TimesRoman", 0, 200));
        graphics600.drawString("Ting Testcodes 600dpi (code=9999)", 200, 300);
        graphics600.setFont(new Font("TimesRoman", 0, 150));
        graphics600.drawString("  (ps=Rastergr\u00f6\u00dfe / ds=Punktgr\u00f6\u00dfe / de=Verschiebung)", 200, 450);
        graphics600.setFont(new Font("TimesRoman", 0, 100));
        int dx = (int)((float)(PATTERN_WIDTH + PATTERN_DX) * ppm);
        int dy = (int)((float)(PATTERN_HEIGHT + PATTERN_DY) * ppm);
        int px = 100;
        int py = 500;
        for (int patternSize = 6; patternSize <= 10; ++patternSize) {
            Codes.setPatternSize600(patternSize);
            for (int dotSize = 1; dotSize <= 3; ++dotSize) {
                Codes.setDotSize600(dotSize);
                for (int deltaSize = 1; deltaSize <= 4; ++deltaSize) {
                    Codes.setDeltaSize600(deltaSize);
                    Codes.drawPattern(CODE_ID, px, py, PATTERN_WIDTH, PATTERN_HEIGHT, null, graphics600);
                    graphics600.drawString("ps = " + patternSize, px, py + (int)((float)PATTERN_HEIGHT * ppm) + 240);
                    graphics600.drawString("ds = " + dotSize, px, py + (int)((float)PATTERN_HEIGHT * ppm) + 320);
                    graphics600.drawString("de = " + deltaSize, px, py + (int)((float)PATTERN_HEIGHT * ppm) + 400);
                    graphics600.drawRect(px, py, (int)((float)PATTERN_WIDTH * ppm) + 210, (int)((float)PATTERN_HEIGHT * ppm) + 420);
                    if ((px += dx) <= imageWidth - 300) continue;
                    px = 100;
                    py += dy;
                }
            }
        }
        FileOutputStream out = new FileOutputStream("codetest/test600dpi.png");
        Codes.writePng(image600, out);
        out.close();
    }
}

