/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter.collection;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.internal.Utils;

public class ScopeFilter
extends AbstractArtifactsFilter {
    private String includeScope;
    private String excludeScope;

    public ScopeFilter(String includeScope, String excludeScope) {
        this.includeScope = includeScope;
        this.excludeScope = excludeScope;
    }

    @Override
    public Set<Artifact> filter(Set<Artifact> artifacts) throws ArtifactFilterException {
        Set<Artifact> results = artifacts;
        if (Utils.isNotEmpty(this.includeScope)) {
            if (!("compile".equals(this.includeScope) || "test".equals(this.includeScope) || "provided".equals(this.includeScope) || "runtime".equals(this.includeScope) || "system".equals(this.includeScope))) {
                throw new ArtifactFilterException("Invalid Scope in includeScope: " + this.includeScope);
            }
            results = new LinkedHashSet<Artifact>();
            if ("provided".equals(this.includeScope) || "system".equals(this.includeScope)) {
                results = this.includeSingleScope(artifacts, this.includeScope);
            } else {
                ScopeArtifactFilter saf = new ScopeArtifactFilter(this.includeScope);
                for (Artifact artifact : artifacts) {
                    if (!saf.include(artifact)) continue;
                    results.add(artifact);
                }
            }
        } else if (Utils.isNotEmpty(this.excludeScope)) {
            if (!("compile".equals(this.excludeScope) || "test".equals(this.excludeScope) || "provided".equals(this.excludeScope) || "runtime".equals(this.excludeScope) || "system".equals(this.excludeScope))) {
                throw new ArtifactFilterException("Invalid Scope in excludeScope: " + this.excludeScope);
            }
            results = new LinkedHashSet<Artifact>();
            if ("test".equals(this.excludeScope)) {
                throw new ArtifactFilterException(" Can't exclude Test scope, this will exclude everything.");
            }
            if (!"provided".equals(this.excludeScope) && !"system".equals(this.excludeScope)) {
                ScopeArtifactFilter saf = new ScopeArtifactFilter(this.excludeScope);
                for (Artifact artifact : artifacts) {
                    if (saf.include(artifact)) continue;
                    results.add(artifact);
                }
            } else {
                results = this.excludeSingleScope(artifacts, this.excludeScope);
            }
        }
        return results;
    }

    private Set<Artifact> includeSingleScope(Set<Artifact> artifacts, String scope) {
        LinkedHashSet<Artifact> results = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!scope.equals(artifact.getScope())) continue;
            results.add(artifact);
        }
        return results;
    }

    private Set<Artifact> excludeSingleScope(Set<Artifact> artifacts, String scope) {
        LinkedHashSet<Artifact> results = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (scope.equals(artifact.getScope())) continue;
            results.add(artifact);
        }
        return results;
    }

    public String getIncludeScope() {
        return this.includeScope;
    }

    public void setIncludeScope(String scope) {
        this.includeScope = scope;
    }

    public String getExcludeScope() {
        return this.excludeScope;
    }

    public void setExcludeScope(String scope) {
        this.excludeScope = scope;
    }
}

