/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.util.Iterator;
import java.util.LinkedList;

class TreeElement {
    private String caption = null;
    private String id;
    private LinkedList<TreeElement> childs = new LinkedList();
    private TreeElement parent = null;
    private boolean enabled = false;

    public TreeElement(String id) {
        this.id = id;
    }

    public void addChild(TreeElement element) {
        this.childs.add(element);
        element.parent = this;
    }

    public Iterator<TreeElement> getChilds() {
        return this.childs.iterator();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    private TreeElement get(String childID) {
        for (TreeElement child : this.childs) {
            if (!child.getID().equals(childID)) continue;
            return child;
        }
        TreeElement newChild = new TreeElement(childID);
        this.addChild(newChild);
        return newChild;
    }

    public TreeElement get(String[] path) {
        TreeElement current = this;
        for (int i = 0; i < path.length; ++i) {
            current = current.get(path[i]);
        }
        return current;
    }

    public TreeElement getParent() {
        return this.parent;
    }

    public boolean isHidden() {
        return this.caption.startsWith("#");
    }

    public String getCaption() {
        if (this.isHidden()) {
            return this.caption.substring(1);
        }
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getID() {
        return this.id;
    }

    public String getFullID() {
        String fullID = "";
        for (TreeElement current = this; current != null; current = current.getParent()) {
            if (current.getID() == null) continue;
            fullID = fullID.isEmpty() ? current.getID() : current.getID() + "." + fullID;
        }
        return fullID;
    }

    public boolean isLeaf() {
        return this.childs.isEmpty();
    }
}

