/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import tingeltangel.cli_ng.CLI;
import tingeltangel.cli_ng.CliCmd;

class GetEntryMp3Length
extends CliCmd {
    GetEntryMp3Length() {
    }

    @Override
    String getName() {
        return "get-entry-mp3-length";
    }

    @Override
    String getDescription() {
        return "get-entry-mp3-length <oid>";
    }

    @Override
    int execute(String[] args) {
        int oid;
        if (args.length != 1) {
            return this.error("falsche Anzahl von Parametern");
        }
        try {
            oid = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            return this.error("OID keine Zahl zw. 15001 und 65535");
        }
        if (oid < 15001 || oid > 65535) {
            return this.error("OID keine Zahl zw. 15001 und 65535");
        }
        if (!CLI.bookOpened()) {
            return this.error("kein Buch ge\u00f6ffnet");
        }
        if (!CLI.getBook().entryForTingIDExists(oid)) {
            return this.error("OID nicht gefunden");
        }
        if (!CLI.getBook().getEntryByOID(oid).isMP3()) {
            return this.error("OID ist nicht vom Typ MP3");
        }
        float seconds = CLI.getBook().getEntryByOID(oid).getLength();
        int hours = (int)(seconds / 3600.0f);
        int minutes = (int)((seconds -= (float)(hours * 3600)) / 60.0f);
        seconds -= (float)(minutes * 60);
        String l = "";
        if (hours > 0) {
            l = l + Integer.toString(hours) + ":";
        }
        if (minutes < 10) {
            l = l + "0";
        }
        l = l + Integer.toString(minutes) + ":";
        int fs = (int)seconds;
        seconds -= (float)fs;
        if (fs < 10) {
            l = l + "0";
        }
        l = l + Integer.toString(fs);
        l = l + ".";
        int hs = (int)(seconds * 100.0f);
        if (hs < 10) {
            l = l + "0";
        }
        l = l + Integer.toString(hs);
        System.out.println(l);
        return this.ok();
    }
}

