/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.andersicht;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import tingeltangel.andersicht.AndersichtBook;
import tingeltangel.tools.FileEnvironment;

public class AndersichtLanguageLayer {
    private String name = "Name";
    private String description = "Beschreibung";
    private int id = 0;
    private int label = -1;
    private final AndersichtBook book;
    private File internalFile = null;

    AndersichtLanguageLayer(String name, String description, AndersichtBook book) {
        this.name = name;
        this.description = description;
        this.book = book;
    }

    public String toString() {
        return this.name;
    }

    public void setMP3(File file) throws IOException {
        if (this.internalFile == null || !this.internalFile.getAbsolutePath().equals(file.getAbsolutePath())) {
            this.internalFile = file;
            this.getBook().changeMade();
        }
    }

    public File getInternalMP3() {
        return this.internalFile;
    }

    public AndersichtBook getBook() {
        return this.book;
    }

    public int getLabel() {
        return this.label;
    }

    public void setLabel(int label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.book.changeMade();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.book.changeMade();
    }

    int getId() {
        return this.id;
    }

    void setId(int id) {
        this.id = id;
    }

    static AndersichtLanguageLayer load(AndersichtBook book, DataInputStream in) throws IOException {
        String name = in.readUTF();
        String description = in.readUTF();
        AndersichtLanguageLayer layer = new AndersichtLanguageLayer(name, description, book);
        layer.id = in.readInt();
        layer.label = in.readInt();
        File audioDir = FileEnvironment.getAndersichtAudioDirectory(Integer.toString(book.getBookId()));
        String fn = in.readUTF();
        if (!fn.isEmpty()) {
            layer.internalFile = new File(audioDir, fn);
            if (!layer.internalFile.canRead()) {
                throw new IOException("Kann MP3 " + layer.internalFile.getAbsolutePath() + " nicht finden");
            }
        } else {
            layer.internalFile = null;
        }
        return layer;
    }

    void save(DataOutputStream out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.description);
        out.writeInt(this.id);
        out.writeInt(this.label);
        if (this.internalFile == null) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.internalFile.getName());
        }
    }
}

