/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import tingeltangel.core.Book;
import tingeltangel.core.Tupel;
import tingeltangel.tools.Callback;
import tingeltangel.tools.FileEnvironment;

public class ChooseBook
extends JDialog {
    private final LinkedList<Tupel<Integer, String>> idList = new LinkedList();
    private MyListModel model = new MyListModel();
    private final Callback<Integer> callback;
    private static final Logger log = LogManager.getLogger(ChooseBook.class);
    private JList bookList;
    private JButton button;
    private JScrollPane jScrollPane1;

    private String getLabel(int id) throws IOException {
        return Book.getLabel(FileEnvironment.getXML(id));
    }

    public ChooseBook(Frame parent, Callback<Integer> callback) {
        super(parent, false);
        this.initComponents();
        this.callback = callback;
        this.bookList.setModel(this.model);
        File[] books = FileEnvironment.getBooksDirectory().listFiles();
        for (int i = 0; i < books.length; ++i) {
            if (!books[i].isDirectory()) continue;
            try {
                int id = Integer.parseInt(books[i].getName());
                if (id == 15000) continue;
                this.idList.add(new Tupel<Integer, String>(id, this.getLabel(id)));
                continue;
            }
            catch (NumberFormatException nfe) {
                log.warn("unable to parse book", nfe);
                continue;
            }
            catch (IOException ioe) {
                log.warn("unable to parse book", ioe);
            }
        }
        this.model.refresh();
        this.setVisible(true);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.bookList = new JList();
        this.button = new JButton();
        this.setDefaultCloseOperation(2);
        this.bookList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.bookList);
        this.button.setText("OK");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseBook.this.buttonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 708, Short.MAX_VALUE).addComponent(this.button))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 360, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.button).addContainerGap()));
        this.pack();
    }

    private void buttonActionPerformed(ActionEvent evt) {
        int index = this.bookList.getSelectedIndex();
        if (index != -1) {
            int id = (Integer)this.idList.get((int)index).a;
            this.callback.callback(id);
            this.setVisible(false);
        }
    }

    class MyListModel
    implements ListModel {
        private LinkedList<ListDataListener> listeners = new LinkedList();

        MyListModel() {
        }

        @Override
        public int getSize() {
            return ChooseBook.this.idList.size();
        }

        public Object getElementAt(int index) {
            return ((Tupel)((ChooseBook)ChooseBook.this).idList.get((int)index)).b;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        public void refresh() {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((ListDataListener)i.next()).contentsChanged(null);
            }
        }
    }
}

