/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.File;
import java.io.IOException;
import tingeltangel.cli_ng.CLI;
import tingeltangel.cli_ng.CliCmd;

class SetEntryMp3
extends CliCmd {
    SetEntryMp3() {
    }

    @Override
    String getName() {
        return "set-entry-mp3";
    }

    @Override
    String getDescription() {
        return "set-entry-mp3 <oid> <mp3 file>";
    }

    @Override
    int execute(String[] args) {
        int oid;
        if (args.length != 2) {
            return this.error("falsche Anzahl von Parametern");
        }
        try {
            oid = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            return this.error("OID keine Zahl zw. 15001 und 65535");
        }
        File mp3 = new File(args[1]);
        if (!mp3.canRead()) {
            return this.error("angebebenes MP3 ist nicht lesbar");
        }
        if (!CLI.bookOpened()) {
            return this.error("kein Buch ge\u00f6ffnet");
        }
        if (!CLI.getBook().entryForTingIDExists(oid)) {
            CLI.getBook().addEntry(oid);
        }
        try {
            CLI.getBook().getEntryByOID(oid).setMP3(mp3);
        }
        catch (IOException ex) {
            return this.error("MP3 konnte nicht hinzugef\u00fcgt werden", ex);
        }
        return this.ok();
    }
}

