/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import tingeltangel.cli_ng.CLI;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.Entry;

class GetEntryType
extends CliCmd {
    GetEntryType() {
    }

    @Override
    String getName() {
        return "get-entry-type";
    }

    @Override
    String getDescription() {
        return "get-entry-type <oid>";
    }

    @Override
    int execute(String[] args) {
        int oid;
        if (args.length != 1) {
            return this.error("falsche Anzahl von Parametern");
        }
        try {
            oid = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            return this.error("OID keine Zahl zw. 15001 und 65535");
        }
        if (oid < 15001 || oid > 65535) {
            return this.error("OID keine Zahl zw. 15001 und 65535");
        }
        if (!CLI.bookOpened()) {
            return this.error("kein Buch ge\u00f6ffnet");
        }
        if (!CLI.getBook().entryForTingIDExists(oid)) {
            return this.error("OID nicht gefunden");
        }
        Entry entry = CLI.getBook().getEntryByOID(oid);
        if (entry.isCode()) {
            System.out.println("script");
        } else if (entry.isMP3()) {
            System.out.println("mp3");
        } else if (entry.isSub()) {
            System.out.println("sub-script");
        } else if (entry.isTTS()) {
            System.out.println("tts");
        } else {
            this.error("unbekannter Typ");
        }
        return this.ok();
    }
}

