/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.Book;
import tingeltangel.core.Repository;
import tingeltangel.tools.FileEnvironment;

class BookInfo
extends CliCmd {
    BookInfo() {
    }

    @Override
    public String getName() {
        return "book-info";
    }

    @Override
    public String getDescription() {
        return "book-info <mid>";
    }

    @Override
    public int execute(String[] args) {
        try {
            int mid;
            if (args.length != 1) {
                return this.error("falsche Anzahl von Parametern");
            }
            try {
                mid = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                return this.error("keine Zahl (1-9999) als Parameter angegeben");
            }
            if (mid < 1 || mid > 9999) {
                return this.error("ung\u00fcltige MID angegeben (1-9999)");
            }
            String _mid = Integer.toString(mid);
            while (_mid.length() < 5) {
                _mid = "0" + _mid;
            }
            boolean existsInBooks = new File(FileEnvironment.getBooksDirectory(), _mid).exists();
            boolean existsInRepository = Repository.txtExists(mid);
            if (!existsInBooks && !existsInRepository) {
                return this.error("Dieses Buch existiert nicht");
            }
            if (existsInBooks) {
                Book book = new Book(15000);
                book.setID(mid);
                Book.loadXML(FileEnvironment.getXML(mid), book, null);
                if (existsInRepository) {
                    System.out.println("BOOK:");
                }
                System.out.println("Name     : " + book.getName());
                System.out.println("Verleger : " + book.getPublisher());
                System.out.println("Author   : " + book.getAuthor());
                System.out.println("Version  : " + book.getVersion());
                System.out.println("URL      : " + book.getUrl());
                System.out.println("?        : " + book.getMagicValue());
                System.out.println("Datum    : " + new SimpleDateFormat("dd.MM.yyyy").format(new Date(book.getDate() * 1000L)));
            }
            if (existsInRepository) {
                HashMap<String, String> txt = Repository.getBookTxt(mid);
                if (existsInBooks) {
                    System.out.println("REPOSITORY:");
                }
                System.out.println("Name     : " + (String)txt.get("Name"));
                System.out.println("Verleger : " + (String)txt.get("Publisher"));
                System.out.println("Author   : " + (String)txt.get("Author"));
                System.out.println("Version  : " + (String)txt.get("Book Version"));
                System.out.println("URL      : " + (String)txt.get("URL"));
            }
        }
        catch (IOException ex) {
            return this.error("das Buch konnte nicht gelesen werden", ex);
        }
        return this.ok();
    }
}

