/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.andersicht.gui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import tingeltangel.Tingeltangel;
import tingeltangel.andersicht.AndersichtBook;
import tingeltangel.andersicht.AndersichtLanguageLayer;
import tingeltangel.andersicht.gui.AndersichtBookDefinition;
import tingeltangel.andersicht.gui.AndersichtChooseBook;
import tingeltangel.andersicht.gui.AndersichtConfigureDescriptionLayer;
import tingeltangel.andersicht.gui.AndersichtConfigureLanguageLayer;
import tingeltangel.andersicht.gui.AndersichtNewBook;
import tingeltangel.andersicht.gui.AndersichtPanel;
import tingeltangel.tools.Callback;
import tingeltangel.tools.Progress;
import tingeltangel.tools.ProgressDialog;

public class AndersichtMainFrame
extends JFrame {
    private final AndersichtPanel mainPanel;
    private AndersichtBook book = null;
    private final AndersichtLanguageLayer languageLayer = null;
    private static final Logger LOG = LogManager.getLogger(AndersichtMainFrame.class);
    private final HashSet<JMenuItem> bookNeeded = new HashSet();

    public AndersichtMainFrame() {
        super(Tingeltangel.ANDERSICHT_FRAME_TITLE + Tingeltangel.MAIN_FRAME_VERSION);
        this.mainPanel = new AndersichtPanel(this);
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.setBounds(Tingeltangel.MAIN_FRAME_POS_X, Tingeltangel.MAIN_FRAME_POS_Y, Tingeltangel.MAIN_FRAME_WIDTH + this.getInsets().left + this.getInsets().right, Tingeltangel.MAIN_FRAME_HEIGHT + this.getInsets().top + this.getInsets().bottom);
        this.setJMenuBar(this.getAndersichtMenuBar());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int value;
                if (AndersichtMainFrame.this.book != null && AndersichtMainFrame.this.book.unsaved() && (value = JOptionPane.showConfirmDialog(AndersichtMainFrame.this, "Das aktuelle Buch ist nicht gespeichert. wollen sie das aktuelle buch speichern?", "Frage...", 0, 2)) == 0) {
                    try {
                        AndersichtMainFrame.this.book.save();
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(AndersichtMainFrame.this, "Das Buch konnte nicht gespeichert werden");
                        LOG.error("unable to save book (" + AndersichtMainFrame.this.book.getName() + ")", ex);
                    }
                }
                System.exit(0);
            }
        });
        this.setVisible(true);
        this.setContentPane(this.mainPanel);
        AbstractAction menuAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndersichtMainFrame.this.getRootPane().getJMenuBar().getMenu(0).doClick();
            }
        };
        JRootPane rPane = this.mainPanel.getRootPane();
        String MENU_ACTION_KEY = "expand_that_first_menu_please";
        rPane.getActionMap().put("expand_that_first_menu_please", menuAction);
        InputMap inputMap = rPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(18, 0, true), "expand_that_first_menu_please");
    }

    AndersichtPanel getAndersichtPanel() {
        return this.mainPanel;
    }

    AndersichtBook getBook() {
        return this.book;
    }

    AndersichtLanguageLayer getCurrentLanguageLayer() {
        return this.languageLayer;
    }

    private JMenuItem newMenuItem(final String action, String label, boolean needBook) {
        JMenuItem item = new JMenuItem(label);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AndersichtMainFrame.this.menuAction(action);
            }
        });
        if (needBook) {
            item.setEnabled(false);
            this.bookNeeded.add(item);
        }
        return item;
    }

    private JMenuBar getAndersichtMenuBar() {
        JMenuBar bar = new JMenuBar();
        JMenu file = new JMenu("Buch");
        file.add(this.newMenuItem("new", "Neu", false));
        file.add(this.newMenuItem("load", "Laden", false));
        file.add(this.newMenuItem("save", "Speichern", true));
        file.add(this.newMenuItem("generate", "Generieren", true));
        file.add(this.newMenuItem("exit", "Beenden", false));
        bar.add(file);
        JMenu config = new JMenu("Einstellungen");
        config.add(this.newMenuItem("configure_languages", "Sprachlayer", true));
        config.add(this.newMenuItem("configure_descriptions", "Beschreibungslayer", true));
        bar.add(config);
        JMenu reports = new JMenu("Checks / Reports");
        reports.add(this.newMenuItem("check_ids", "Label Check", true));
        reports.add(this.newMenuItem("check_mp3s", "MP3 Check", true));
        reports.add(this.newMenuItem("report_labels", "Label Report", true));
        bar.add(reports);
        return bar;
    }

    private void bookOpened() {
        Iterator<JMenuItem> i = this.bookNeeded.iterator();
        while (i.hasNext()) {
            i.next().setEnabled(true);
        }
    }

    void menuAction(String action) {
        if (action.equals("new")) {
            AndersichtNewBook andersichtNewBook = new AndersichtNewBook((Frame)this, new Callback<AndersichtBookDefinition>(){

                @Override
                public void callback(final AndersichtBookDefinition bookDefinition) {
                    Progress pr = new Progress(AndersichtMainFrame.this, "lade Buch"){

                        @Override
                        public void action(ProgressDialog progressDialog) {
                            AndersichtMainFrame.this.book = AndersichtBook.newBook(bookDefinition);
                            AndersichtMainFrame.this.book.addLanguageLayer("Standardsprache", "Standardsprache");
                            AndersichtMainFrame.this.book.addDescriptionLayer("Standardbeschreibung", "Standardbeschreibung");
                            AndersichtMainFrame.this.bookOpened();
                            AndersichtMainFrame.this.mainPanel.refresh();
                        }
                    };
                }
            });
        } else if (action.equals("generate")) {
            try {
                this.book.save();
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                boolean errorOccured = false;
                if (fc.showSaveDialog(this) == 0) {
                    File target = fc.getSelectedFile();
                    String fileName = Integer.toString(this.book.getBookId());
                    while (fileName.length() < 5) {
                        fileName = "0" + fileName;
                    }
                    fileName = fileName + "_en.ouf";
                    try {
                        this.book.generate(new File(target, fileName));
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, "Fehler beim Generieren des Buches: " + e.getMessage());
                        LOG.error("error generating book", e);
                        errorOccured = true;
                    }
                }
                if (!errorOccured) {
                    JOptionPane.showMessageDialog(this, "Buch erstellt");
                }
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Fehler beim speichern des Buches: " + ioe.getMessage());
            }
        } else if (action.equals("configure_languages")) {
            new AndersichtConfigureLanguageLayer(this, this.book);
        } else if (action.equals("configure_descriptions")) {
            new AndersichtConfigureDescriptionLayer(this, this.book);
        } else if (action.equals("save")) {
            try {
                this.book.save();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Fehler beim speichern des Buches: " + ioe.getMessage());
            }
        } else if (action.equals("check_ids")) {
            StringBuffer sb = this.book.checkLabels();
            if (sb == null) {
                JOptionPane.showMessageDialog(this, "Keine Konflikte oder Fehler gefunden");
            } else {
                JOptionPane.showMessageDialog(this, "Fehler oder Konflikte gefunden:\n" + sb.toString());
            }
        } else if (action.equals("check_mp3s")) {
            StringBuffer sb = this.book.checkMp3s();
            if (sb == null) {
                JOptionPane.showMessageDialog(this, "Alle MP3s vorhanden");
            } else {
                JOptionPane.showMessageDialog(this, "Fehlende MP3s gefunden:\n" + sb.toString());
            }
        } else if (action.equals("report_labels")) {
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(new FileNameExtensionFilter("Label-Report (*.txt)", "txt"));
            boolean errorOccured = false;
            if (fc.showSaveDialog(this) == 0) {
                File target = fc.getSelectedFile();
                try {
                    PrintWriter out = new PrintWriter(new FileWriter(target));
                    this.book.generateLabelReport(out);
                    out.close();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Fehler beim Generieren des Label-Reports: " + e.getMessage());
                    LOG.error("error generating label report", e);
                    errorOccured = true;
                }
            }
            if (!errorOccured) {
                JOptionPane.showMessageDialog(this, "Label-Report erstellt");
            }
        } else if (action.equals("load")) {
            AndersichtChooseBook andersichtChooseBook = new AndersichtChooseBook((Frame)this, new Callback<Integer>(){

                @Override
                public void callback(Integer _id) {
                    try {
                        AndersichtMainFrame.this.book = AndersichtBook.load(_id);
                        AndersichtMainFrame.this.bookOpened();
                        AndersichtMainFrame.this.mainPanel.refresh();
                        LOG.info("book loaded");
                    }
                    catch (IOException ex) {
                        LOG.error("unable to load book", ex);
                    }
                }
            });
        }
    }
}

