/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.andersicht;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.tree.TreeNode;
import tingeltangel.andersicht.AndersichtBook;
import tingeltangel.andersicht.AndersichtDescriptionLayer;
import tingeltangel.andersicht.AndersichtGroup;
import tingeltangel.andersicht.AndersichtLanguageLayer;
import tingeltangel.andersicht.AndersichtTrack;
import tingeltangel.andersicht.SaveObject;

public class AndersichtObject
implements TreeNode {
    private String name = "Objektname";
    private String description = "Objektbeschreibung";
    private final AndersichtGroup group;
    private final HashMap<AndersichtDescriptionLayer, Integer> labels = new HashMap();
    Map<AndersichtLanguageLayer, Map<AndersichtDescriptionLayer, AndersichtTrack>> trackMap = new HashMap<AndersichtLanguageLayer, Map<AndersichtDescriptionLayer, AndersichtTrack>>();

    AndersichtObject(String name, String description, AndersichtGroup group) {
        this.name = name;
        this.description = description;
        this.group = group;
    }

    public String toString() {
        return this.name;
    }

    public int getLabelAsInt(AndersichtDescriptionLayer dLayer) {
        if (!this.labels.containsKey(dLayer)) {
            this.labels.put(dLayer, -1);
        }
        return this.labels.get(dLayer);
    }

    private AndersichtBook getBook() {
        return this.group.getBook();
    }

    public String getLabelAsString(AndersichtDescriptionLayer dLayer) {
        return this.getBook().getPen().fromTingId(this.getLabelAsInt(dLayer));
    }

    public void setLabel(AndersichtDescriptionLayer dLayer, int label) {
        int oldLabel = this.getLabelAsInt(dLayer);
        if (oldLabel != label) {
            this.labels.put(dLayer, label);
            this.getBook().changeMade();
        }
    }

    public void setName(String name) {
        if (!this.name.equals(name)) {
            this.name = name;
            this.group.getBook().changeMade();
        }
    }

    public void setDescription(String description) {
        if (!this.description.equals(description)) {
            this.description = description;
            this.group.getBook().changeMade();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public AndersichtGroup getGroup() {
        return this.group;
    }

    public AndersichtTrack getTrack(AndersichtLanguageLayer languageLayer, AndersichtDescriptionLayer descriptionLayer) {
        AndersichtTrack track;
        Map<AndersichtDescriptionLayer, AndersichtTrack> map = this.trackMap.get(languageLayer);
        if (map == null) {
            map = new HashMap<AndersichtDescriptionLayer, AndersichtTrack>();
            this.trackMap.put(languageLayer, map);
        }
        if ((track = map.get(descriptionLayer)) == null) {
            track = new AndersichtTrack(this, descriptionLayer);
            map.put(descriptionLayer, track);
            this.group.getBook().changeMade();
        }
        return track;
    }

    public void removeTrack(AndersichtLanguageLayer languageLayer, AndersichtDescriptionLayer descriptionLayer) {
        AndersichtTrack track;
        Map<AndersichtDescriptionLayer, AndersichtTrack> map = this.trackMap.get(languageLayer);
        if (map != null && (track = map.get(descriptionLayer)) != null) {
            map.remove(descriptionLayer);
            this.group.getBook().changeMade();
            if (map.isEmpty()) {
                this.trackMap.remove(languageLayer);
            }
        }
    }

    public boolean usesLanguageLayer(AndersichtLanguageLayer layer) {
        Iterator<AndersichtLanguageLayer> i = this.trackMap.keySet().iterator();
        while (i.hasNext()) {
            if (i.next() != layer) continue;
            return true;
        }
        return false;
    }

    public boolean usesDescriptionLayer(AndersichtDescriptionLayer layer) {
        Iterator<AndersichtLanguageLayer> i1 = this.trackMap.keySet().iterator();
        while (i1.hasNext()) {
            Iterator<AndersichtDescriptionLayer> i2 = this.trackMap.get(i1.next()).keySet().iterator();
            while (i2.hasNext()) {
                if (i2.next() != layer) continue;
                return true;
            }
        }
        return false;
    }

    static AndersichtObject load(AndersichtGroup group, DataInputStream in) throws IOException {
        String name = in.readUTF();
        String description = in.readUTF();
        AndersichtObject object = new AndersichtObject(name, description, group);
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            int dId = in.readInt();
            int label = in.readInt();
            AndersichtDescriptionLayer dLayer = group.getBook().getDescriptionLayerById(dId);
            object.labels.put(dLayer, label);
        }
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            int descriptionId = in.readInt();
            int languageId = in.readInt();
            AndersichtDescriptionLayer dLayer = group.getBook().getDescriptionLayerById(descriptionId);
            AndersichtLanguageLayer lLayer = group.getBook().getLanguageLayerById(languageId);
            AndersichtTrack track = object.getTrack(lLayer, dLayer);
            track.load(in, group.getBook().getBookId());
        }
        return object;
    }

    void save(DataOutputStream out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.description);
        AndersichtBook book = this.getGroup().getBook();
        out.writeInt(book.getDescriptionLayerCount());
        for (int dl = 0; dl < book.getDescriptionLayerCount(); ++dl) {
            AndersichtDescriptionLayer descriptionLayer = book.getDescriptionLayer(dl);
            out.writeInt(descriptionLayer.getId());
            out.writeInt(this.getLabelAsInt(descriptionLayer));
        }
        LinkedList<SaveObject> list = new LinkedList<SaveObject>();
        for (int ll = 0; ll < book.getLanguageLayerCount(); ++ll) {
            AndersichtLanguageLayer languageLayer = book.getLanguageLayer(ll);
            for (int dl = 0; dl < book.getDescriptionLayerCount(); ++dl) {
                AndersichtDescriptionLayer descriptionLayer = book.getDescriptionLayer(dl);
                SaveObject so = new SaveObject();
                so.descriptionId = descriptionLayer.getId();
                so.languageId = languageLayer.getId();
                so.track = this.getTrack(languageLayer, descriptionLayer);
                list.add(so);
            }
        }
        out.writeInt(list.size());
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ((SaveObject)i.next()).save(out);
        }
    }

    public int getDescriptionTrackIndex(AndersichtLanguageLayer currentLanguageLayer, AndersichtTrack track) {
        AndersichtBook book = this.group.getBook();
        for (int i = 0; i < book.getDescriptionLayerCount(); ++i) {
            if (this.getTrack(currentLanguageLayer, book.getDescriptionLayer(i)) != track) continue;
            return i;
        }
        return -1;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        AndersichtLanguageLayer lLayer = this.group.getBook().getActiveLanguageLayer();
        AndersichtDescriptionLayer dLayer = this.group.getBook().getDescriptionLayer(childIndex);
        return this.getTrack(lLayer, dLayer);
    }

    @Override
    public int getChildCount() {
        return this.group.getBook().getDescriptionLayerCount();
    }

    @Override
    public TreeNode getParent() {
        return this.group;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (!(node instanceof AndersichtTrack)) {
            return -1;
        }
        AndersichtLanguageLayer lLayer = this.group.getBook().getActiveLanguageLayer();
        return this.getDescriptionTrackIndex(lLayer, (AndersichtTrack)node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public Enumeration children() {
        return new Enumeration(){
            int pos = -1;

            @Override
            public boolean hasMoreElements() {
                return this.pos < AndersichtObject.this.group.getBook().getDescriptionLayerCount();
            }

            public Object nextElement() {
                ++this.pos;
                return AndersichtObject.this.getChildAt(this.pos);
            }
        };
    }

    void hasAllTracks() throws IllegalArgumentException {
        AndersichtBook book = this.getGroup().getBook();
        for (int ll = 0; ll < book.getLanguageLayerCount(); ++ll) {
            AndersichtLanguageLayer languageLayer = book.getLanguageLayer(ll);
            for (int dl = 0; dl < book.getDescriptionLayerCount(); ++dl) {
                AndersichtDescriptionLayer descriptionLayer = book.getDescriptionLayer(dl);
                AndersichtTrack track = this.getTrack(languageLayer, descriptionLayer);
                if (track.getInternalMP3() != null && track.getInternalMP3().canRead()) continue;
                throw new IllegalArgumentException("Kann das MP3 f\u00fcr Objekt '" + this.toString() + "' (Sprache: '" + languageLayer.toString() + "', Beschreibung: '" + descriptionLayer.toString() + "') nicht finden.");
            }
        }
    }

    public AndersichtDescriptionLayer getDescriptionLayer(AndersichtTrack track) {
        AndersichtBook book = this.getGroup().getBook();
        for (int ll = 0; ll < book.getLanguageLayerCount(); ++ll) {
            AndersichtLanguageLayer languageLayer = book.getLanguageLayer(ll);
            for (int dl = 0; dl < book.getDescriptionLayerCount(); ++dl) {
                AndersichtDescriptionLayer descriptionLayer = book.getDescriptionLayer(dl);
                AndersichtTrack _track = this.getTrack(languageLayer, descriptionLayer);
                if (_track != track) continue;
                return descriptionLayer;
            }
        }
        return null;
    }
}

