/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.UUID;
import sun.security.mscapi.RSAKeyPair;
import sun.security.rsa.RSAKeyFactory;
import sun.security.util.SecurityProviderConstants;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    static final int KEY_SIZE_MIN = 512;
    static final int KEY_SIZE_MAX = 16384;
    private int keySize;

    public RSAKeyPairGenerator() {
        this.initialize(SecurityProviderConstants.DEF_RSA_KEY_SIZE, null);
    }

    @Override
    public void initialize(int keySize, SecureRandom random) {
        try {
            RSAKeyFactory.checkKeyLengths(keySize, null, 512, 16384);
        }
        catch (InvalidKeyException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        this.keySize = keySize;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        int tmpSize;
        if (params == null) {
            tmpSize = SecurityProviderConstants.DEF_RSA_KEY_SIZE;
        } else if (params instanceof RSAKeyGenParameterSpec) {
            if (((RSAKeyGenParameterSpec)params).getPublicExponent() != null) {
                throw new InvalidAlgorithmParameterException("Exponent parameter is not supported");
            }
            tmpSize = ((RSAKeyGenParameterSpec)params).getKeysize();
        } else {
            throw new InvalidAlgorithmParameterException("Params must be an instance of RSAKeyGenParameterSpec");
        }
        try {
            RSAKeyFactory.checkKeyLengths(tmpSize, null, 512, 16384);
        }
        catch (InvalidKeyException e) {
            throw new InvalidAlgorithmParameterException("Invalid Key sizes", e);
        }
        this.keySize = tmpSize;
    }

    @Override
    public KeyPair generateKeyPair() {
        try {
            RSAKeyPair keys = RSAKeyPairGenerator.generateRSAKeyPair(this.keySize, "{" + UUID.randomUUID().toString() + "}");
            return new KeyPair(keys.getPublic(), keys.getPrivate());
        }
        catch (KeyException e) {
            throw new ProviderException(e);
        }
    }

    private static native RSAKeyPair generateRSAKeyPair(int var0, String var1) throws KeyException;
}

