/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.reflect.annotation.AnnotationType;

public final class AnnotationSupport {
    private static final JavaLangAccess LANG_ACCESS = SharedSecrets.getJavaLangAccess();

    public static <A extends Annotation> A[] getDirectlyAndIndirectlyPresent(Map<Class<? extends Annotation>, Annotation> annotations, Class<A> annoClass) {
        Annotation[] indirect;
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        Annotation direct = annotations.get(annoClass);
        if (direct != null) {
            result.add(direct);
        }
        if ((indirect = AnnotationSupport.getIndirectlyPresent(annotations, annoClass)) != null && indirect.length != 0) {
            boolean indirectFirst = direct == null || AnnotationSupport.containerBeforeContainee(annotations, annoClass);
            result.addAll(indirectFirst ? 0 : 1, Arrays.asList(indirect));
        }
        Annotation[] arr = (Annotation[])Array.newInstance(annoClass, result.size());
        return result.toArray(arr);
    }

    private static <A extends Annotation> A[] getIndirectlyPresent(Map<Class<? extends Annotation>, Annotation> annotations, Class<A> annoClass) {
        Repeatable repeatable = annoClass.getDeclaredAnnotation(Repeatable.class);
        if (repeatable == null) {
            return null;
        }
        Class<? extends Annotation> containerClass = repeatable.value();
        Annotation container = annotations.get(containerClass);
        if (container == null) {
            return null;
        }
        Annotation[] valueArray = AnnotationSupport.getValueArray((Annotation)container);
        AnnotationSupport.checkTypes((Annotation[])valueArray, (Annotation)container, annoClass);
        return valueArray;
    }

    private static <A extends Annotation> boolean containerBeforeContainee(Map<Class<? extends Annotation>, Annotation> annotations, Class<A> annoClass) {
        Class<? extends Annotation> containerClass = annoClass.getDeclaredAnnotation(Repeatable.class).value();
        for (Class<? extends Annotation> c : annotations.keySet()) {
            if (c == containerClass) {
                return true;
            }
            if (c != annoClass) continue;
            return false;
        }
        return false;
    }

    public static <A extends Annotation> A[] getAssociatedAnnotations(Map<Class<? extends Annotation>, Annotation> declaredAnnotations, Class<?> decl, Class<A> annoClass) {
        Objects.requireNonNull(decl);
        Annotation[] result = AnnotationSupport.getDirectlyAndIndirectlyPresent(declaredAnnotations, annoClass);
        if (AnnotationType.getInstance(annoClass).isInherited()) {
            for (Class<?> superDecl = decl.getSuperclass(); result.length == 0 && superDecl != null; superDecl = superDecl.getSuperclass()) {
                result = AnnotationSupport.getDirectlyAndIndirectlyPresent(LANG_ACCESS.getDeclaredAnnotationMap(superDecl), annoClass);
            }
        }
        return result;
    }

    private static <A extends Annotation> A[] getValueArray(Annotation container) {
        try {
            Class<? extends Annotation> containerClass = container.annotationType();
            AnnotationType annoType = AnnotationType.getInstance(containerClass);
            if (annoType == null) {
                throw AnnotationSupport.invalidContainerException(container, null);
            }
            Method m = annoType.members().get("value");
            if (m == null) {
                throw AnnotationSupport.invalidContainerException(container, null);
            }
            m.setAccessible(true);
            Annotation[] values = (Annotation[])m.invoke(container, new Object[0]);
            return values;
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw AnnotationSupport.invalidContainerException(container, e);
        }
    }

    private static AnnotationFormatError invalidContainerException(Annotation anno, Throwable cause) {
        return new AnnotationFormatError(anno + " is an invalid container for repeating annotations", cause);
    }

    private static <A extends Annotation> void checkTypes(A[] annotations, Annotation container, Class<A> annoClass) {
        for (A a : annotations) {
            if (annoClass.isInstance(a)) continue;
            throw new AnnotationFormatError(String.format("%s is an invalid container for repeating annotations of type: %s", container, annoClass));
        }
    }
}

