/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth;

import java.io.Serializable;
import java.security.Principal;
import java.text.MessageFormat;
import jdk.Exported;
import sun.security.util.ResourcesMgr;

@Exported
public class NTSid
implements Principal,
Serializable {
    private static final long serialVersionUID = 4412290580770249885L;
    private String sid;

    public NTSid(String stringSid) {
        if (stringSid == null) {
            MessageFormat form = new MessageFormat(ResourcesMgr.getString("invalid.null.input.value", "sun.security.util.AuthResources"));
            Object[] source = new Object[]{"stringSid"};
            throw new NullPointerException(form.format(source));
        }
        if (stringSid.length() == 0) {
            throw new IllegalArgumentException(ResourcesMgr.getString("Invalid.NTSid.value", "sun.security.util.AuthResources"));
        }
        this.sid = new String(stringSid);
    }

    @Override
    public String getName() {
        return this.sid;
    }

    @Override
    public String toString() {
        MessageFormat form = new MessageFormat(ResourcesMgr.getString("NTSid.name", "sun.security.util.AuthResources"));
        Object[] source = new Object[]{this.sid};
        return form.format(source);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof NTSid)) {
            return false;
        }
        NTSid that = (NTSid)o;
        return this.sid.equals(that.sid);
    }

    @Override
    public int hashCode() {
        return this.sid.hashCode();
    }
}

