/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Window;
import java.awt.print.PrinterJob;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.PrinterStateReason;
import javax.print.attribute.standard.PrinterStateReasons;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.Severity;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;
import sun.awt.windows.WPrinterJob;
import sun.print.AttributeUpdater;
import sun.print.DocumentPropertiesUI;
import sun.print.ServiceNotifier;
import sun.print.SunAlternateMedia;
import sun.print.SunPrinterJobService;
import sun.print.Win32MediaSize;
import sun.print.Win32MediaTray;
import sun.print.Win32PrintJob;

public class Win32PrintService
implements PrintService,
AttributeUpdater,
SunPrinterJobService {
    public static MediaSize[] predefMedia = Win32MediaSize.getPredefMedia();
    private static final DocFlavor[] supportedFlavors = new DocFlavor[]{DocFlavor.BYTE_ARRAY.GIF, DocFlavor.INPUT_STREAM.GIF, DocFlavor.URL.GIF, DocFlavor.BYTE_ARRAY.JPEG, DocFlavor.INPUT_STREAM.JPEG, DocFlavor.URL.JPEG, DocFlavor.BYTE_ARRAY.PNG, DocFlavor.INPUT_STREAM.PNG, DocFlavor.URL.PNG, DocFlavor.SERVICE_FORMATTED.PAGEABLE, DocFlavor.SERVICE_FORMATTED.PRINTABLE, DocFlavor.BYTE_ARRAY.AUTOSENSE, DocFlavor.URL.AUTOSENSE, DocFlavor.INPUT_STREAM.AUTOSENSE};
    private static final Class[] serviceAttrCats = new Class[]{PrinterName.class, PrinterIsAcceptingJobs.class, QueuedJobCount.class, ColorSupported.class};
    private static Class[] otherAttrCats = new Class[]{JobName.class, RequestingUserName.class, Copies.class, Destination.class, OrientationRequested.class, PageRanges.class, Media.class, MediaPrintableArea.class, Fidelity.class, SheetCollate.class, SunAlternateMedia.class, Chromaticity.class};
    public static final MediaSizeName[] dmPaperToPrintService = new MediaSizeName[]{MediaSizeName.NA_LETTER, MediaSizeName.NA_LETTER, MediaSizeName.TABLOID, MediaSizeName.LEDGER, MediaSizeName.NA_LEGAL, MediaSizeName.INVOICE, MediaSizeName.EXECUTIVE, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.FOLIO, MediaSizeName.QUARTO, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.B, MediaSizeName.NA_LETTER, MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, MediaSizeName.ISO_DESIGNATED_LONG, MediaSizeName.ISO_C5, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C6, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.FOLIO, MediaSizeName.ISO_B4, MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.NA_9X11_ENVELOPE};
    private static final MediaTray[] dmPaperBinToPrintService = new MediaTray[]{MediaTray.TOP, MediaTray.BOTTOM, MediaTray.MIDDLE, MediaTray.MANUAL, MediaTray.ENVELOPE, Win32MediaTray.ENVELOPE_MANUAL, Win32MediaTray.AUTO, Win32MediaTray.TRACTOR, Win32MediaTray.SMALL_FORMAT, Win32MediaTray.LARGE_FORMAT, MediaTray.LARGE_CAPACITY, null, null, MediaTray.MAIN, Win32MediaTray.FORMSOURCE};
    private static int DM_PAPERSIZE = 2;
    private static int DM_PRINTQUALITY = 1024;
    private static int DM_YRESOLUTION = 8192;
    private static final int DMRES_MEDIUM = -3;
    private static final int DMRES_HIGH = -4;
    private static final int DMORIENT_LANDSCAPE = 2;
    private static final int DMDUP_VERTICAL = 2;
    private static final int DMDUP_HORIZONTAL = 3;
    private static final int DMCOLLATE_TRUE = 1;
    private static final int DMCOLOR_MONOCHROME = 1;
    private static final int DMCOLOR_COLOR = 2;
    private static final int DMPAPER_A2 = 66;
    private static final int DMPAPER_A6 = 70;
    private static final int DMPAPER_B6_JIS = 88;
    private static final int DEVCAP_COLOR = 1;
    private static final int DEVCAP_DUPLEX = 2;
    private static final int DEVCAP_COLLATE = 4;
    private static final int DEVCAP_QUALITY = 8;
    private static final int DEVCAP_POSTSCRIPT = 16;
    private String printer;
    private PrinterName name;
    private String port;
    private transient PrintServiceAttributeSet lastSet;
    private transient ServiceNotifier notifier = null;
    private MediaSizeName[] mediaSizeNames;
    private MediaPrintableArea[] mediaPrintables;
    private MediaTray[] mediaTrays;
    private PrinterResolution[] printRes;
    private HashMap mpaMap;
    private int nCopies;
    private int prnCaps;
    private int[] defaultSettings;
    private boolean gotTrays;
    private boolean gotCopies;
    private boolean mediaInitialized;
    private boolean mpaListInitialized;
    private ArrayList idList;
    private MediaSize[] mediaSizes;
    private boolean isInvalid;
    private Win32DocumentPropertiesUI docPropertiesUI = null;
    private Win32ServiceUIFactory uiFactory = null;

    Win32PrintService(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null printer name");
        }
        this.printer = name;
        this.mediaInitialized = false;
        this.gotTrays = false;
        this.gotCopies = false;
        this.isInvalid = false;
        this.printRes = null;
        this.prnCaps = 0;
        this.defaultSettings = null;
        this.port = null;
    }

    public void invalidateService() {
        this.isInvalid = true;
    }

    @Override
    public String getName() {
        return this.printer;
    }

    private PrinterName getPrinterName() {
        if (this.name == null) {
            this.name = new PrinterName(this.printer, null);
        }
        return this.name;
    }

    public int findPaperID(MediaSizeName msn) {
        if (msn instanceof Win32MediaSize) {
            Win32MediaSize winMedia = (Win32MediaSize)msn;
            return winMedia.getDMPaper();
        }
        for (int id = 0; id < dmPaperToPrintService.length; ++id) {
            if (!dmPaperToPrintService[id].equals(msn)) continue;
            return id + 1;
        }
        if (msn.equals(MediaSizeName.ISO_A2)) {
            return 66;
        }
        if (msn.equals(MediaSizeName.ISO_A6)) {
            return 70;
        }
        if (msn.equals(MediaSizeName.JIS_B6)) {
            return 88;
        }
        this.initMedia();
        if (this.idList != null && this.mediaSizes != null && this.idList.size() == this.mediaSizes.length) {
            for (int i = 0; i < this.idList.size(); ++i) {
                if (this.mediaSizes[i].getMediaSizeName() != msn) continue;
                return (Integer)this.idList.get(i);
            }
        }
        return 0;
    }

    public int findTrayID(MediaTray tray) {
        this.getMediaTrays();
        if (tray instanceof Win32MediaTray) {
            Win32MediaTray winTray = (Win32MediaTray)tray;
            return winTray.getDMBinID();
        }
        for (int id = 0; id < dmPaperBinToPrintService.length; ++id) {
            if (!tray.equals(dmPaperBinToPrintService[id])) continue;
            return id + 1;
        }
        return 0;
    }

    public MediaTray findMediaTray(int dmBin) {
        if (dmBin >= 1 && dmBin <= dmPaperBinToPrintService.length) {
            return dmPaperBinToPrintService[dmBin - 1];
        }
        MediaTray[] trays = this.getMediaTrays();
        if (trays != null) {
            for (int i = 0; i < trays.length; ++i) {
                if (!(trays[i] instanceof Win32MediaTray)) continue;
                Win32MediaTray win32Tray = (Win32MediaTray)trays[i];
                if (win32Tray.winID != dmBin) continue;
                return win32Tray;
            }
        }
        return Win32MediaTray.AUTO;
    }

    public MediaSizeName findWin32Media(int dmIndex) {
        if (dmIndex >= 1 && dmIndex <= dmPaperToPrintService.length) {
            return dmPaperToPrintService[dmIndex - 1];
        }
        switch (dmIndex) {
            case 66: {
                return MediaSizeName.ISO_A2;
            }
            case 70: {
                return MediaSizeName.ISO_A6;
            }
            case 88: {
                return MediaSizeName.JIS_B6;
            }
        }
        return null;
    }

    private boolean addToUniqueList(ArrayList msnList, MediaSizeName mediaName) {
        for (int i = 0; i < msnList.size(); ++i) {
            MediaSizeName msn = (MediaSizeName)msnList.get(i);
            if (msn != mediaName) continue;
            return false;
        }
        msnList.add(mediaName);
        return true;
    }

    private synchronized void initMedia() {
        boolean added;
        if (this.mediaInitialized) {
            return;
        }
        this.mediaInitialized = true;
        int[] media = this.getAllMediaIDs(this.printer, this.getPort());
        if (media == null) {
            return;
        }
        ArrayList msnList = new ArrayList();
        ArrayList<Win32MediaSize> trailingWmsList = new ArrayList<Win32MediaSize>();
        ArrayList printableList = new ArrayList();
        boolean queryFailure = false;
        this.idList = new ArrayList();
        for (int i = 0; i < media.length; ++i) {
            this.idList.add(media[i]);
        }
        ArrayList<String> dmPaperNameList = new ArrayList<String>();
        this.mediaSizes = this.getMediaSizes(this.idList, media, dmPaperNameList);
        for (int i = 0; i < this.idList.size(); ++i) {
            boolean dmPaperIDMatched;
            MediaSizeName mediaName = this.findWin32Media((Integer)this.idList.get(i));
            if (mediaName != null && this.idList.size() == this.mediaSizes.length) {
                MediaSize win32Size = MediaSize.getMediaSizeForName(mediaName);
                MediaSize driverSize = this.mediaSizes[i];
                int error = 2540;
                if (Math.abs(win32Size.getX(1) - driverSize.getX(1)) > (float)error || Math.abs(win32Size.getY(1) - driverSize.getY(1)) > (float)error) {
                    mediaName = null;
                }
            }
            boolean bl = dmPaperIDMatched = mediaName != null;
            if (mediaName == null && this.idList.size() == this.mediaSizes.length) {
                mediaName = this.mediaSizes[i].getMediaSizeName();
            }
            added = false;
            if (mediaName != null) {
                added = this.addToUniqueList(msnList, mediaName);
            }
            if (dmPaperIDMatched && added || this.idList.size() != dmPaperNameList.size()) continue;
            Win32MediaSize wms = Win32MediaSize.findMediaName(dmPaperNameList.get(i));
            if (wms == null && this.idList.size() == this.mediaSizes.length) {
                wms = new Win32MediaSize(dmPaperNameList.get(i), (Integer)this.idList.get(i));
                this.mediaSizes[i] = new MediaSize(this.mediaSizes[i].getX(1000), this.mediaSizes[i].getY(1000), 1000, (MediaSizeName)wms);
            }
            if (wms == null || wms == mediaName) continue;
            if (!added) {
                mediaName = wms;
                added = this.addToUniqueList(msnList, mediaName);
                continue;
            }
            trailingWmsList.add(wms);
        }
        for (Win32MediaSize wms : trailingWmsList) {
            added = this.addToUniqueList(msnList, wms);
        }
        this.mediaSizeNames = new MediaSizeName[msnList.size()];
        msnList.toArray(this.mediaSizeNames);
    }

    private synchronized MediaPrintableArea[] getMediaPrintables(MediaSizeName msn) {
        if (msn == null) {
            if (this.mpaListInitialized) {
                return this.mediaPrintables;
            }
        } else if (this.mpaMap != null && this.mpaMap.get(msn) != null) {
            MediaPrintableArea[] mpaArr = new MediaPrintableArea[]{(MediaPrintableArea)this.mpaMap.get(msn)};
            return mpaArr;
        }
        this.initMedia();
        if (this.mediaSizeNames == null || this.mediaSizeNames.length == 0) {
            return null;
        }
        MediaSizeName[] loopNames = msn != null ? new MediaSizeName[]{msn} : this.mediaSizeNames;
        if (this.mpaMap == null) {
            this.mpaMap = new HashMap();
        }
        for (int i = 0; i < loopNames.length; ++i) {
            MediaSizeName mediaName = loopNames[i];
            if (this.mpaMap.get(mediaName) != null || mediaName == null) continue;
            int defPaper = this.findPaperID(mediaName);
            float[] prnArea = defPaper != 0 ? this.getMediaPrintableArea(this.printer, defPaper) : null;
            MediaPrintableArea printableArea = null;
            if (prnArea != null) {
                try {
                    printableArea = new MediaPrintableArea(prnArea[0], prnArea[1], prnArea[2], prnArea[3], 25400);
                    this.mpaMap.put(mediaName, printableArea);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            MediaSize ms = MediaSize.getMediaSizeForName(mediaName);
            if (ms == null) continue;
            try {
                printableArea = new MediaPrintableArea(0.0f, 0.0f, ms.getX(25400), ms.getY(25400), 25400);
                this.mpaMap.put(mediaName, printableArea);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.mpaMap.size() == 0) {
            return null;
        }
        if (msn != null) {
            if (this.mpaMap.get(msn) == null) {
                return null;
            }
            MediaPrintableArea[] mpaArr = new MediaPrintableArea[]{(MediaPrintableArea)this.mpaMap.get(msn)};
            return mpaArr;
        }
        this.mediaPrintables = this.mpaMap.values().toArray(new MediaPrintableArea[0]);
        this.mpaListInitialized = true;
        return this.mediaPrintables;
    }

    private synchronized MediaTray[] getMediaTrays() {
        if (this.gotTrays && this.mediaTrays != null) {
            return this.mediaTrays;
        }
        String prnPort = this.getPort();
        int[] mediaTr = this.getAllMediaTrays(this.printer, prnPort);
        String[] winMediaTrayNames = this.getAllMediaTrayNames(this.printer, prnPort);
        if (mediaTr == null || winMediaTrayNames == null) {
            return null;
        }
        int nTray = 0;
        for (int i = 0; i < mediaTr.length; ++i) {
            if (mediaTr[i] <= 0) continue;
            ++nTray;
        }
        MediaTray[] arr = new MediaTray[nTray];
        int j = 0;
        for (int i = 0; i < Math.min(mediaTr.length, winMediaTrayNames.length); ++i) {
            int dmBin = mediaTr[i];
            if (dmBin <= 0) continue;
            arr[j++] = dmBin > dmPaperBinToPrintService.length || dmPaperBinToPrintService[dmBin - 1] == null ? new Win32MediaTray(dmBin, winMediaTrayNames[i]) : dmPaperBinToPrintService[dmBin - 1];
        }
        this.mediaTrays = arr;
        this.gotTrays = true;
        return this.mediaTrays;
    }

    private boolean isSameSize(float w1, float h1, float w2, float h2) {
        float diffX = w1 - w2;
        float diffY = h1 - h2;
        float diffXrev = w1 - h2;
        float diffYrev = h1 - w2;
        return Math.abs(diffX) <= 1.0f && Math.abs(diffY) <= 1.0f || Math.abs(diffXrev) <= 1.0f && Math.abs(diffYrev) <= 1.0f;
    }

    public MediaSizeName findMatchingMediaSizeNameMM(float w, float h) {
        if (predefMedia != null) {
            for (int k = 0; k < predefMedia.length; ++k) {
                if (predefMedia[k] == null || !this.isSameSize(predefMedia[k].getX(1000), predefMedia[k].getY(1000), w, h)) continue;
                return predefMedia[k].getMediaSizeName();
            }
        }
        return null;
    }

    private MediaSize[] getMediaSizes(ArrayList idList, int[] media, ArrayList<String> dmPaperNameList) {
        if (dmPaperNameList == null) {
            dmPaperNameList = new ArrayList();
        }
        String prnPort = this.getPort();
        int[] mediaSz = this.getAllMediaSizes(this.printer, prnPort);
        String[] winMediaNames = this.getAllMediaNames(this.printer, prnPort);
        MediaSizeName msn = null;
        MediaSize ms = null;
        if (mediaSz == null || winMediaNames == null) {
            return null;
        }
        int nMedia = mediaSz.length / 2;
        ArrayList<MediaSize> msList = new ArrayList<MediaSize>();
        for (int i = 0; i < nMedia; ++i) {
            block12: {
                float wid = (float)mediaSz[i * 2] / 10.0f;
                float ht = (float)mediaSz[i * 2 + 1] / 10.0f;
                if (wid <= 0.0f || ht <= 0.0f) {
                    if (nMedia == media.length) {
                        Integer remObj = media[i];
                        idList.remove(idList.indexOf(remObj));
                    }
                } else {
                    msn = this.findMatchingMediaSizeNameMM(wid, ht);
                    if (msn != null) {
                        ms = MediaSize.getMediaSizeForName(msn);
                    }
                    if (ms != null) {
                        msList.add(ms);
                        dmPaperNameList.add(winMediaNames[i]);
                    } else {
                        Win32MediaSize wms = Win32MediaSize.findMediaName(winMediaNames[i]);
                        if (wms == null) {
                            wms = new Win32MediaSize(winMediaNames[i], media[i]);
                        }
                        try {
                            ms = new MediaSize(wid, ht, 1000, (MediaSizeName)wms);
                            msList.add(ms);
                            dmPaperNameList.add(winMediaNames[i]);
                        }
                        catch (IllegalArgumentException e) {
                            if (nMedia != media.length) break block12;
                            Integer remObj = media[i];
                            idList.remove(idList.indexOf(remObj));
                        }
                    }
                }
            }
            ms = null;
        }
        MediaSize[] arr2 = new MediaSize[msList.size()];
        msList.toArray(arr2);
        return arr2;
    }

    private PrinterIsAcceptingJobs getPrinterIsAcceptingJobs() {
        if (this.getJobStatus(this.printer, 2) != 1) {
            return PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
        }
        return PrinterIsAcceptingJobs.ACCEPTING_JOBS;
    }

    private PrinterState getPrinterState() {
        if (this.isInvalid) {
            return PrinterState.STOPPED;
        }
        return null;
    }

    private PrinterStateReasons getPrinterStateReasons() {
        if (this.isInvalid) {
            PrinterStateReasons psr = new PrinterStateReasons();
            psr.put(PrinterStateReason.SHUTDOWN, Severity.ERROR);
            return psr;
        }
        return null;
    }

    private QueuedJobCount getQueuedJobCount() {
        int count = this.getJobStatus(this.printer, 1);
        if (count != -1) {
            return new QueuedJobCount(count);
        }
        return new QueuedJobCount(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSupportedCopies(Copies copies) {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (!this.gotCopies) {
                this.nCopies = this.getCopiesSupported(this.printer, this.getPort());
                this.gotCopies = true;
            }
        }
        int numCopies = copies.getValue();
        return numCopies > 0 && numCopies <= this.nCopies;
    }

    private boolean isSupportedMedia(MediaSizeName msn) {
        this.initMedia();
        if (this.mediaSizeNames != null) {
            for (int i = 0; i < this.mediaSizeNames.length; ++i) {
                if (!msn.equals(this.mediaSizeNames[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSupportedMediaPrintableArea(MediaPrintableArea mpa) {
        this.getMediaPrintables(null);
        if (this.mediaPrintables != null) {
            for (int i = 0; i < this.mediaPrintables.length; ++i) {
                if (!mpa.equals(this.mediaPrintables[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSupportedMediaTray(MediaTray msn) {
        MediaTray[] trays = this.getMediaTrays();
        if (trays != null) {
            for (int i = 0; i < trays.length; ++i) {
                if (!msn.equals(trays[i])) continue;
                return true;
            }
        }
        return false;
    }

    private int getPrinterCapabilities() {
        if (this.prnCaps == 0) {
            this.prnCaps = this.getCapabilities(this.printer, this.getPort());
        }
        return this.prnCaps;
    }

    private String getPort() {
        if (this.port == null) {
            this.port = this.getPrinterPort(this.printer);
        }
        return this.port;
    }

    private int[] getDefaultPrinterSettings() {
        if (this.defaultSettings == null) {
            this.defaultSettings = this.getDefaultSettings(this.printer, this.getPort());
        }
        return this.defaultSettings;
    }

    private PrinterResolution[] getPrintResolutions() {
        if (this.printRes == null) {
            int[] prnRes = this.getAllResolutions(this.printer, this.getPort());
            if (prnRes == null) {
                this.printRes = new PrinterResolution[0];
            } else {
                int nRes = prnRes.length / 2;
                ArrayList<PrinterResolution> arrList = new ArrayList<PrinterResolution>();
                for (int i = 0; i < nRes; ++i) {
                    try {
                        PrinterResolution pr = new PrinterResolution(prnRes[i * 2], prnRes[i * 2 + 1], 100);
                        arrList.add(pr);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                this.printRes = arrList.toArray(new PrinterResolution[arrList.size()]);
            }
        }
        return this.printRes;
    }

    private boolean isSupportedResolution(PrinterResolution res) {
        PrinterResolution[] supportedRes = this.getPrintResolutions();
        if (supportedRes != null) {
            for (int i = 0; i < supportedRes.length; ++i) {
                if (!res.equals(supportedRes[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DocPrintJob createPrintJob() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        return new Win32PrintJob(this);
    }

    private PrintServiceAttributeSet getDynamicAttributes() {
        HashPrintServiceAttributeSet attrs = new HashPrintServiceAttributeSet();
        attrs.add(this.getPrinterIsAcceptingJobs());
        attrs.add(this.getQueuedJobCount());
        return attrs;
    }

    @Override
    public PrintServiceAttributeSet getUpdatedAttributes() {
        PrintServiceAttributeSet currSet = this.getDynamicAttributes();
        if (this.lastSet == null) {
            this.lastSet = currSet;
            return AttributeSetUtilities.unmodifiableView(currSet);
        }
        HashPrintServiceAttributeSet updates = new HashPrintServiceAttributeSet();
        Attribute[] attrs = currSet.toArray();
        for (int i = 0; i < attrs.length; ++i) {
            Attribute attr = attrs[i];
            if (this.lastSet.containsValue(attr)) continue;
            updates.add(attr);
        }
        this.lastSet = currSet;
        return AttributeSetUtilities.unmodifiableView(updates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeNotifier() {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (this.notifier != null) {
                this.notifier.wake();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener listener) {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (listener == null) {
                return;
            }
            if (this.notifier == null) {
                this.notifier = new ServiceNotifier(this);
            }
            this.notifier.addListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener listener) {
        Win32PrintService win32PrintService = this;
        synchronized (win32PrintService) {
            if (listener == null || this.notifier == null) {
                return;
            }
            this.notifier.removeListener(listener);
            if (this.notifier.isEmpty()) {
                this.notifier.stopNotifier();
                this.notifier = null;
            }
        }
    }

    @Override
    public <T extends PrintServiceAttribute> T getAttribute(Class<T> category) {
        if (category == null) {
            throw new NullPointerException("category");
        }
        if (!PrintServiceAttribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException("Not a PrintServiceAttribute");
        }
        if (category == ColorSupported.class) {
            int caps = this.getPrinterCapabilities();
            if ((caps & 1) != 0) {
                return (T)ColorSupported.SUPPORTED;
            }
            return (T)ColorSupported.NOT_SUPPORTED;
        }
        if (category == PrinterName.class) {
            return (T)this.getPrinterName();
        }
        if (category == PrinterState.class) {
            return (T)this.getPrinterState();
        }
        if (category == PrinterStateReasons.class) {
            return (T)this.getPrinterStateReasons();
        }
        if (category == QueuedJobCount.class) {
            return (T)this.getQueuedJobCount();
        }
        if (category == PrinterIsAcceptingJobs.class) {
            return (T)this.getPrinterIsAcceptingJobs();
        }
        return null;
    }

    @Override
    public PrintServiceAttributeSet getAttributes() {
        PrinterStateReasons prnStateReasons;
        HashPrintServiceAttributeSet attrs = new HashPrintServiceAttributeSet();
        attrs.add(this.getPrinterName());
        attrs.add(this.getPrinterIsAcceptingJobs());
        PrinterState prnState = this.getPrinterState();
        if (prnState != null) {
            attrs.add(prnState);
        }
        if ((prnStateReasons = this.getPrinterStateReasons()) != null) {
            attrs.add(prnStateReasons);
        }
        attrs.add(this.getQueuedJobCount());
        int caps = this.getPrinterCapabilities();
        if ((caps & 1) != 0) {
            attrs.add(ColorSupported.SUPPORTED);
        } else {
            attrs.add(ColorSupported.NOT_SUPPORTED);
        }
        return AttributeSetUtilities.unmodifiableView(attrs);
    }

    @Override
    public DocFlavor[] getSupportedDocFlavors() {
        DocFlavor[] supportedDocFlavors;
        int len = supportedFlavors.length;
        int caps = this.getPrinterCapabilities();
        if ((caps & 0x10) != 0) {
            supportedDocFlavors = new DocFlavor[len + 3];
            System.arraycopy(supportedFlavors, 0, supportedDocFlavors, 0, len);
            supportedDocFlavors[len] = DocFlavor.BYTE_ARRAY.POSTSCRIPT;
            supportedDocFlavors[len + 1] = DocFlavor.INPUT_STREAM.POSTSCRIPT;
            supportedDocFlavors[len + 2] = DocFlavor.URL.POSTSCRIPT;
        } else {
            supportedDocFlavors = new DocFlavor[len];
            System.arraycopy(supportedFlavors, 0, supportedDocFlavors, 0, len);
        }
        return supportedDocFlavors;
    }

    @Override
    public boolean isDocFlavorSupported(DocFlavor flavor) {
        DocFlavor[] supportedDocFlavors = this.isPostScriptFlavor(flavor) ? this.getSupportedDocFlavors() : supportedFlavors;
        for (int f = 0; f < supportedDocFlavors.length; ++f) {
            if (!flavor.equals(supportedDocFlavors[f])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?>[] getSupportedAttributeCategories() {
        PrinterResolution[] supportedRes;
        int[] defaults;
        ArrayList<Class<PrinterResolution>> categList = new ArrayList<Class<PrinterResolution>>(otherAttrCats.length + 3);
        for (int i = 0; i < otherAttrCats.length; ++i) {
            categList.add(otherAttrCats[i]);
        }
        int caps = this.getPrinterCapabilities();
        if ((caps & 2) != 0) {
            categList.add(Sides.class);
        }
        if ((caps & 8) != 0 && (defaults = this.getDefaultPrinterSettings())[3] >= -4 && defaults[3] < 0) {
            categList.add(PrintQuality.class);
        }
        if ((supportedRes = this.getPrintResolutions()) != null && supportedRes.length > 0) {
            categList.add(PrinterResolution.class);
        }
        return categList.toArray(new Class[categList.size()]);
    }

    @Override
    public boolean isAttributeCategorySupported(Class<? extends Attribute> category) {
        if (category == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException(category + " is not an Attribute");
        }
        Class<?>[] classList = this.getSupportedAttributeCategories();
        for (int i = 0; i < classList.length; ++i) {
            if (!category.equals(classList[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getDefaultAttributeValue(Class<? extends Attribute> category) {
        if (category == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException(category + " is not an Attribute");
        }
        if (!this.isAttributeCategorySupported(category)) {
            return null;
        }
        int[] defaults = this.getDefaultPrinterSettings();
        int defPaper = defaults[0];
        int defYRes = defaults[2];
        int defQuality = defaults[3];
        int defCopies = defaults[4];
        int defOrient = defaults[5];
        int defSides = defaults[6];
        int defCollate = defaults[7];
        int defColor = defaults[8];
        if (category == Copies.class) {
            if (defCopies <= 0) return new Copies(1);
            return new Copies(defCopies);
        }
        if (category == Chromaticity.class) {
            if (defColor != 2) return Chromaticity.MONOCHROME;
            return Chromaticity.COLOR;
        }
        if (category == JobName.class) {
            return new JobName("Java Printing", null);
        }
        if (category == OrientationRequested.class) {
            if (defOrient != 2) return OrientationRequested.PORTRAIT;
            return OrientationRequested.LANDSCAPE;
        }
        if (category == PageRanges.class) {
            return new PageRanges(1, Integer.MAX_VALUE);
        }
        if (category == Media.class) {
            MediaSizeName msn = this.findWin32Media(defPaper);
            if (msn != null) {
                if (this.isSupportedMedia(msn)) return msn;
                if (this.mediaSizeNames == null) return msn;
                msn = this.mediaSizeNames[0];
                defPaper = this.findPaperID(msn);
                return msn;
            }
            this.initMedia();
            if (this.mediaSizeNames == null) return null;
            if (this.mediaSizeNames.length <= 0) return null;
            if (this.idList == null) return this.mediaSizeNames[0];
            if (this.mediaSizes == null) return this.mediaSizeNames[0];
            if (this.idList.size() != this.mediaSizes.length) return this.mediaSizeNames[0];
            Integer defIdObj = defPaper;
            int index = this.idList.indexOf(defIdObj);
            if (index < 0) return this.mediaSizeNames[0];
            if (index >= this.mediaSizes.length) return this.mediaSizeNames[0];
            return this.mediaSizes[index].getMediaSizeName();
        }
        if (category == MediaPrintableArea.class) {
            float[] prnArea;
            MediaSizeName msn = this.findWin32Media(defPaper);
            if (msn != null && !this.isSupportedMedia(msn) && this.mediaSizeNames != null) {
                defPaper = this.findPaperID(this.mediaSizeNames[0]);
            }
            if ((prnArea = this.getMediaPrintableArea(this.printer, defPaper)) == null) return null;
            MediaPrintableArea printableArea = null;
            try {
                return new MediaPrintableArea(prnArea[0], prnArea[1], prnArea[2], prnArea[3], 25400);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return printableArea;
        }
        if (category == SunAlternateMedia.class) {
            return null;
        }
        if (category == Destination.class) {
            try {
                return new Destination(new File("out.prn").toURI());
            }
            catch (SecurityException se) {
                try {
                    return new Destination(new URI("file:out.prn"));
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
        }
        if (category == Sides.class) {
            switch (defSides) {
                case 2: {
                    return Sides.TWO_SIDED_LONG_EDGE;
                }
                case 3: {
                    return Sides.TWO_SIDED_SHORT_EDGE;
                }
            }
            return Sides.ONE_SIDED;
        }
        if (category == PrinterResolution.class) {
            int yRes = defYRes;
            int xRes = defQuality;
            if (xRes >= 0) {
                if (yRes >= 0) return new PrinterResolution(xRes, yRes, 100);
            }
            int res = yRes > xRes ? yRes : xRes;
            if (res <= 0) return null;
            return new PrinterResolution(res, res, 100);
        }
        if (category == ColorSupported.class) {
            int caps = this.getPrinterCapabilities();
            if ((caps & 1) == 0) return ColorSupported.NOT_SUPPORTED;
            return ColorSupported.SUPPORTED;
        }
        if (category == PrintQuality.class) {
            if (defQuality >= 0) return null;
            if (defQuality < -4) return null;
            switch (defQuality) {
                case -4: {
                    return PrintQuality.HIGH;
                }
                case -3: {
                    return PrintQuality.NORMAL;
                }
            }
            return PrintQuality.DRAFT;
        }
        if (category == RequestingUserName.class) {
            String userName = "";
            try {
                userName = System.getProperty("user.name", "");
                return new RequestingUserName(userName, null);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new RequestingUserName(userName, null);
        }
        if (category == SheetCollate.class) {
            if (defCollate != 1) return SheetCollate.UNCOLLATED;
            return SheetCollate.COLLATED;
        }
        if (category != Fidelity.class) return null;
        return Fidelity.FIDELITY_FALSE;
    }

    private boolean isPostScriptFlavor(DocFlavor flavor) {
        return flavor.equals(DocFlavor.BYTE_ARRAY.POSTSCRIPT) || flavor.equals(DocFlavor.INPUT_STREAM.POSTSCRIPT) || flavor.equals(DocFlavor.URL.POSTSCRIPT);
    }

    private boolean isPSDocAttr(Class category) {
        return category == OrientationRequested.class || category == Copies.class;
    }

    private boolean isAutoSense(DocFlavor flavor) {
        return flavor.equals(DocFlavor.BYTE_ARRAY.AUTOSENSE) || flavor.equals(DocFlavor.INPUT_STREAM.AUTOSENSE) || flavor.equals(DocFlavor.URL.AUTOSENSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getSupportedAttributeValues(Class<? extends Attribute> category, DocFlavor flavor, AttributeSet attributes) {
        if (category == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(category)) {
            throw new IllegalArgumentException(category + " does not implement Attribute");
        }
        if (flavor != null) {
            if (!this.isDocFlavorSupported(flavor)) {
                throw new IllegalArgumentException(flavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(flavor) || this.isPostScriptFlavor(flavor) && this.isPSDocAttr(category)) {
                return null;
            }
        }
        if (!this.isAttributeCategorySupported(category)) {
            return null;
        }
        if (category == JobName.class) {
            return new JobName("Java Printing", null);
        }
        if (category == RequestingUserName.class) {
            String userName = "";
            try {
                userName = System.getProperty("user.name", "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new RequestingUserName(userName, null);
        }
        if (category == ColorSupported.class) {
            int caps = this.getPrinterCapabilities();
            if ((caps & 1) != 0) {
                return ColorSupported.SUPPORTED;
            }
            return ColorSupported.NOT_SUPPORTED;
        }
        if (category == Chromaticity.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || flavor.equals(DocFlavor.BYTE_ARRAY.GIF) || flavor.equals(DocFlavor.INPUT_STREAM.GIF) || flavor.equals(DocFlavor.URL.GIF) || flavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || flavor.equals(DocFlavor.INPUT_STREAM.JPEG) || flavor.equals(DocFlavor.URL.JPEG) || flavor.equals(DocFlavor.BYTE_ARRAY.PNG) || flavor.equals(DocFlavor.INPUT_STREAM.PNG) || flavor.equals(DocFlavor.URL.PNG)) {
                int caps = this.getPrinterCapabilities();
                if ((caps & 1) == 0) {
                    Chromaticity[] arr = new Chromaticity[]{Chromaticity.MONOCHROME};
                    return arr;
                }
                Chromaticity[] arr = new Chromaticity[]{Chromaticity.MONOCHROME, Chromaticity.COLOR};
                return arr;
            }
            return null;
        }
        if (category == Destination.class) {
            try {
                return new Destination(new File("out.prn").toURI());
            }
            catch (SecurityException se) {
                try {
                    return new Destination(new URI("file:out.prn"));
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
        }
        if (category == OrientationRequested.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || flavor.equals(DocFlavor.INPUT_STREAM.GIF) || flavor.equals(DocFlavor.INPUT_STREAM.JPEG) || flavor.equals(DocFlavor.INPUT_STREAM.PNG) || flavor.equals(DocFlavor.BYTE_ARRAY.GIF) || flavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || flavor.equals(DocFlavor.BYTE_ARRAY.PNG) || flavor.equals(DocFlavor.URL.GIF) || flavor.equals(DocFlavor.URL.JPEG) || flavor.equals(DocFlavor.URL.PNG)) {
                OrientationRequested[] arr = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE};
                return arr;
            }
            return null;
        }
        if (category == Copies.class || category == CopiesSupported.class) {
            Win32PrintService arr = this;
            synchronized (arr) {
                if (!this.gotCopies) {
                    this.nCopies = this.getCopiesSupported(this.printer, this.getPort());
                    this.gotCopies = true;
                }
            }
            return new CopiesSupported(1, this.nCopies);
        }
        if (category == Media.class) {
            this.initMedia();
            int len = this.mediaSizeNames == null ? 0 : this.mediaSizeNames.length;
            MediaTray[] trays = this.getMediaTrays();
            Media[] arr = new Media[len += trays == null ? 0 : trays.length];
            if (this.mediaSizeNames != null) {
                System.arraycopy(this.mediaSizeNames, 0, arr, 0, this.mediaSizeNames.length);
            }
            if (trays != null) {
                System.arraycopy(trays, 0, arr, len - trays.length, trays.length);
            }
            return arr;
        }
        if (category == MediaPrintableArea.class) {
            MediaPrintableArea[] mpas;
            Media mediaName = null;
            if (attributes != null && (mediaName = (Media)attributes.get(Media.class)) != null && !(mediaName instanceof MediaSizeName)) {
                mediaName = null;
            }
            if ((mpas = this.getMediaPrintables((MediaSizeName)mediaName)) != null) {
                MediaPrintableArea[] arr = new MediaPrintableArea[mpas.length];
                System.arraycopy(mpas, 0, arr, 0, mpas.length);
                return arr;
            }
            return null;
        }
        if (category == SunAlternateMedia.class) {
            return new SunAlternateMedia((Media)this.getDefaultAttributeValue(Media.class));
        }
        if (category == PageRanges.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                PageRanges[] arr = new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
                return arr;
            }
            return null;
        }
        if (category == PrinterResolution.class) {
            PrinterResolution[] supportedRes = this.getPrintResolutions();
            if (supportedRes == null) {
                return null;
            }
            PrinterResolution[] arr = new PrinterResolution[supportedRes.length];
            System.arraycopy(supportedRes, 0, arr, 0, supportedRes.length);
            return arr;
        }
        if (category == Sides.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                Sides[] arr = new Sides[]{Sides.ONE_SIDED, Sides.TWO_SIDED_LONG_EDGE, Sides.TWO_SIDED_SHORT_EDGE};
                return arr;
            }
            return null;
        }
        if (category == PrintQuality.class) {
            PrintQuality[] arr = new PrintQuality[]{PrintQuality.DRAFT, PrintQuality.HIGH, PrintQuality.NORMAL};
            return arr;
        }
        if (category == SheetCollate.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                SheetCollate[] arr = new SheetCollate[]{SheetCollate.COLLATED, SheetCollate.UNCOLLATED};
                return arr;
            }
            return null;
        }
        if (category == Fidelity.class) {
            Fidelity[] arr = new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
            return arr;
        }
        return null;
    }

    @Override
    public boolean isAttributeValueSupported(Attribute attr, DocFlavor flavor, AttributeSet attributes) {
        if (attr == null) {
            throw new NullPointerException("null attribute");
        }
        Class<? extends Attribute> category = attr.getCategory();
        if (flavor != null) {
            if (!this.isDocFlavorSupported(flavor)) {
                throw new IllegalArgumentException(flavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(flavor) || this.isPostScriptFlavor(flavor) && this.isPSDocAttr(category)) {
                return false;
            }
        }
        if (!this.isAttributeCategorySupported(category)) {
            return false;
        }
        if (category == Chromaticity.class) {
            if (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || flavor.equals(DocFlavor.BYTE_ARRAY.GIF) || flavor.equals(DocFlavor.INPUT_STREAM.GIF) || flavor.equals(DocFlavor.URL.GIF) || flavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || flavor.equals(DocFlavor.INPUT_STREAM.JPEG) || flavor.equals(DocFlavor.URL.JPEG) || flavor.equals(DocFlavor.BYTE_ARRAY.PNG) || flavor.equals(DocFlavor.INPUT_STREAM.PNG) || flavor.equals(DocFlavor.URL.PNG)) {
                int caps = this.getPrinterCapabilities();
                if ((caps & 1) != 0) {
                    return true;
                }
                return attr == Chromaticity.MONOCHROME;
            }
            return false;
        }
        if (category == Copies.class) {
            return this.isSupportedCopies((Copies)attr);
        }
        if (category == Destination.class) {
            URI uri = ((Destination)attr).getURI();
            return "file".equals(uri.getScheme()) && !uri.getSchemeSpecificPart().equals("");
        }
        if (category == Media.class) {
            if (attr instanceof MediaSizeName) {
                return this.isSupportedMedia((MediaSizeName)attr);
            }
            if (attr instanceof MediaTray) {
                return this.isSupportedMediaTray((MediaTray)attr);
            }
        } else {
            if (category == MediaPrintableArea.class) {
                return this.isSupportedMediaPrintableArea((MediaPrintableArea)attr);
            }
            if (category == SunAlternateMedia.class) {
                Media media = ((SunAlternateMedia)attr).getMedia();
                return this.isAttributeValueSupported(media, flavor, attributes);
            }
            if (category == PageRanges.class || category == SheetCollate.class || category == Sides.class) {
                if (flavor != null && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                    return false;
                }
            } else if (category == PrinterResolution.class) {
                if (attr instanceof PrinterResolution) {
                    return this.isSupportedResolution((PrinterResolution)attr);
                }
            } else if (category == OrientationRequested.class) {
                if (!(attr != OrientationRequested.REVERSE_PORTRAIT && (flavor == null || flavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || flavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || flavor.equals(DocFlavor.INPUT_STREAM.GIF) || flavor.equals(DocFlavor.INPUT_STREAM.JPEG) || flavor.equals(DocFlavor.INPUT_STREAM.PNG) || flavor.equals(DocFlavor.BYTE_ARRAY.GIF) || flavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || flavor.equals(DocFlavor.BYTE_ARRAY.PNG) || flavor.equals(DocFlavor.URL.GIF) || flavor.equals(DocFlavor.URL.JPEG) || flavor.equals(DocFlavor.URL.PNG)))) {
                    return false;
                }
            } else if (category == ColorSupported.class) {
                boolean isColorSup;
                int caps = this.getPrinterCapabilities();
                boolean bl = isColorSup = (caps & 1) != 0;
                if (!isColorSup && attr == ColorSupported.SUPPORTED || isColorSup && attr == ColorSupported.NOT_SUPPORTED) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public AttributeSet getUnsupportedAttributes(DocFlavor flavor, AttributeSet attributes) {
        if (flavor != null && !this.isDocFlavorSupported(flavor)) {
            throw new IllegalArgumentException("flavor " + flavor + "is not supported");
        }
        if (attributes == null) {
            return null;
        }
        HashAttributeSet unsupp = new HashAttributeSet();
        Attribute[] attrs = attributes.toArray();
        for (int i = 0; i < attrs.length; ++i) {
            try {
                Attribute attr = attrs[i];
                if (!this.isAttributeCategorySupported(attr.getCategory())) {
                    unsupp.add(attr);
                    continue;
                }
                if (this.isAttributeValueSupported(attr, flavor, attributes)) continue;
                unsupp.add(attr);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (unsupp.isEmpty()) {
            return null;
        }
        return unsupp;
    }

    private synchronized DocumentPropertiesUI getDocumentPropertiesUI() {
        return new Win32DocumentPropertiesUI(this);
    }

    @Override
    public synchronized ServiceUIFactory getServiceUIFactory() {
        if (this.uiFactory == null) {
            this.uiFactory = new Win32ServiceUIFactory(this);
        }
        return this.uiFactory;
    }

    public String toString() {
        return "Win32 Printer : " + this.getName();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof Win32PrintService && ((Win32PrintService)obj).getName().equals(this.getName());
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.getName().hashCode();
    }

    @Override
    public boolean usesClass(Class c) {
        return c == WPrinterJob.class;
    }

    private native int[] getAllMediaIDs(String var1, String var2);

    private native int[] getAllMediaSizes(String var1, String var2);

    private native int[] getAllMediaTrays(String var1, String var2);

    private native float[] getMediaPrintableArea(String var1, int var2);

    private native String[] getAllMediaNames(String var1, String var2);

    private native String[] getAllMediaTrayNames(String var1, String var2);

    private native int getCopiesSupported(String var1, String var2);

    private native int[] getAllResolutions(String var1, String var2);

    private native int getCapabilities(String var1, String var2);

    private native int[] getDefaultSettings(String var1, String var2);

    private native int getJobStatus(String var1, int var2);

    private native String getPrinterPort(String var1);

    private static class Win32ServiceUIFactory
    extends ServiceUIFactory {
        Win32PrintService service;

        Win32ServiceUIFactory(Win32PrintService s) {
            this.service = s;
        }

        @Override
        public Object getUI(int role, String ui) {
            if (role <= 3) {
                return null;
            }
            if (role == 199 && DocumentPropertiesUI.DOCPROPERTIESCLASSNAME.equals(ui)) {
                return this.service.getDocumentPropertiesUI();
            }
            throw new IllegalArgumentException("Unsupported role");
        }

        @Override
        public String[] getUIClassNamesForRole(int role) {
            if (role <= 3) {
                return null;
            }
            if (role == 199) {
                String[] names = new String[]{};
                names[0] = DocumentPropertiesUI.DOCPROPERTIESCLASSNAME;
                return names;
            }
            throw new IllegalArgumentException("Unsupported role");
        }
    }

    private static class Win32DocumentPropertiesUI
    extends DocumentPropertiesUI {
        Win32PrintService service;

        private Win32DocumentPropertiesUI(Win32PrintService s) {
            this.service = s;
        }

        @Override
        public PrintRequestAttributeSet showDocumentProperties(PrinterJob job, Window owner, PrintService service, PrintRequestAttributeSet aset) {
            if (!(job instanceof WPrinterJob)) {
                return null;
            }
            WPrinterJob wJob = (WPrinterJob)job;
            return wJob.showDocumentProperties(owner, service, aset);
        }
    }
}

