/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import sun.awt.AppContext;
import sun.awt.ComponentFactory;
import sun.awt.SunToolkit;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ToolkitImage;
import sun.util.logging.PlatformLogger;

public abstract class DataTransferer {
    public static final DataFlavor plainTextStringFlavor;
    public static final DataFlavor javaTextEncodingFlavor;
    private static final Map textMIMESubtypeCharsetSupport;
    private static String defaultEncoding;
    private static final Set textNatives;
    private static final Map nativeCharsets;
    private static final Map nativeEOLNs;
    private static final Map nativeTerminators;
    private static final String DATA_CONVERTER_KEY = "DATA_CONVERTER_KEY";
    private static DataTransferer transferer;
    private static final PlatformLogger dtLog;
    private static final String[] DEPLOYMENT_CACHE_PROPERTIES;
    private static final ArrayList<File> deploymentCacheDirectoryList;

    public static synchronized DataTransferer getInstance() {
        return ((ComponentFactory)((Object)Toolkit.getDefaultToolkit())).getDataTransferer();
    }

    public static String canonicalName(String encoding) {
        if (encoding == null) {
            return null;
        }
        try {
            return Charset.forName(encoding).name();
        }
        catch (IllegalCharsetNameException icne) {
            return encoding;
        }
        catch (UnsupportedCharsetException uce) {
            return encoding;
        }
    }

    public static String getTextCharset(DataFlavor flavor) {
        if (!DataTransferer.isFlavorCharsetTextType(flavor)) {
            return null;
        }
        String encoding = flavor.getParameter("charset");
        return encoding != null ? encoding : DataTransferer.getDefaultTextCharset();
    }

    public static String getDefaultTextCharset() {
        if (defaultEncoding != null) {
            return defaultEncoding;
        }
        defaultEncoding = Charset.defaultCharset().name();
        return defaultEncoding;
    }

    public static boolean doesSubtypeSupportCharset(DataFlavor flavor) {
        String subType;
        if (dtLog.isLoggable(PlatformLogger.Level.FINE) && !"text".equals(flavor.getPrimaryType())) {
            dtLog.fine("Assertion (\"text\".equals(flavor.getPrimaryType())) failed");
        }
        if ((subType = flavor.getSubType()) == null) {
            return false;
        }
        Object support = textMIMESubtypeCharsetSupport.get(subType);
        if (support != null) {
            return support == Boolean.TRUE;
        }
        boolean ret_val = flavor.getParameter("charset") != null;
        textMIMESubtypeCharsetSupport.put(subType, ret_val ? Boolean.TRUE : Boolean.FALSE);
        return ret_val;
    }

    public static boolean doesSubtypeSupportCharset(String subType, String charset) {
        Object support = textMIMESubtypeCharsetSupport.get(subType);
        if (support != null) {
            return support == Boolean.TRUE;
        }
        boolean ret_val = charset != null;
        textMIMESubtypeCharsetSupport.put(subType, ret_val ? Boolean.TRUE : Boolean.FALSE);
        return ret_val;
    }

    public static boolean isFlavorCharsetTextType(DataFlavor flavor) {
        if (DataFlavor.stringFlavor.equals(flavor)) {
            return true;
        }
        if (!"text".equals(flavor.getPrimaryType()) || !DataTransferer.doesSubtypeSupportCharset(flavor)) {
            return false;
        }
        Class<?> rep_class = flavor.getRepresentationClass();
        if (flavor.isRepresentationClassReader() || String.class.equals(rep_class) || flavor.isRepresentationClassCharBuffer() || char[].class.equals(rep_class)) {
            return true;
        }
        if (!(flavor.isRepresentationClassInputStream() || flavor.isRepresentationClassByteBuffer() || byte[].class.equals(rep_class))) {
            return false;
        }
        String charset = flavor.getParameter("charset");
        return charset != null ? DataTransferer.isEncodingSupported(charset) : true;
    }

    public static boolean isFlavorNoncharsetTextType(DataFlavor flavor) {
        if (!"text".equals(flavor.getPrimaryType()) || DataTransferer.doesSubtypeSupportCharset(flavor)) {
            return false;
        }
        return flavor.isRepresentationClassInputStream() || flavor.isRepresentationClassByteBuffer() || byte[].class.equals(flavor.getRepresentationClass());
    }

    public static boolean isEncodingSupported(String encoding) {
        if (encoding == null) {
            return false;
        }
        try {
            return Charset.isSupported(encoding);
        }
        catch (IllegalCharsetNameException icne) {
            return false;
        }
    }

    public static boolean isRemote(Class<?> type) {
        return RMI.isRemote(type);
    }

    public static Set<String> standardEncodings() {
        return StandardEncodingsHolder.standardEncodings;
    }

    public static FlavorTable adaptFlavorMap(final FlavorMap map) {
        if (map instanceof FlavorTable) {
            return (FlavorTable)map;
        }
        return new FlavorTable(){

            public Map getNativesForFlavors(DataFlavor[] flavors) {
                return map.getNativesForFlavors(flavors);
            }

            public Map getFlavorsForNatives(String[] natives) {
                return map.getFlavorsForNatives(natives);
            }

            public List getNativesForFlavor(DataFlavor flav) {
                Map natives = this.getNativesForFlavors(new DataFlavor[]{flav});
                String nat = (String)natives.get(flav);
                if (nat != null) {
                    ArrayList<String> list = new ArrayList<String>(1);
                    list.add(nat);
                    return list;
                }
                return Collections.EMPTY_LIST;
            }

            public List getFlavorsForNative(String nat) {
                Map flavors = this.getFlavorsForNatives(new String[]{nat});
                DataFlavor flavor = (DataFlavor)flavors.get(nat);
                if (flavor != null) {
                    ArrayList<DataFlavor> list = new ArrayList<DataFlavor>(1);
                    list.add(flavor);
                    return list;
                }
                return Collections.EMPTY_LIST;
            }
        };
    }

    public abstract String getDefaultUnicodeEncoding();

    public void registerTextFlavorProperties(String nat, String charset, String eoln, String terminators) {
        Integer iTerminators;
        Long format = this.getFormatForNativeAsLong(nat);
        textNatives.add(format);
        nativeCharsets.put(format, charset != null && charset.length() != 0 ? charset : DataTransferer.getDefaultTextCharset());
        if (eoln != null && eoln.length() != 0 && !eoln.equals("\n")) {
            nativeEOLNs.put(format, eoln);
        }
        if (terminators != null && terminators.length() != 0 && (iTerminators = Integer.valueOf(terminators)) > 0) {
            nativeTerminators.put(format, iTerminators);
        }
    }

    protected boolean isTextFormat(long format) {
        return textNatives.contains(format);
    }

    protected String getCharsetForTextFormat(Long lFormat) {
        return (String)nativeCharsets.get(lFormat);
    }

    public abstract boolean isLocaleDependentTextFormat(long var1);

    public abstract boolean isFileFormat(long var1);

    public abstract boolean isImageFormat(long var1);

    protected boolean isURIListFormat(long format) {
        return false;
    }

    public SortedMap<Long, DataFlavor> getFormatsForTransferable(Transferable contents, FlavorTable map) {
        DataFlavor[] flavors = contents.getTransferDataFlavors();
        if (flavors == null) {
            return new TreeMap<Long, DataFlavor>();
        }
        return this.getFormatsForFlavors(flavors, map);
    }

    public SortedMap getFormatsForFlavor(DataFlavor flavor, FlavorTable map) {
        return this.getFormatsForFlavors(new DataFlavor[]{flavor}, map);
    }

    public SortedMap<Long, DataFlavor> getFormatsForFlavors(DataFlavor[] flavors, FlavorTable map) {
        HashMap<Long, DataFlavor> formatMap = new HashMap<Long, DataFlavor>(flavors.length);
        HashMap<Long, DataFlavor> textPlainMap = new HashMap<Long, DataFlavor>(flavors.length);
        HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>(flavors.length);
        HashMap<Long, Integer> textPlainIndexMap = new HashMap<Long, Integer>(flavors.length);
        int currentIndex = 0;
        for (int i = flavors.length - 1; i >= 0; --i) {
            DataFlavor flavor = flavors[i];
            if (flavor == null || !flavor.isFlavorTextType() && !flavor.isFlavorJavaFileListType() && !DataFlavor.imageFlavor.equals(flavor) && !flavor.isRepresentationClassSerializable() && !flavor.isRepresentationClassInputStream() && !flavor.isRepresentationClassRemote()) continue;
            List<String> natives = map.getNativesForFlavor(flavor);
            currentIndex += natives.size();
            Iterator<String> iter = natives.iterator();
            while (iter.hasNext()) {
                Long lFormat = this.getFormatForNativeAsLong(iter.next());
                Integer index = currentIndex--;
                formatMap.put(lFormat, flavor);
                indexMap.put(lFormat, index);
                if ((!"text".equals(flavor.getPrimaryType()) || !"plain".equals(flavor.getSubType())) && !flavor.equals(DataFlavor.stringFlavor)) continue;
                textPlainMap.put(lFormat, flavor);
                textPlainIndexMap.put(lFormat, index);
            }
            currentIndex += natives.size();
        }
        formatMap.putAll(textPlainMap);
        indexMap.putAll(textPlainIndexMap);
        IndexOrderComparator comparator = new IndexOrderComparator(indexMap, false);
        TreeMap<Long, DataFlavor> sortedMap = new TreeMap<Long, DataFlavor>(comparator);
        sortedMap.putAll(formatMap);
        return sortedMap;
    }

    public long[] getFormatsForTransferableAsArray(Transferable contents, FlavorTable map) {
        return DataTransferer.keysToLongArray(this.getFormatsForTransferable(contents, map));
    }

    public long[] getFormatsForFlavorAsArray(DataFlavor flavor, FlavorTable map) {
        return DataTransferer.keysToLongArray(this.getFormatsForFlavor(flavor, map));
    }

    public long[] getFormatsForFlavorsAsArray(DataFlavor[] flavors, FlavorTable map) {
        return DataTransferer.keysToLongArray(this.getFormatsForFlavors(flavors, map));
    }

    public Map getFlavorsForFormat(long format, FlavorTable map) {
        return this.getFlavorsForFormats(new long[]{format}, map);
    }

    public Map getFlavorsForFormats(long[] formats, FlavorTable map) {
        HashMap<DataFlavor, Long> flavorMap = new HashMap<DataFlavor, Long>(formats.length);
        HashSet<Object> mappingSet = new HashSet<Object>(formats.length);
        HashSet<DataFlavor> flavorSet = new HashSet<DataFlavor>(formats.length);
        for (int i = 0; i < formats.length; ++i) {
            long format = formats[i];
            String nat = this.getNativeForFormat(format);
            List<DataFlavor> flavors = map.getFlavorsForNative(nat);
            for (DataFlavor flavor : flavors) {
                if (!flavor.isFlavorTextType() && !flavor.isFlavorJavaFileListType() && !DataFlavor.imageFlavor.equals(flavor) && !flavor.isRepresentationClassSerializable() && !flavor.isRepresentationClassInputStream() && !flavor.isRepresentationClassRemote()) continue;
                Long lFormat = format;
                Object mapping = DataTransferer.createMapping(lFormat, flavor);
                flavorMap.put(flavor, lFormat);
                mappingSet.add(mapping);
                flavorSet.add(flavor);
            }
        }
        block2: for (DataFlavor flavor : flavorSet) {
            List<String> natives = map.getNativesForFlavor(flavor);
            Iterator<String> nativeIter = natives.iterator();
            while (nativeIter.hasNext()) {
                Long lFormat = this.getFormatForNativeAsLong(nativeIter.next());
                Object mapping = DataTransferer.createMapping(lFormat, flavor);
                if (!mappingSet.contains(mapping)) continue;
                flavorMap.put(flavor, lFormat);
                continue block2;
            }
        }
        return flavorMap;
    }

    public Set getFlavorsForFormatsAsSet(long[] formats, FlavorTable map) {
        HashSet<DataFlavor> flavorSet = new HashSet<DataFlavor>(formats.length);
        for (int i = 0; i < formats.length; ++i) {
            String nat = this.getNativeForFormat(formats[i]);
            List<DataFlavor> flavors = map.getFlavorsForNative(nat);
            for (DataFlavor flavor : flavors) {
                if (!flavor.isFlavorTextType() && !flavor.isFlavorJavaFileListType() && !DataFlavor.imageFlavor.equals(flavor) && !flavor.isRepresentationClassSerializable() && !flavor.isRepresentationClassInputStream() && !flavor.isRepresentationClassRemote()) continue;
                flavorSet.add(flavor);
            }
        }
        return flavorSet;
    }

    public DataFlavor[] getFlavorsForFormatAsArray(long format, FlavorTable map) {
        return this.getFlavorsForFormatsAsArray(new long[]{format}, map);
    }

    public DataFlavor[] getFlavorsForFormatsAsArray(long[] formats, FlavorTable map) {
        return DataTransferer.setToSortedDataFlavorArray(this.getFlavorsForFormatsAsSet(formats, map));
    }

    private static Object createMapping(Object key, Object value) {
        return Arrays.asList(key, value);
    }

    protected abstract Long getFormatForNativeAsLong(String var1);

    protected abstract String getNativeForFormat(long var1);

    private String getBestCharsetForTextFormat(Long lFormat, Transferable localeTransferable) throws IOException {
        String charset = null;
        if (localeTransferable != null && this.isLocaleDependentTextFormat(lFormat) && localeTransferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
            try {
                charset = new String((byte[])localeTransferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {}
        } else {
            charset = this.getCharsetForTextFormat(lFormat);
        }
        if (charset == null) {
            charset = DataTransferer.getDefaultTextCharset();
        }
        return charset;
    }

    private byte[] translateTransferableString(String str, long format) throws IOException {
        Long lFormat = format;
        String charset = this.getBestCharsetForTextFormat(lFormat, null);
        String eoln = (String)nativeEOLNs.get(lFormat);
        if (eoln != null) {
            int length = str.length();
            StringBuffer buffer = new StringBuffer(length * 2);
            for (int i = 0; i < length; ++i) {
                if (str.startsWith(eoln, i)) {
                    buffer.append(eoln);
                    i += eoln.length() - 1;
                    continue;
                }
                char c = str.charAt(i);
                if (c == '\n') {
                    buffer.append(eoln);
                    continue;
                }
                buffer.append(c);
            }
            str = buffer.toString();
        }
        byte[] bytes = str.getBytes(charset);
        Integer terminators = (Integer)nativeTerminators.get(lFormat);
        if (terminators != null) {
            int numTerminators = terminators;
            byte[] terminatedBytes = new byte[bytes.length + numTerminators];
            System.arraycopy(bytes, 0, terminatedBytes, 0, bytes.length);
            for (int i = bytes.length; i < terminatedBytes.length; ++i) {
                terminatedBytes[i] = 0;
            }
            bytes = terminatedBytes;
        }
        return bytes;
    }

    private String translateBytesToString(byte[] bytes, long format, Transferable localeTransferable) throws IOException {
        int count;
        Long lFormat = format;
        String charset = this.getBestCharsetForTextFormat(lFormat, localeTransferable);
        String eoln = (String)nativeEOLNs.get(lFormat);
        Integer terminators = (Integer)nativeTerminators.get(lFormat);
        if (terminators != null) {
            int numTerminators = terminators;
            block0: for (count = 0; count < bytes.length - numTerminators + 1; count += numTerminators) {
                for (int i = count; i < count + numTerminators; ++i) {
                    if (bytes[i] != 0) continue block0;
                }
                break;
            }
        } else {
            count = bytes.length;
        }
        String converted = new String(bytes, 0, count, charset);
        if (eoln != null) {
            char[] buf = converted.toCharArray();
            char[] eoln_arr = eoln.toCharArray();
            converted = null;
            int j = 0;
            int i = 0;
            while (i < buf.length) {
                if (i + eoln_arr.length > buf.length) {
                    buf[j++] = buf[i++];
                    continue;
                }
                boolean match = true;
                int k = 0;
                int l = i;
                while (k < eoln_arr.length) {
                    if (eoln_arr[k] != buf[l]) {
                        match = false;
                        break;
                    }
                    ++k;
                    ++l;
                }
                if (match) {
                    buf[j++] = 10;
                    i += eoln_arr.length;
                    continue;
                }
                buf[j++] = buf[i++];
            }
            converted = new String(buf, 0, j);
        }
        return converted;
    }

    public byte[] translateTransferable(Transferable contents, DataFlavor flavor, long format) throws IOException {
        boolean stringSelectionHack;
        Object obj;
        try {
            obj = contents.getTransferData(flavor);
            if (obj == null) {
                return null;
            }
            if (flavor.equals(DataFlavor.plainTextFlavor) && !(obj instanceof InputStream)) {
                obj = contents.getTransferData(DataFlavor.stringFlavor);
                if (obj == null) {
                    return null;
                }
                stringSelectionHack = true;
            } else {
                stringSelectionHack = false;
            }
        }
        catch (UnsupportedFlavorException e) {
            throw new IOException(e.getMessage());
        }
        if (stringSelectionHack || String.class.equals(flavor.getRepresentationClass()) && DataTransferer.isFlavorCharsetTextType(flavor) && this.isTextFormat(format)) {
            String str = this.removeSuspectedData(flavor, contents, (String)obj);
            return this.translateTransferableString(str, format);
        }
        if (flavor.isRepresentationClassReader()) {
            if (!DataTransferer.isFlavorCharsetTextType(flavor) || !this.isTextFormat(format)) {
                throw new IOException("cannot transfer non-text data as Reader");
            }
            StringBuffer buf = new StringBuffer();
            try (Reader r = (Reader)obj;){
                int c;
                while ((c = r.read()) != -1) {
                    buf.append((char)c);
                }
            }
            return this.translateTransferableString(buf.toString(), format);
        }
        if (flavor.isRepresentationClassCharBuffer()) {
            if (!DataTransferer.isFlavorCharsetTextType(flavor) || !this.isTextFormat(format)) {
                throw new IOException("cannot transfer non-text data as CharBuffer");
            }
            CharBuffer buffer = (CharBuffer)obj;
            int size = buffer.remaining();
            char[] chars = new char[size];
            buffer.get(chars, 0, size);
            return this.translateTransferableString(new String(chars), format);
        }
        if (char[].class.equals(flavor.getRepresentationClass())) {
            if (!DataTransferer.isFlavorCharsetTextType(flavor) || !this.isTextFormat(format)) {
                throw new IOException("cannot transfer non-text data as char array");
            }
            return this.translateTransferableString(new String((char[])obj), format);
        }
        if (flavor.isRepresentationClassByteBuffer()) {
            ByteBuffer buffer = (ByteBuffer)obj;
            int size = buffer.remaining();
            byte[] bytes = new byte[size];
            buffer.get(bytes, 0, size);
            if (DataTransferer.isFlavorCharsetTextType(flavor) && this.isTextFormat(format)) {
                String sourceEncoding = DataTransferer.getTextCharset(flavor);
                return this.translateTransferableString(new String(bytes, sourceEncoding), format);
            }
            return bytes;
        }
        if (byte[].class.equals(flavor.getRepresentationClass())) {
            byte[] bytes = (byte[])obj;
            if (DataTransferer.isFlavorCharsetTextType(flavor) && this.isTextFormat(format)) {
                String sourceEncoding = DataTransferer.getTextCharset(flavor);
                return this.translateTransferableString(new String(bytes, sourceEncoding), format);
            }
            return bytes;
        }
        if (DataFlavor.imageFlavor.equals(flavor)) {
            if (!this.isImageFormat(format)) {
                throw new IOException("Data translation failed: not an image format");
            }
            Image image = (Image)obj;
            byte[] bytes = this.imageToPlatformBytes(image, format);
            if (bytes == null) {
                throw new IOException("Data translation failed: cannot convert java image to native format");
            }
            return bytes;
        }
        byte[] theByteArray = null;
        if (this.isFileFormat(format)) {
            if (!DataFlavor.javaFileListFlavor.equals(flavor)) {
                throw new IOException("data translation failed");
            }
            List list = (List)obj;
            ProtectionDomain userProtectionDomain = DataTransferer.getUserProtectionDomain(contents);
            ArrayList<String> fileList = this.castToFiles(list, userProtectionDomain);
            try (ByteArrayOutputStream bos = this.convertFileListToBytes(fileList);){
                theByteArray = bos.toByteArray();
            }
        }
        if (this.isURIListFormat(format)) {
            if (!DataFlavor.javaFileListFlavor.equals(flavor)) {
                throw new IOException("data translation failed");
            }
            String nat = this.getNativeForFormat(format);
            String targetCharset = null;
            if (nat != null) {
                try {
                    targetCharset = new DataFlavor(nat).getParameter("charset");
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IOException(cnfe);
                }
            }
            if (targetCharset == null) {
                targetCharset = "UTF-8";
            }
            List list = (List)obj;
            ProtectionDomain userProtectionDomain = DataTransferer.getUserProtectionDomain(contents);
            ArrayList<String> fileList = this.castToFiles(list, userProtectionDomain);
            ArrayList<String> uriList = new ArrayList<String>(fileList.size());
            for (String fileObject : fileList) {
                URI uri = new File(fileObject).toURI();
                try {
                    uriList.add(new URI(uri.getScheme(), "", uri.getPath(), uri.getFragment()).toString());
                }
                catch (URISyntaxException uriSyntaxException) {
                    throw new IOException(uriSyntaxException);
                }
            }
            byte[] eoln = "\r\n".getBytes(targetCharset);
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                for (int i = 0; i < uriList.size(); ++i) {
                    byte[] bytes = ((String)uriList.get(i)).getBytes(targetCharset);
                    bos.write(bytes, 0, bytes.length);
                    bos.write(eoln, 0, eoln.length);
                }
                theByteArray = bos.toByteArray();
            }
        }
        if (flavor.isRepresentationClassInputStream()) {
            if (!(obj instanceof InputStream)) {
                return new byte[0];
            }
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                try (InputStream is = (InputStream)obj;){
                    boolean eof = false;
                    int avail = is.available();
                    byte[] tmp = new byte[avail > 8192 ? avail : 8192];
                    do {
                        int aValue;
                        if (eof = (aValue = is.read(tmp, 0, tmp.length)) == -1) continue;
                        bos.write(tmp, 0, aValue);
                    } while (!eof);
                }
                if (DataTransferer.isFlavorCharsetTextType(flavor) && this.isTextFormat(format)) {
                    byte[] bytes = bos.toByteArray();
                    String sourceEncoding = DataTransferer.getTextCharset(flavor);
                    byte[] byArray = this.translateTransferableString(new String(bytes, sourceEncoding), format);
                    return byArray;
                }
                theByteArray = bos.toByteArray();
            }
        }
        if (flavor.isRepresentationClassRemote()) {
            Object mo = RMI.newMarshalledObject(obj);
            theByteArray = DataTransferer.convertObjectToBytes(mo);
        } else if (flavor.isRepresentationClassSerializable()) {
            theByteArray = DataTransferer.convertObjectToBytes(obj);
        } else {
            throw new IOException("data translation failed");
        }
        return theByteArray;
    }

    /*
     * Exception decompiling
     */
    private static byte[] convertObjectToBytes(Object object) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract ByteArrayOutputStream convertFileListToBytes(ArrayList<String> var1) throws IOException;

    private String removeSuspectedData(DataFlavor flavor, Transferable contents, final String str) throws IOException {
        if (null == System.getSecurityManager() || !flavor.isMimeTypeEqual("text/uri-list")) {
            return str;
        }
        String ret_val = "";
        final ProtectionDomain userProtectionDomain = DataTransferer.getUserProtectionDomain(contents);
        try {
            ret_val = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    String[] uriArray;
                    StringBuffer allowedFiles = new StringBuffer(str.length());
                    for (String fileName : uriArray = str.split("(\\s)+")) {
                        File file = new File(fileName);
                        if (!file.exists() || DataTransferer.isFileInWebstartedCache(file) || DataTransferer.this.isForbiddenToRead(file, userProtectionDomain)) continue;
                        if (0 != allowedFiles.length()) {
                            allowedFiles.append("\\r\\n");
                        }
                        allowedFiles.append(fileName);
                    }
                    return allowedFiles.toString();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new IOException(pae.getMessage(), pae);
        }
        return ret_val;
    }

    private static ProtectionDomain getUserProtectionDomain(Transferable contents) {
        return contents.getClass().getProtectionDomain();
    }

    private boolean isForbiddenToRead(File file, ProtectionDomain protectionDomain) {
        if (null == protectionDomain) {
            return false;
        }
        try {
            FilePermission filePermission = new FilePermission(file.getCanonicalPath(), "read, delete");
            if (protectionDomain.implies(filePermission)) {
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private ArrayList<String> castToFiles(final List files, final ProtectionDomain userProtectionDomain) throws IOException {
        final ArrayList<String> fileList = new ArrayList<String>();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    for (Object fileObject : files) {
                        File file = DataTransferer.this.castToFile(fileObject);
                        if (file == null || null != System.getSecurityManager() && (DataTransferer.isFileInWebstartedCache(file) || DataTransferer.this.isForbiddenToRead(file, userProtectionDomain))) continue;
                        fileList.add(file.getCanonicalPath());
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new IOException(pae.getMessage());
        }
        return fileList;
    }

    private File castToFile(Object fileObject) throws IOException {
        String filePath = null;
        if (fileObject instanceof File) {
            filePath = ((File)fileObject).getCanonicalPath();
        } else if (fileObject instanceof String) {
            filePath = (String)fileObject;
        } else {
            return null;
        }
        return new File(filePath);
    }

    private static boolean isFileInWebstartedCache(File f) {
        if (deploymentCacheDirectoryList.isEmpty()) {
            for (String cacheDirectoryProperty : DEPLOYMENT_CACHE_PROPERTIES) {
                String cacheDirectoryPath = System.getProperty(cacheDirectoryProperty);
                if (cacheDirectoryPath == null) continue;
                try {
                    File cacheDirectory = new File(cacheDirectoryPath).getCanonicalFile();
                    if (cacheDirectory == null) continue;
                    deploymentCacheDirectoryList.add(cacheDirectory);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        for (File deploymentCacheDirectory : deploymentCacheDirectoryList) {
            for (File dir = f; dir != null; dir = dir.getParentFile()) {
                if (!dir.equals(deploymentCacheDirectory)) continue;
                return true;
            }
        }
        return false;
    }

    public Object translateBytes(byte[] bytes, DataFlavor flavor, long format, Transferable localeTransferable) throws IOException {
        Object theObject;
        block108: {
            theObject = null;
            if (this.isFileFormat(format)) {
                if (!DataFlavor.javaFileListFlavor.equals(flavor)) {
                    throw new IOException("data translation failed");
                }
                String[] filenames = this.dragQueryFile(bytes);
                if (filenames == null) {
                    return null;
                }
                File[] files = new File[filenames.length];
                for (int i = 0; i < filenames.length; ++i) {
                    files[i] = new File(filenames[i]);
                }
                theObject = Arrays.asList(files);
            } else {
                if (this.isURIListFormat(format) && DataFlavor.javaFileListFlavor.equals(flavor)) {
                    try (ByteArrayInputStream str = new ByteArrayInputStream(bytes);){
                        URI[] uris = this.dragQueryURIs(str, format, localeTransferable);
                        if (uris == null) {
                            Object var10_34 = null;
                            return var10_34;
                        }
                        ArrayList<File> files = new ArrayList<File>();
                        for (URI uri : uris) {
                            try {
                                files.add(new File(uri));
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                        theObject = files;
                    }
                }
                if (String.class.equals(flavor.getRepresentationClass()) && DataTransferer.isFlavorCharsetTextType(flavor) && this.isTextFormat(format)) {
                    theObject = this.translateBytesToString(bytes, format, localeTransferable);
                } else {
                    if (flavor.isRepresentationClassReader()) {
                        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
                            theObject = this.translateStream(bais, flavor, format, localeTransferable);
                        }
                    }
                    if (flavor.isRepresentationClassCharBuffer()) {
                        if (!DataTransferer.isFlavorCharsetTextType(flavor) || !this.isTextFormat(format)) {
                            throw new IOException("cannot transfer non-text data as CharBuffer");
                        }
                        CharBuffer buffer = CharBuffer.wrap(this.translateBytesToString(bytes, format, localeTransferable));
                        theObject = this.constructFlavoredObject(buffer, flavor, CharBuffer.class);
                    } else if (char[].class.equals(flavor.getRepresentationClass())) {
                        if (!DataTransferer.isFlavorCharsetTextType(flavor) || !this.isTextFormat(format)) {
                            throw new IOException("cannot transfer non-text data as char array");
                        }
                        theObject = this.translateBytesToString(bytes, format, localeTransferable).toCharArray();
                    } else if (flavor.isRepresentationClassByteBuffer()) {
                        if (DataTransferer.isFlavorCharsetTextType(flavor) && this.isTextFormat(format)) {
                            bytes = this.translateBytesToString(bytes, format, localeTransferable).getBytes(DataTransferer.getTextCharset(flavor));
                        }
                        ByteBuffer buffer = ByteBuffer.wrap(bytes);
                        theObject = this.constructFlavoredObject(buffer, flavor, ByteBuffer.class);
                    } else if (byte[].class.equals(flavor.getRepresentationClass())) {
                        theObject = DataTransferer.isFlavorCharsetTextType(flavor) && this.isTextFormat(format) ? (Object)this.translateBytesToString(bytes, format, localeTransferable).getBytes(DataTransferer.getTextCharset(flavor)) : (Object)bytes;
                    } else {
                        if (flavor.isRepresentationClassInputStream()) {
                            try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
                                theObject = this.translateStream(bais, flavor, format, localeTransferable);
                            }
                        }
                        if (flavor.isRepresentationClassRemote()) {
                            try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                                 ObjectInputStream ois = new ObjectInputStream(bais);){
                                theObject = RMI.getMarshalledObject(ois.readObject());
                                break block108;
                            }
                            catch (Exception e) {
                                throw new IOException(e.getMessage());
                            }
                        }
                        if (flavor.isRepresentationClassSerializable()) {
                            try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
                                theObject = this.translateStream(bais, flavor, format, localeTransferable);
                            }
                        } else if (DataFlavor.imageFlavor.equals(flavor)) {
                            if (!this.isImageFormat(format)) {
                                throw new IOException("data translation failed");
                            }
                            theObject = this.platformImageBytesToImage(bytes, format);
                        }
                    }
                }
            }
        }
        if (theObject == null) {
            throw new IOException("data translation failed");
        }
        return theObject;
    }

    public Object translateStream(InputStream str, DataFlavor flavor, long format, Transferable localeTransferable) throws IOException {
        Object theObject;
        block49: {
            theObject = null;
            if (this.isURIListFormat(format) && DataFlavor.javaFileListFlavor.equals(flavor)) {
                URI[] uris = this.dragQueryURIs(str, format, localeTransferable);
                if (uris == null) {
                    return null;
                }
                ArrayList<File> files = new ArrayList<File>();
                for (URI uri : uris) {
                    try {
                        files.add(new File(uri));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                theObject = files;
            } else {
                if (String.class.equals(flavor.getRepresentationClass()) && DataTransferer.isFlavorCharsetTextType(flavor) && this.isTextFormat(format)) {
                    return this.translateBytesToString(DataTransferer.inputStreamToByteArray(str), format, localeTransferable);
                }
                if (DataFlavor.plainTextFlavor.equals(flavor)) {
                    theObject = new StringReader(this.translateBytesToString(DataTransferer.inputStreamToByteArray(str), format, localeTransferable));
                } else if (flavor.isRepresentationClassInputStream()) {
                    theObject = this.translateStreamToInputStream(str, flavor, format, localeTransferable);
                } else if (flavor.isRepresentationClassReader()) {
                    if (!DataTransferer.isFlavorCharsetTextType(flavor) || !this.isTextFormat(format)) {
                        throw new IOException("cannot transfer non-text data as Reader");
                    }
                    InputStream is = (InputStream)this.translateStreamToInputStream(str, DataFlavor.plainTextFlavor, format, localeTransferable);
                    String unicode = DataTransferer.getTextCharset(DataFlavor.plainTextFlavor);
                    InputStreamReader reader = new InputStreamReader(is, unicode);
                    theObject = this.constructFlavoredObject(reader, flavor, Reader.class);
                } else if (byte[].class.equals(flavor.getRepresentationClass())) {
                    theObject = DataTransferer.isFlavorCharsetTextType(flavor) && this.isTextFormat(format) ? (Object)this.translateBytesToString(DataTransferer.inputStreamToByteArray(str), format, localeTransferable).getBytes(DataTransferer.getTextCharset(flavor)) : (Object)DataTransferer.inputStreamToByteArray(str);
                } else {
                    if (flavor.isRepresentationClassRemote()) {
                        try (ObjectInputStream ois = new ObjectInputStream(str);){
                            theObject = RMI.getMarshalledObject(ois.readObject());
                            break block49;
                        }
                        catch (Exception e) {
                            throw new IOException(e.getMessage());
                        }
                    }
                    if (flavor.isRepresentationClassSerializable()) {
                        try (ObjectInputStream ois = new ObjectInputStream(str);){
                            theObject = ois.readObject();
                            break block49;
                        }
                        catch (Exception e) {
                            throw new IOException(e.getMessage());
                        }
                    }
                    if (DataFlavor.imageFlavor.equals(flavor)) {
                        if (!this.isImageFormat(format)) {
                            throw new IOException("data translation failed");
                        }
                        theObject = this.platformImageBytesToImage(DataTransferer.inputStreamToByteArray(str), format);
                    }
                }
            }
        }
        if (theObject == null) {
            throw new IOException("data translation failed");
        }
        return theObject;
    }

    private Object translateStreamToInputStream(InputStream str, DataFlavor flavor, long format, Transferable localeTransferable) throws IOException {
        if (DataTransferer.isFlavorCharsetTextType(flavor) && this.isTextFormat(format)) {
            str = new ReencodingInputStream(str, format, DataTransferer.getTextCharset(flavor), localeTransferable);
        }
        return this.constructFlavoredObject(str, flavor, InputStream.class);
    }

    private Object constructFlavoredObject(Object arg, DataFlavor flavor, Class clazz) throws IOException {
        final Class<?> dfrc = flavor.getRepresentationClass();
        if (clazz.equals(dfrc)) {
            return arg;
        }
        Constructor[] constructors = null;
        try {
            constructors = (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return dfrc.getConstructors();
                }
            });
        }
        catch (SecurityException se) {
            throw new IOException(se.getMessage());
        }
        Constructor constructor = null;
        for (int j = 0; j < constructors.length; ++j) {
            Class<?>[] ptypes;
            if (!Modifier.isPublic(constructors[j].getModifiers()) || (ptypes = constructors[j].getParameterTypes()) == null || ptypes.length != 1 || !clazz.equals(ptypes[0])) continue;
            constructor = constructors[j];
            break;
        }
        if (constructor == null) {
            throw new IOException("can't find <init>(L" + clazz + ";)V for class: " + dfrc.getName());
        }
        try {
            return constructor.newInstance(arg);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    protected abstract String[] dragQueryFile(byte[] var1);

    protected URI[] dragQueryURIs(InputStream stream, long format, Transferable localeTransferable) throws IOException {
        throw new IOException(new UnsupportedOperationException("not implemented on this platform"));
    }

    protected abstract Image platformImageBytesToImage(byte[] var1, long var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Image standardImageBytesToImage(byte[] bytes, String mimeType) throws IOException {
        Iterator<ImageReader> readerIterator = ImageIO.getImageReadersByMIMEType(mimeType);
        if (!readerIterator.hasNext()) {
            throw new IOException("No registered service provider can decode  an image from " + mimeType);
        }
        IOException ioe = null;
        while (true) {
            if (!readerIterator.hasNext()) {
                if (ioe != null) throw ioe;
                ioe = new IOException("Registered service providers failed to decode an image from " + mimeType);
                throw ioe;
            }
            ImageReader imageReader = readerIterator.next();
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                Throwable throwable = null;
                try {
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(bais);
                    try {
                        ImageReadParam param = imageReader.getDefaultReadParam();
                        imageReader.setInput(imageInputStream, true, true);
                        BufferedImage bufferedImage = imageReader.read(imageReader.getMinIndex(), param);
                        if (bufferedImage == null) continue;
                        BufferedImage bufferedImage2 = bufferedImage;
                        return bufferedImage2;
                    }
                    finally {
                        imageInputStream.close();
                        imageReader.dispose();
                        continue;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (bais == null) continue;
                    if (throwable != null) {
                        try {
                            bais.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    bais.close();
                }
            }
            catch (IOException e) {
                ioe = e;
                continue;
            }
            break;
        }
    }

    protected abstract byte[] imageToPlatformBytes(Image var1, long var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] imageToStandardBytes(Image image, String mimeType) throws IOException {
        IOException originalIOE = null;
        Iterator<ImageWriter> writerIterator = ImageIO.getImageWritersByMIMEType(mimeType);
        if (!writerIterator.hasNext()) {
            throw new IOException("No registered service provider can encode  an image to " + mimeType);
        }
        if (image instanceof RenderedImage) {
            try {
                return this.imageToStandardBytesImpl((RenderedImage)((Object)image), mimeType);
            }
            catch (IOException ioe) {
                originalIOE = ioe;
            }
        }
        int width = 0;
        int height = 0;
        if (image instanceof ToolkitImage) {
            ImageRepresentation ir = ((ToolkitImage)image).getImageRep();
            ir.reconstruct(32);
            width = ir.getWidth();
            height = ir.getHeight();
        } else {
            width = image.getWidth(null);
            height = image.getHeight(null);
        }
        ColorModel model = ColorModel.getRGBdefault();
        WritableRaster raster = model.createCompatibleWritableRaster(width, height);
        BufferedImage bufferedImage = new BufferedImage(model, raster, model.isAlphaPremultiplied(), null);
        Graphics g = bufferedImage.getGraphics();
        try {
            g.drawImage(image, 0, 0, width, height, null);
        }
        finally {
            g.dispose();
        }
        try {
            return this.imageToStandardBytesImpl(bufferedImage, mimeType);
        }
        catch (IOException ioe) {
            if (originalIOE != null) {
                throw originalIOE;
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] imageToStandardBytesImpl(RenderedImage renderedImage, String mimeType) throws IOException {
        Iterator<ImageWriter> writerIterator = ImageIO.getImageWritersByMIMEType(mimeType);
        ImageTypeSpecifier typeSpecifier = new ImageTypeSpecifier(renderedImage);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOException ioe = null;
        while (writerIterator.hasNext()) {
            ImageWriter imageWriter = writerIterator.next();
            ImageWriterSpi writerSpi = imageWriter.getOriginatingProvider();
            if (!writerSpi.canEncodeImage(typeSpecifier)) continue;
            try (ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(baos);){
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(renderedImage);
                imageOutputStream.flush();
            }
            catch (IOException e) {
                imageWriter.dispose();
                baos.reset();
                ioe = e;
                continue;
            }
            imageWriter.dispose();
            baos.close();
            return baos.toByteArray();
        }
        baos.close();
        if (ioe == null) {
            ioe = new IOException("Registered service providers failed to encode " + renderedImage + " to " + mimeType);
        }
        throw ioe;
    }

    private Object concatData(Object obj1, Object obj2) {
        InputStream str1 = null;
        InputStream str2 = null;
        if (obj1 instanceof byte[]) {
            byte[] arr1 = (byte[])obj1;
            if (obj2 instanceof byte[]) {
                byte[] arr2 = (byte[])obj2;
                byte[] ret = new byte[arr1.length + arr2.length];
                System.arraycopy(arr1, 0, ret, 0, arr1.length);
                System.arraycopy(arr2, 0, ret, arr1.length, arr2.length);
                return ret;
            }
            str1 = new ByteArrayInputStream(arr1);
            str2 = (InputStream)obj2;
        } else {
            str1 = (InputStream)obj1;
            str2 = obj2 instanceof byte[] ? new ByteArrayInputStream((byte[])obj2) : (InputStream)obj2;
        }
        return new SequenceInputStream(str1, str2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convertData(Object source, final Transferable contents, final long format, final Map formatMap, boolean isToolkitThread) throws IOException {
        byte[] ret = null;
        if (isToolkitThread) {
            try {
                final Stack stack = new Stack();
                Runnable dataConverter = new Runnable(){
                    private boolean done = false;

                    @Override
                    public void run() {
                        if (this.done) {
                            return;
                        }
                        byte[] data = null;
                        try {
                            DataFlavor flavor = (DataFlavor)formatMap.get(format);
                            if (flavor != null) {
                                data = DataTransferer.this.translateTransferable(contents, flavor, format);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            data = null;
                        }
                        try {
                            DataTransferer.this.getToolkitThreadBlockedHandler().lock();
                            stack.push(data);
                            DataTransferer.this.getToolkitThreadBlockedHandler().exit();
                        }
                        finally {
                            DataTransferer.this.getToolkitThreadBlockedHandler().unlock();
                            this.done = true;
                        }
                    }
                };
                AppContext appContext = SunToolkit.targetToAppContext(source);
                this.getToolkitThreadBlockedHandler().lock();
                if (appContext != null) {
                    appContext.put(DATA_CONVERTER_KEY, dataConverter);
                }
                SunToolkit.executeOnEventHandlerThread(source, dataConverter);
                while (stack.empty()) {
                    this.getToolkitThreadBlockedHandler().enter();
                }
                if (appContext != null) {
                    appContext.remove(DATA_CONVERTER_KEY);
                }
                ret = (byte[])stack.pop();
            }
            finally {
                this.getToolkitThreadBlockedHandler().unlock();
            }
        } else {
            DataFlavor flavor = (DataFlavor)formatMap.get(format);
            if (flavor != null) {
                ret = this.translateTransferable(contents, flavor, format);
            }
        }
        return ret;
    }

    public void processDataConversionRequests() {
        if (EventQueue.isDispatchThread()) {
            AppContext appContext = AppContext.getAppContext();
            this.getToolkitThreadBlockedHandler().lock();
            try {
                Runnable dataConverter = (Runnable)appContext.get(DATA_CONVERTER_KEY);
                if (dataConverter != null) {
                    dataConverter.run();
                    appContext.remove(DATA_CONVERTER_KEY);
                }
            }
            finally {
                this.getToolkitThreadBlockedHandler().unlock();
            }
        }
    }

    public abstract ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler();

    public static long[] keysToLongArray(SortedMap map) {
        Set keySet = map.keySet();
        long[] retval = new long[keySet.size()];
        int i = 0;
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            retval[i] = (Long)iter.next();
            ++i;
        }
        return retval;
    }

    public static DataFlavor[] setToSortedDataFlavorArray(Set flavorsSet) {
        DataFlavor[] flavors = new DataFlavor[flavorsSet.size()];
        flavorsSet.toArray(flavors);
        DataFlavorComparator comparator = new DataFlavorComparator(false);
        Arrays.sort(flavors, comparator);
        return flavors;
    }

    protected static byte[] inputStreamToByteArray(InputStream str) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int len = 0;
            byte[] buf = new byte[8192];
            while ((len = str.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public LinkedHashSet<DataFlavor> getPlatformMappingsForNative(String nat) {
        return new LinkedHashSet<DataFlavor>();
    }

    public LinkedHashSet<String> getPlatformMappingsForFlavor(DataFlavor df) {
        return new LinkedHashSet<String>();
    }

    static {
        textNatives = Collections.synchronizedSet(new HashSet());
        nativeCharsets = Collections.synchronizedMap(new HashMap());
        nativeEOLNs = Collections.synchronizedMap(new HashMap());
        nativeTerminators = Collections.synchronizedMap(new HashMap());
        dtLog = PlatformLogger.getLogger("sun.awt.datatransfer.DataTransfer");
        DataFlavor tPlainTextStringFlavor = null;
        try {
            tPlainTextStringFlavor = new DataFlavor("text/plain;charset=Unicode;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        plainTextStringFlavor = tPlainTextStringFlavor;
        DataFlavor tJavaTextEncodingFlavor = null;
        try {
            tJavaTextEncodingFlavor = new DataFlavor("application/x-java-text-encoding;class=\"[B\"");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        javaTextEncodingFlavor = tJavaTextEncodingFlavor;
        HashMap<String, Boolean> tempMap = new HashMap<String, Boolean>(17);
        tempMap.put("sgml", Boolean.TRUE);
        tempMap.put("xml", Boolean.TRUE);
        tempMap.put("html", Boolean.TRUE);
        tempMap.put("enriched", Boolean.TRUE);
        tempMap.put("richtext", Boolean.TRUE);
        tempMap.put("uri-list", Boolean.TRUE);
        tempMap.put("directory", Boolean.TRUE);
        tempMap.put("css", Boolean.TRUE);
        tempMap.put("calendar", Boolean.TRUE);
        tempMap.put("plain", Boolean.TRUE);
        tempMap.put("rtf", Boolean.FALSE);
        tempMap.put("tab-separated-values", Boolean.FALSE);
        tempMap.put("t140", Boolean.FALSE);
        tempMap.put("rfc822-headers", Boolean.FALSE);
        tempMap.put("parityfec", Boolean.FALSE);
        textMIMESubtypeCharsetSupport = Collections.synchronizedMap(tempMap);
        DEPLOYMENT_CACHE_PROPERTIES = new String[]{"deployment.system.cachedir", "deployment.user.cachedir", "deployment.javaws.cachedir", "deployment.javapi.cachedir"};
        deploymentCacheDirectoryList = new ArrayList();
    }

    private static class RMI {
        private static final Class<?> remoteClass = RMI.getClass("java.rmi.Remote");
        private static final Class<?> marshallObjectClass = RMI.getClass("java.rmi.MarshalledObject");
        private static final Constructor<?> marshallCtor = RMI.getConstructor(marshallObjectClass, Object.class);
        private static final Method marshallGet = RMI.getMethod(marshallObjectClass, "get", new Class[0]);

        private RMI() {
        }

        private static Class<?> getClass(String name) {
            try {
                return Class.forName(name, true, null);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        private static Constructor<?> getConstructor(Class<?> c, Class<?> ... types) {
            try {
                return c == null ? null : c.getDeclaredConstructor(types);
            }
            catch (NoSuchMethodException x) {
                throw new AssertionError((Object)x);
            }
        }

        private static Method getMethod(Class<?> c, String name, Class<?> ... types) {
            try {
                return c == null ? null : c.getMethod(name, types);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }

        static boolean isRemote(Class<?> c) {
            return remoteClass == null ? null : Boolean.valueOf(remoteClass.isAssignableFrom(c));
        }

        static Class<?> remoteClass() {
            return remoteClass;
        }

        static Object newMarshalledObject(Object obj) throws IOException {
            try {
                return marshallCtor.newInstance(obj);
            }
            catch (InstantiationException x) {
                throw new AssertionError((Object)x);
            }
            catch (IllegalAccessException x) {
                throw new AssertionError((Object)x);
            }
            catch (InvocationTargetException x) {
                Throwable cause = x.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new AssertionError((Object)x);
            }
        }

        static Object getMarshalledObject(Object obj) throws IOException, ClassNotFoundException {
            try {
                return marshallGet.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException x) {
                throw new AssertionError((Object)x);
            }
            catch (InvocationTargetException x) {
                Throwable cause = x.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)cause;
                }
                throw new AssertionError((Object)x);
            }
        }
    }

    public static class IndexOrderComparator
    extends IndexedComparator {
        private final Map indexMap;
        private static final Integer FALLBACK_INDEX = Integer.MIN_VALUE;

        public IndexOrderComparator(Map indexMap) {
            super(true);
            this.indexMap = indexMap;
        }

        public IndexOrderComparator(Map indexMap, boolean order) {
            super(order);
            this.indexMap = indexMap;
        }

        public int compare(Object obj1, Object obj2) {
            if (!this.order) {
                return -IndexOrderComparator.compareIndices(this.indexMap, obj1, obj2, FALLBACK_INDEX);
            }
            return IndexOrderComparator.compareIndices(this.indexMap, obj1, obj2, FALLBACK_INDEX);
        }
    }

    public static class DataFlavorComparator
    extends IndexedComparator {
        private final CharsetComparator charsetComparator;
        private static final Map exactTypes;
        private static final Map primaryTypes;
        private static final Map nonTextRepresentations;
        private static final Map textTypes;
        private static final Map decodedTextRepresentations;
        private static final Map encodedTextRepresentations;
        private static final Integer UNKNOWN_OBJECT_LOSES;
        private static final Integer UNKNOWN_OBJECT_WINS;
        private static final Long UNKNOWN_OBJECT_LOSES_L;
        private static final Long UNKNOWN_OBJECT_WINS_L;

        public DataFlavorComparator() {
            this(true);
        }

        public DataFlavorComparator(boolean order) {
            super(order);
            this.charsetComparator = new CharsetComparator(order);
        }

        public int compare(Object obj1, Object obj2) {
            DataFlavor flavor1 = null;
            DataFlavor flavor2 = null;
            if (this.order) {
                flavor1 = (DataFlavor)obj1;
                flavor2 = (DataFlavor)obj2;
            } else {
                flavor1 = (DataFlavor)obj2;
                flavor2 = (DataFlavor)obj1;
            }
            if (flavor1.equals(flavor2)) {
                return 0;
            }
            int comp = 0;
            String primaryType1 = flavor1.getPrimaryType();
            String subType1 = flavor1.getSubType();
            String mimeType1 = primaryType1 + "/" + subType1;
            Class<?> class1 = flavor1.getRepresentationClass();
            String primaryType2 = flavor2.getPrimaryType();
            String subType2 = flavor2.getSubType();
            String mimeType2 = primaryType2 + "/" + subType2;
            Class<?> class2 = flavor2.getRepresentationClass();
            if (flavor1.isFlavorTextType() && flavor2.isFlavorTextType()) {
                comp = DataFlavorComparator.compareIndices(textTypes, mimeType1, mimeType2, UNKNOWN_OBJECT_LOSES);
                if (comp != 0) {
                    return comp;
                }
                if (DataTransferer.doesSubtypeSupportCharset(flavor1)) {
                    comp = DataFlavorComparator.compareIndices(decodedTextRepresentations, class1, class2, UNKNOWN_OBJECT_LOSES);
                    if (comp != 0) {
                        return comp;
                    }
                    comp = this.charsetComparator.compareCharsets(DataTransferer.getTextCharset(flavor1), DataTransferer.getTextCharset(flavor2));
                    if (comp != 0) {
                        return comp;
                    }
                }
                if ((comp = DataFlavorComparator.compareIndices(encodedTextRepresentations, class1, class2, UNKNOWN_OBJECT_LOSES)) != 0) {
                    return comp;
                }
            } else {
                if (flavor1.isFlavorTextType()) {
                    return 1;
                }
                if (flavor2.isFlavorTextType()) {
                    return -1;
                }
                comp = DataFlavorComparator.compareIndices(primaryTypes, primaryType1, primaryType2, UNKNOWN_OBJECT_LOSES);
                if (comp != 0) {
                    return comp;
                }
                comp = DataFlavorComparator.compareIndices(exactTypes, mimeType1, mimeType2, UNKNOWN_OBJECT_WINS);
                if (comp != 0) {
                    return comp;
                }
                comp = DataFlavorComparator.compareIndices(nonTextRepresentations, class1, class2, UNKNOWN_OBJECT_LOSES);
                if (comp != 0) {
                    return comp;
                }
            }
            return flavor1.getMimeType().compareTo(flavor2.getMimeType());
        }

        static {
            UNKNOWN_OBJECT_LOSES = Integer.MIN_VALUE;
            UNKNOWN_OBJECT_WINS = Integer.MAX_VALUE;
            UNKNOWN_OBJECT_LOSES_L = Long.MIN_VALUE;
            UNKNOWN_OBJECT_WINS_L = Long.MAX_VALUE;
            HashMap<String, Integer> exactTypesMap = new HashMap<String, Integer>(4, 1.0f);
            exactTypesMap.put("application/x-java-file-list", 0);
            exactTypesMap.put("application/x-java-serialized-object", 1);
            exactTypesMap.put("application/x-java-jvm-local-objectref", 2);
            exactTypesMap.put("application/x-java-remote-object", 3);
            exactTypes = Collections.unmodifiableMap(exactTypesMap);
            HashMap<String, Integer> primaryTypesMap = new HashMap<String, Integer>(1, 1.0f);
            primaryTypesMap.put("application", 0);
            primaryTypes = Collections.unmodifiableMap(primaryTypesMap);
            HashMap nonTextRepresentationsMap = new HashMap(3, 1.0f);
            nonTextRepresentationsMap.put(InputStream.class, 0);
            nonTextRepresentationsMap.put(Serializable.class, 1);
            Class<?> remoteClass = RMI.remoteClass();
            if (remoteClass != null) {
                nonTextRepresentationsMap.put(remoteClass, 2);
            }
            nonTextRepresentations = Collections.unmodifiableMap(nonTextRepresentationsMap);
            HashMap<String, Integer> textTypesMap = new HashMap<String, Integer>(16, 1.0f);
            textTypesMap.put("text/plain", 0);
            textTypesMap.put("application/x-java-serialized-object", 1);
            textTypesMap.put("text/calendar", 2);
            textTypesMap.put("text/css", 3);
            textTypesMap.put("text/directory", 4);
            textTypesMap.put("text/parityfec", 5);
            textTypesMap.put("text/rfc822-headers", 6);
            textTypesMap.put("text/t140", 7);
            textTypesMap.put("text/tab-separated-values", 8);
            textTypesMap.put("text/uri-list", 9);
            textTypesMap.put("text/richtext", 10);
            textTypesMap.put("text/enriched", 11);
            textTypesMap.put("text/rtf", 12);
            textTypesMap.put("text/html", 13);
            textTypesMap.put("text/xml", 14);
            textTypesMap.put("text/sgml", 15);
            textTypes = Collections.unmodifiableMap(textTypesMap);
            HashMap<Class, Integer> decodedTextRepresentationsMap = new HashMap<Class, Integer>(4, 1.0f);
            decodedTextRepresentationsMap.put(char[].class, 0);
            decodedTextRepresentationsMap.put(CharBuffer.class, 1);
            decodedTextRepresentationsMap.put(String.class, 2);
            decodedTextRepresentationsMap.put(Reader.class, 3);
            decodedTextRepresentations = Collections.unmodifiableMap(decodedTextRepresentationsMap);
            HashMap<Class<InputStream>, Integer> encodedTextRepresentationsMap = new HashMap<Class<InputStream>, Integer>(3, 1.0f);
            encodedTextRepresentationsMap.put(byte[].class, 0);
            encodedTextRepresentationsMap.put(ByteBuffer.class, 1);
            encodedTextRepresentationsMap.put(InputStream.class, 2);
            encodedTextRepresentations = Collections.unmodifiableMap(encodedTextRepresentationsMap);
        }
    }

    public static class CharsetComparator
    extends IndexedComparator {
        private static final Map charsets;
        private static String defaultEncoding;
        private static final Integer DEFAULT_CHARSET_INDEX;
        private static final Integer OTHER_CHARSET_INDEX;
        private static final Integer WORST_CHARSET_INDEX;
        private static final Integer UNSUPPORTED_CHARSET_INDEX;
        private static final String UNSUPPORTED_CHARSET = "UNSUPPORTED";

        public CharsetComparator() {
            this(true);
        }

        public CharsetComparator(boolean order) {
            super(order);
        }

        public int compare(Object obj1, Object obj2) {
            String charset1 = null;
            String charset2 = null;
            if (this.order) {
                charset1 = (String)obj1;
                charset2 = (String)obj2;
            } else {
                charset1 = (String)obj2;
                charset2 = (String)obj1;
            }
            return this.compareCharsets(charset1, charset2);
        }

        protected int compareCharsets(String charset1, String charset2) {
            int comp = CharsetComparator.compareIndices(charsets, charset1 = CharsetComparator.getEncoding(charset1), charset2 = CharsetComparator.getEncoding(charset2), OTHER_CHARSET_INDEX);
            if (comp == 0) {
                return charset2.compareTo(charset1);
            }
            return comp;
        }

        protected static String getEncoding(String charset) {
            if (charset == null) {
                return null;
            }
            if (!DataTransferer.isEncodingSupported(charset)) {
                return UNSUPPORTED_CHARSET;
            }
            String canonicalName = DataTransferer.canonicalName(charset);
            return charsets.containsKey(canonicalName) ? canonicalName : charset;
        }

        static {
            DEFAULT_CHARSET_INDEX = 2;
            OTHER_CHARSET_INDEX = 1;
            WORST_CHARSET_INDEX = 0;
            UNSUPPORTED_CHARSET_INDEX = Integer.MIN_VALUE;
            HashMap<String, Integer> charsetsMap = new HashMap<String, Integer>(8, 1.0f);
            charsetsMap.put(DataTransferer.canonicalName("UTF-16LE"), 4);
            charsetsMap.put(DataTransferer.canonicalName("UTF-16BE"), 5);
            charsetsMap.put(DataTransferer.canonicalName("UTF-8"), 6);
            charsetsMap.put(DataTransferer.canonicalName("UTF-16"), 7);
            charsetsMap.put(DataTransferer.canonicalName("US-ASCII"), WORST_CHARSET_INDEX);
            String defEncoding = DataTransferer.canonicalName(DataTransferer.getDefaultTextCharset());
            if (charsetsMap.get(defaultEncoding) == null) {
                charsetsMap.put(defaultEncoding, DEFAULT_CHARSET_INDEX);
            }
            charsetsMap.put(UNSUPPORTED_CHARSET, UNSUPPORTED_CHARSET_INDEX);
            charsets = Collections.unmodifiableMap(charsetsMap);
        }
    }

    public static abstract class IndexedComparator
    implements Comparator {
        public static final boolean SELECT_BEST = true;
        public static final boolean SELECT_WORST = false;
        protected final boolean order;

        public IndexedComparator() {
            this(true);
        }

        public IndexedComparator(boolean order) {
            this.order = order;
        }

        protected static int compareIndices(Map indexMap, Object obj1, Object obj2, Integer fallbackIndex) {
            Integer index1 = (Integer)indexMap.get(obj1);
            Integer index2 = (Integer)indexMap.get(obj2);
            if (index1 == null) {
                index1 = fallbackIndex;
            }
            if (index2 == null) {
                index2 = fallbackIndex;
            }
            return index1.compareTo(index2);
        }

        protected static int compareLongs(Map indexMap, Object obj1, Object obj2, Long fallbackIndex) {
            Long index1 = (Long)indexMap.get(obj1);
            Long index2 = (Long)indexMap.get(obj2);
            if (index1 == null) {
                index1 = fallbackIndex;
            }
            if (index2 == null) {
                index2 = fallbackIndex;
            }
            return index1.compareTo(index2);
        }
    }

    public class ReencodingInputStream
    extends InputStream {
        protected BufferedReader wrapped;
        protected final char[] in = new char[2];
        protected byte[] out;
        protected CharsetEncoder encoder;
        protected CharBuffer inBuf;
        protected ByteBuffer outBuf;
        protected char[] eoln;
        protected int numTerminators;
        protected boolean eos;
        protected int index;
        protected int limit;

        public ReencodingInputStream(InputStream bytestream, long format, String targetEncoding, Transferable localeTransferable) throws IOException {
            Integer terminators;
            Long lFormat = format;
            String sourceEncoding = null;
            if (DataTransferer.this.isLocaleDependentTextFormat(format) && localeTransferable != null && localeTransferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
                try {
                    sourceEncoding = new String((byte[])localeTransferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {}
            } else {
                sourceEncoding = DataTransferer.this.getCharsetForTextFormat(lFormat);
            }
            if (sourceEncoding == null) {
                sourceEncoding = DataTransferer.getDefaultTextCharset();
            }
            this.wrapped = new BufferedReader(new InputStreamReader(bytestream, sourceEncoding));
            if (targetEncoding == null) {
                throw new NullPointerException("null target encoding");
            }
            try {
                this.encoder = Charset.forName(targetEncoding).newEncoder();
                this.out = new byte[(int)((double)(this.encoder.maxBytesPerChar() * 2.0f) + 0.5)];
                this.inBuf = CharBuffer.wrap(this.in);
                this.outBuf = ByteBuffer.wrap(this.out);
            }
            catch (IllegalCharsetNameException e) {
                throw new IOException(e.toString());
            }
            catch (UnsupportedCharsetException e) {
                throw new IOException(e.toString());
            }
            catch (UnsupportedOperationException e) {
                throw new IOException(e.toString());
            }
            String sEoln = (String)nativeEOLNs.get(lFormat);
            if (sEoln != null) {
                this.eoln = sEoln.toCharArray();
            }
            if ((terminators = (Integer)nativeTerminators.get(lFormat)) != null) {
                this.numTerminators = terminators;
            }
        }

        private int readChar() throws IOException {
            int c = this.wrapped.read();
            if (c == -1) {
                this.eos = true;
                return -1;
            }
            if (this.numTerminators > 0 && c == 0) {
                this.eos = true;
                return -1;
            }
            if (this.eoln != null && this.matchCharArray(this.eoln, c)) {
                c = 10;
            }
            return c;
        }

        @Override
        public int read() throws IOException {
            if (this.eos) {
                return -1;
            }
            if (this.index >= this.limit) {
                int c = this.readChar();
                if (c == -1) {
                    return -1;
                }
                this.in[0] = (char)c;
                this.in[1] = '\u0000';
                this.inBuf.limit(1);
                if (Character.isHighSurrogate((char)c) && (c = this.readChar()) != -1) {
                    this.in[1] = (char)c;
                    this.inBuf.limit(2);
                }
                this.inBuf.rewind();
                this.outBuf.limit(this.out.length).rewind();
                this.encoder.encode(this.inBuf, this.outBuf, false);
                this.outBuf.flip();
                this.limit = this.outBuf.limit();
                this.index = 0;
                return this.read();
            }
            return this.out[this.index++] & 0xFF;
        }

        @Override
        public int available() throws IOException {
            return this.eos ? 0 : this.limit - this.index;
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }

        private boolean matchCharArray(char[] array, int c) throws IOException {
            this.wrapped.mark(array.length);
            int count = 0;
            if ((char)c == array[0]) {
                for (count = 1; count < array.length && (c = this.wrapped.read()) != -1 && (char)c == array[count]; ++count) {
                }
            }
            if (count == array.length) {
                return true;
            }
            this.wrapped.reset();
            return false;
        }
    }

    private static class StandardEncodingsHolder {
        private static final SortedSet<String> standardEncodings = StandardEncodingsHolder.load();

        private StandardEncodingsHolder() {
        }

        private static SortedSet<String> load() {
            CharsetComparator comparator = new CharsetComparator(false);
            TreeSet<String> tempSet = new TreeSet<String>(comparator);
            tempSet.add("US-ASCII");
            tempSet.add("ISO-8859-1");
            tempSet.add("UTF-8");
            tempSet.add("UTF-16BE");
            tempSet.add("UTF-16LE");
            tempSet.add("UTF-16");
            tempSet.add(DataTransferer.getDefaultTextCharset());
            return Collections.unmodifiableSortedSet(tempSet);
        }
    }
}

