/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;

public final class XPathFilterParameterSpec
implements TransformParameterSpec {
    private String xPath;
    private Map<String, String> nsMap;

    public XPathFilterParameterSpec(String xPath) {
        if (xPath == null) {
            throw new NullPointerException();
        }
        this.xPath = xPath;
        this.nsMap = Collections.emptyMap();
    }

    public XPathFilterParameterSpec(String xPath, Map namespaceMap) {
        if (xPath == null || namespaceMap == null) {
            throw new NullPointerException();
        }
        this.xPath = xPath;
        HashMap copy = new HashMap(namespaceMap);
        for (Map.Entry me : copy.entrySet()) {
            if (me.getKey() instanceof String && me.getValue() instanceof String) continue;
            throw new ClassCastException("not a String");
        }
        HashMap temp = copy;
        this.nsMap = Collections.unmodifiableMap(temp);
    }

    public String getXPath() {
        return this.xPath;
    }

    public Map getNamespaceMap() {
        return this.nsMap;
    }
}

