/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Objects;
import javax.management.Descriptor;
import javax.management.DescriptorRead;
import javax.management.ImmutableDescriptor;

public class MBeanFeatureInfo
implements Serializable,
DescriptorRead {
    static final long serialVersionUID = 3952882688968447265L;
    protected String name;
    protected String description;
    private transient Descriptor descriptor;

    public MBeanFeatureInfo(String name, String description) {
        this(name, description, null);
    }

    public MBeanFeatureInfo(String name, String description, Descriptor descriptor) {
        this.name = name;
        this.description = description;
        this.descriptor = descriptor;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Descriptor getDescriptor() {
        return (Descriptor)ImmutableDescriptor.nonNullDescriptor(this.descriptor).clone();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MBeanFeatureInfo)) {
            return false;
        }
        MBeanFeatureInfo p = (MBeanFeatureInfo)o;
        return Objects.equals(p.getName(), this.getName()) && Objects.equals(p.getDescription(), this.getDescription()) && Objects.equals(p.getDescriptor(), this.getDescriptor());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getDescription().hashCode() ^ this.getDescriptor().hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.descriptor != null && this.descriptor.getClass() == ImmutableDescriptor.class) {
            out.write(1);
            String[] names = this.descriptor.getFieldNames();
            out.writeObject(names);
            out.writeObject(this.descriptor.getFieldValues(names));
        } else {
            out.write(0);
            out.writeObject(this.descriptor);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        switch (in.read()) {
            case 1: {
                String[] names = (String[])in.readObject();
                Object[] values = (Object[])in.readObject();
                this.descriptor = names.length == 0 ? ImmutableDescriptor.EMPTY_DESCRIPTOR : new ImmutableDescriptor(names, values);
                break;
            }
            case 0: {
                this.descriptor = (Descriptor)in.readObject();
                if (this.descriptor != null) break;
                this.descriptor = ImmutableDescriptor.EMPTY_DESCRIPTOR;
                break;
            }
            case -1: {
                this.descriptor = ImmutableDescriptor.EMPTY_DESCRIPTOR;
                break;
            }
            default: {
                throw new StreamCorruptedException("Got unexpected byte.");
            }
        }
    }
}

