/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SOFMarkerSegment
extends MarkerSegment {
    int samplePrecision;
    int numLines;
    int samplesPerLine;
    ComponentSpec[] componentSpecs;

    SOFMarkerSegment(boolean wantProg, boolean wantExtended, boolean willSubsample, byte[] componentIDs, int numComponents) {
        super(wantProg ? 194 : (wantExtended ? 193 : 192));
        this.samplePrecision = 8;
        this.numLines = 0;
        this.samplesPerLine = 0;
        this.componentSpecs = new ComponentSpec[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            int factor = 1;
            int qsel = 0;
            if (willSubsample) {
                factor = 2;
                if (i == 1 || i == 2) {
                    factor = 1;
                    qsel = 1;
                }
            }
            this.componentSpecs[i] = new ComponentSpec(componentIDs[i], factor, qsel);
        }
    }

    SOFMarkerSegment(JPEGBuffer buffer) throws IOException {
        super(buffer);
        this.samplePrecision = buffer.buf[buffer.bufPtr++];
        this.numLines = (buffer.buf[buffer.bufPtr++] & 0xFF) << 8;
        this.numLines |= buffer.buf[buffer.bufPtr++] & 0xFF;
        this.samplesPerLine = (buffer.buf[buffer.bufPtr++] & 0xFF) << 8;
        this.samplesPerLine |= buffer.buf[buffer.bufPtr++] & 0xFF;
        int numComponents = buffer.buf[buffer.bufPtr++] & 0xFF;
        this.componentSpecs = new ComponentSpec[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            this.componentSpecs[i] = new ComponentSpec(buffer);
        }
        buffer.bufAvail -= this.length;
    }

    SOFMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(192);
        this.samplePrecision = 8;
        this.numLines = 0;
        this.samplesPerLine = 0;
        this.updateFromNativeNode(node, true);
    }

    @Override
    protected Object clone() {
        SOFMarkerSegment newGuy = (SOFMarkerSegment)super.clone();
        if (this.componentSpecs != null) {
            newGuy.componentSpecs = (ComponentSpec[])this.componentSpecs.clone();
            for (int i = 0; i < this.componentSpecs.length; ++i) {
                newGuy.componentSpecs[i] = (ComponentSpec)this.componentSpecs[i].clone();
            }
        }
        return newGuy;
    }

    @Override
    IIOMetadataNode getNativeNode() {
        IIOMetadataNode node = new IIOMetadataNode("sof");
        node.setAttribute("process", Integer.toString(this.tag - 192));
        node.setAttribute("samplePrecision", Integer.toString(this.samplePrecision));
        node.setAttribute("numLines", Integer.toString(this.numLines));
        node.setAttribute("samplesPerLine", Integer.toString(this.samplesPerLine));
        node.setAttribute("numFrameComponents", Integer.toString(this.componentSpecs.length));
        for (int i = 0; i < this.componentSpecs.length; ++i) {
            node.appendChild(this.componentSpecs[i].getNativeNode());
        }
        return node;
    }

    void updateFromNativeNode(Node node, boolean fromScratch) throws IIOInvalidTreeException {
        NamedNodeMap attrs = node.getAttributes();
        int value = SOFMarkerSegment.getAttributeValue(node, attrs, "process", 0, 2, false);
        this.tag = value != -1 ? value + 192 : this.tag;
        value = SOFMarkerSegment.getAttributeValue(node, attrs, "samplePrecision", 8, 8, false);
        value = SOFMarkerSegment.getAttributeValue(node, attrs, "numLines", 0, 65535, false);
        this.numLines = value != -1 ? value : this.numLines;
        value = SOFMarkerSegment.getAttributeValue(node, attrs, "samplesPerLine", 0, 65535, false);
        this.samplesPerLine = value != -1 ? value : this.samplesPerLine;
        int numComponents = SOFMarkerSegment.getAttributeValue(node, attrs, "numFrameComponents", 1, 4, false);
        NodeList children = node.getChildNodes();
        if (children.getLength() != numComponents) {
            throw new IIOInvalidTreeException("numFrameComponents must match number of children", node);
        }
        this.componentSpecs = new ComponentSpec[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            this.componentSpecs[i] = new ComponentSpec(children.item(i));
        }
    }

    @Override
    void write(ImageOutputStream ios) throws IOException {
    }

    @Override
    void print() {
        this.printTag("SOF");
        System.out.print("Sample precision: ");
        System.out.println(this.samplePrecision);
        System.out.print("Number of lines: ");
        System.out.println(this.numLines);
        System.out.print("Samples per line: ");
        System.out.println(this.samplesPerLine);
        System.out.print("Number of components: ");
        System.out.println(this.componentSpecs.length);
        for (int i = 0; i < this.componentSpecs.length; ++i) {
            this.componentSpecs[i].print();
        }
    }

    int getIDencodedCSType() {
        for (int i = 0; i < this.componentSpecs.length; ++i) {
            if (this.componentSpecs[i].componentId >= 65) continue;
            return 0;
        }
        switch (this.componentSpecs.length) {
            case 3: {
                if (this.componentSpecs[0].componentId == 82 && this.componentSpecs[0].componentId == 71 && this.componentSpecs[0].componentId == 66) {
                    return 2;
                }
                if (this.componentSpecs[0].componentId != 89 || this.componentSpecs[0].componentId != 67 || this.componentSpecs[0].componentId != 99) break;
                return 5;
            }
            case 4: {
                if (this.componentSpecs[0].componentId == 82 && this.componentSpecs[0].componentId == 71 && this.componentSpecs[0].componentId == 66 && this.componentSpecs[0].componentId == 65) {
                    return 6;
                }
                if (this.componentSpecs[0].componentId != 89 || this.componentSpecs[0].componentId != 67 || this.componentSpecs[0].componentId != 99 || this.componentSpecs[0].componentId != 65) break;
                return 10;
            }
        }
        return 0;
    }

    ComponentSpec getComponentSpec(byte id, int factor, int qSelector) {
        return new ComponentSpec(id, factor, qSelector);
    }

    class ComponentSpec
    implements Cloneable {
        int componentId;
        int HsamplingFactor;
        int VsamplingFactor;
        int QtableSelector;

        ComponentSpec(byte id, int factor, int qSelector) {
            this.componentId = id;
            this.HsamplingFactor = factor;
            this.VsamplingFactor = factor;
            this.QtableSelector = qSelector;
        }

        ComponentSpec(JPEGBuffer buffer) {
            this.componentId = buffer.buf[buffer.bufPtr++];
            this.HsamplingFactor = buffer.buf[buffer.bufPtr] >>> 4;
            this.VsamplingFactor = buffer.buf[buffer.bufPtr++] & 0xF;
            this.QtableSelector = buffer.buf[buffer.bufPtr++];
        }

        ComponentSpec(Node node) throws IIOInvalidTreeException {
            NamedNodeMap attrs = node.getAttributes();
            this.componentId = MarkerSegment.getAttributeValue(node, attrs, "componentId", 0, 255, true);
            this.HsamplingFactor = MarkerSegment.getAttributeValue(node, attrs, "HsamplingFactor", 1, 255, true);
            this.VsamplingFactor = MarkerSegment.getAttributeValue(node, attrs, "VsamplingFactor", 1, 255, true);
            this.QtableSelector = MarkerSegment.getAttributeValue(node, attrs, "QtableSelector", 0, 3, true);
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode node = new IIOMetadataNode("componentSpec");
            node.setAttribute("componentId", Integer.toString(this.componentId));
            node.setAttribute("HsamplingFactor", Integer.toString(this.HsamplingFactor));
            node.setAttribute("VsamplingFactor", Integer.toString(this.VsamplingFactor));
            node.setAttribute("QtableSelector", Integer.toString(this.QtableSelector));
            return node;
        }

        void print() {
            System.out.print("Component ID: ");
            System.out.println(this.componentId);
            System.out.print("H sampling factor: ");
            System.out.println(this.HsamplingFactor);
            System.out.print("V sampling factor: ");
            System.out.println(this.VsamplingFactor);
            System.out.print("Q table selector: ");
            System.out.println(this.QtableSelector);
        }
    }
}

