/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.Codes;
import tingeltangel.core.Translator;

class GenerateCode
extends CliCmd {
    GenerateCode() {
    }

    @Override
    public String getName() {
        return "generate-code";
    }

    @Override
    public String getDescription() {
        return "generate-code 600|1200 <size in mm> <ting id>|<ting id bereich> <directory>";
    }

    @Override
    public int execute(String[] args) {
        int i;
        if (args.length != 4) {
            return this.error("falsche Anzahl von Parametern angegeben");
        }
        File file = new File(args[3].trim());
        if (args[0].toLowerCase().equals("600")) {
            Codes.setResolution(0);
        } else if (args[0].toLowerCase().equals("1200")) {
            Codes.setResolution(1);
        } else {
            return this.error("Syntax Fehler");
        }
        int size = -1;
        try {
            size = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            return this.error("ung\u00fcltige Gro\u00dfe angegeben (5-500)");
        }
        if (size < 5 || size > 500) {
            return this.error("ung\u00fcltige Gro\u00dfe angegeben (5-500)");
        }
        int idStart = -1;
        int idEnd = -1;
        try {
            int p = args[2].indexOf("-");
            if (p < 0) {
                idEnd = idStart = Integer.parseInt(args[2]);
            } else {
                idStart = Integer.parseInt(args[2].substring(0, p));
                idEnd = Integer.parseInt(args[2].substring(p + 1));
            }
        }
        catch (NumberFormatException e) {
            return this.error("ung\u00fcltige id angegeben (0-65535)");
        }
        if (idStart > idEnd) {
            return this.error("ung\u00fcltige id bereich angegeben");
        }
        int[] cIds = new int[idEnd - idStart + 1];
        for (i = 0; i < cIds.length; ++i) {
            cIds[i] = Translator.ting2code(idStart + i);
            if (cIds[i] >= 0) continue;
            return this.error("unbekannte id angegeben (" + (idStart + i) + ")");
        }
        try {
            for (i = 0; i < cIds.length; ++i) {
                String filename = Integer.toString(i + idStart);
                while (filename.length() < 5) {
                    filename = "0" + filename;
                }
                filename = "ting_label_" + filename + ".png";
                FileOutputStream out = new FileOutputStream(new File(file, filename));
                Codes.drawPng(cIds[i], size, size, out);
                out.close();
            }
        }
        catch (IOException e) {
            return this.error("Code konnten nicht erzeugt werden", e);
        }
        return this.ok();
    }
}

