/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.andersicht;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import tingeltangel.andersicht.AndersichtBookGenerator;
import tingeltangel.andersicht.AndersichtDescriptionLayer;
import tingeltangel.andersicht.AndersichtGroup;
import tingeltangel.andersicht.AndersichtLanguageLayer;
import tingeltangel.andersicht.AndersichtObject;
import tingeltangel.andersicht.AndersichtTrack;
import tingeltangel.andersicht.gui.AndersichtBookDefinition;
import tingeltangel.andersicht.pen.Pen;
import tingeltangel.andersicht.pen.Pens;
import tingeltangel.andersicht.pen.Ting;
import tingeltangel.core.Translator;
import tingeltangel.tools.FileEnvironment;

public class AndersichtBook
implements TreeNode {
    private String description = "Beschreibung";
    private String name;
    private int bookId = 2303;
    private final List<AndersichtLanguageLayer> languageLayers = new LinkedList<AndersichtLanguageLayer>();
    private final List<AndersichtDescriptionLayer> descriptionLayers = new LinkedList<AndersichtDescriptionLayer>();
    private final List<AndersichtGroup> groups = new LinkedList<AndersichtGroup>();
    private boolean unsaved = true;
    private AndersichtLanguageLayer activeLanguageLayer;
    private final Pen pen;

    private AndersichtBook(int bookId, String name, String description, Pen pen) {
        this.name = name;
        this.description = description;
        this.pen = pen;
        this.bookId = bookId;
    }

    public void setActiveLanguageLayer(AndersichtLanguageLayer lLayer) {
        this.activeLanguageLayer = lLayer;
    }

    public AndersichtLanguageLayer getActiveLanguageLayer() {
        return this.activeLanguageLayer;
    }

    public String toString() {
        return this.name;
    }

    public boolean unsaved() {
        return this.unsaved;
    }

    void changeMade() {
        this.unsaved = true;
    }

    public void changeMade(boolean x) {
        this.unsaved = x;
    }

    public static AndersichtBook newBook(AndersichtBookDefinition def) {
        AndersichtBook book = new AndersichtBook(def.bookId, def.name, def.description, def.pen);
        return book;
    }

    public int getBookId() {
        return this.bookId;
    }

    public void setBookId(int id) throws IllegalArgumentException {
        if (id < 1 || id > 9999) {
            throw new IllegalArgumentException();
        }
        this.bookId = id;
        this.changeMade();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (!this.description.equals(description)) {
            this.description = description;
            this.changeMade();
        }
    }

    public void setName(String name) {
        if (!this.name.equals(name)) {
            this.name = name;
            this.changeMade();
        }
    }

    public AndersichtGroup addGroup(String name, String description) {
        AndersichtGroup group = new AndersichtGroup(name, description, this);
        this.groups.add(group);
        this.changeMade();
        return group;
    }

    public void removeGroup(AndersichtGroup group) {
        this.groups.remove(group);
        this.changeMade();
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public AndersichtGroup getGroup(int i) {
        return this.groups.get(i);
    }

    public AndersichtLanguageLayer addLanguageLayer(String name, String description) {
        AndersichtLanguageLayer layer = new AndersichtLanguageLayer(name, description, this);
        if (!this.languageLayers.isEmpty()) {
            layer.setId(this.languageLayers.get(this.languageLayers.size() - 1).getId() + 1);
        }
        this.languageLayers.add(layer);
        this.changeMade();
        return layer;
    }

    public AndersichtObject removeLanguageLayer(AndersichtLanguageLayer layer) {
        for (AndersichtGroup group : this.groups) {
            for (int g = 0; g < group.getObjectCount(); ++g) {
                AndersichtObject object = group.getObject(g);
                if (!object.usesLanguageLayer(layer)) continue;
                return object;
            }
        }
        this.changeMade();
        this.languageLayers.remove(layer);
        return null;
    }

    public int getLanguageLayerCount() {
        return this.languageLayers.size();
    }

    public AndersichtLanguageLayer getLanguageLayer(int i) {
        return this.languageLayers.get(i);
    }

    public AndersichtDescriptionLayer addDescriptionLayer(String name, String description) {
        AndersichtDescriptionLayer layer = new AndersichtDescriptionLayer(name, description, this);
        if (!this.descriptionLayers.isEmpty()) {
            layer.setId(this.descriptionLayers.get(this.descriptionLayers.size() - 1).getId() + 1);
        }
        this.descriptionLayers.add(layer);
        this.changeMade();
        return layer;
    }

    public AndersichtObject removeDescriptionLayer(AndersichtDescriptionLayer layer) {
        for (AndersichtGroup group : this.groups) {
            for (int g = 0; g < group.getObjectCount(); ++g) {
                AndersichtObject object = group.getObject(g);
                if (!object.usesDescriptionLayer(layer)) continue;
                return object;
            }
        }
        this.changeMade();
        this.descriptionLayers.remove(layer);
        return null;
    }

    public int getDescriptionLayerCount() {
        return this.descriptionLayers.size();
    }

    public AndersichtDescriptionLayer getDescriptionLayer(int i) {
        return this.descriptionLayers.get(i);
    }

    public static AndersichtBook load(int bookId) throws IOException {
        int i;
        File file = FileEnvironment.getAndersichtBookFile(Integer.toString(bookId));
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        String name = in.readUTF();
        String description = in.readUTF();
        int _bookId = in.readInt();
        if (_bookId != bookId) {
            throw new IOException("bad book id found");
        }
        String penName = in.readUTF();
        AndersichtBook book = new AndersichtBook(bookId, name, description, Pens.getPen(penName));
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            book.languageLayers.add(AndersichtLanguageLayer.load(book, in));
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            book.descriptionLayers.add(AndersichtDescriptionLayer.load(book, in));
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            book.groups.add(AndersichtGroup.load(book, in));
        }
        in.close();
        book.unsaved = false;
        return book;
    }

    public void save() throws IOException {
        int i;
        File file = FileEnvironment.getAndersichtBookFile(Integer.toString(this.bookId));
        DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
        out.writeUTF(this.name);
        out.writeUTF(this.description);
        out.writeInt(this.bookId);
        out.writeUTF(this.pen.toString());
        out.writeInt(this.languageLayers.size());
        for (i = 0; i < this.languageLayers.size(); ++i) {
            this.languageLayers.get(i).save(out);
        }
        out.writeInt(this.descriptionLayers.size());
        for (i = 0; i < this.descriptionLayers.size(); ++i) {
            this.descriptionLayers.get(i).save(out);
        }
        out.writeInt(this.groups.size());
        for (i = 0; i < this.groups.size(); ++i) {
            this.groups.get(i).save(out);
        }
        this.unsaved = false;
        out.close();
    }

    AndersichtDescriptionLayer getDescriptionLayerById(int descriptionId) throws IOException {
        for (AndersichtDescriptionLayer layer : this.descriptionLayers) {
            if (layer.getId() != descriptionId) continue;
            return layer;
        }
        throw new IOException("corrupted file format");
    }

    AndersichtLanguageLayer getLanguageLayerById(int languageId) throws IOException {
        for (AndersichtLanguageLayer layer : this.languageLayers) {
            if (layer.getId() != languageId) continue;
            return layer;
        }
        throw new IOException("corrupted file format");
    }

    public int getGroupIndex(AndersichtGroup group) {
        boolean i = false;
        return this.groups.indexOf(group);
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.getGroup(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.getGroupCount();
    }

    @Override
    public TreeNode getParent() {
        return null;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (!(node instanceof AndersichtGroup)) {
            return -1;
        }
        return this.getGroupIndex((AndersichtGroup)node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public Enumeration children() {
        return new Enumeration(){
            int pos = -1;

            @Override
            public boolean hasMoreElements() {
                return this.pos < AndersichtBook.this.getGroupCount();
            }

            public Object nextElement() {
                ++this.pos;
                return AndersichtBook.this.getGroup(this.pos);
            }
        };
    }

    public Pen getPen() {
        return this.pen;
    }

    private LinkedList<String> searchForMissingMp3s() {
        LinkedList<String> errors = new LinkedList<String>();
        for (AndersichtLanguageLayer ll : this.languageLayers) {
            if (ll.getInternalMP3() != null) continue;
            errors.add("MP3 f\u00fcr die Sprache '" + ll.toString() + "' fehlt");
        }
        for (AndersichtGroup group : this.groups) {
            for (int i = 0; i < group.getObjectCount(); ++i) {
                AndersichtObject object = group.getObject(i);
                for (AndersichtLanguageLayer ll : this.languageLayers) {
                    for (AndersichtDescriptionLayer dl : this.descriptionLayers) {
                        AndersichtTrack track = object.getTrack(ll, dl);
                        if (track.getInternalMP3() != null) continue;
                        errors.add("MP3 f\u00fcr '" + group.getName() + "/" + object.getName() + "/" + ll.getName() + "/" + dl.getName() + "' fehlt");
                    }
                }
            }
        }
        return errors;
    }

    private LinkedList<String> searchForLabelConflicts() {
        HashMap<Integer, String> labels = new HashMap<Integer, String>();
        LinkedList<String> errors = new LinkedList<String>();
        for (AndersichtLanguageLayer ll : this.languageLayers) {
            String oldLabel = (String)labels.get(ll.getLabel());
            if (oldLabel != null) {
                errors.add("Sprache '" + ll.toString() + "' hat das selbe Label wie '" + oldLabel + "' zugeordnet");
            }
            labels.put(ll.getLabel(), ll.toString());
        }
        for (AndersichtGroup group : this.groups) {
            for (int i = 0; i < group.getObjectCount(); ++i) {
                AndersichtObject object = group.getObject(i);
                try {
                    object.hasAllTracks();
                }
                catch (IllegalArgumentException iae) {
                    errors.add(iae.getMessage());
                }
                for (AndersichtDescriptionLayer dl : this.descriptionLayers) {
                    String oldLabel = (String)labels.get(object.getLabelAsInt(dl));
                    if (oldLabel != null) {
                        errors.add("Objekt '" + object.toString() + "' hat das selbe Label wie '" + oldLabel + "' zugeordnet");
                    }
                    labels.put(object.getLabelAsInt(dl), object.toString());
                }
            }
        }
        Iterator labelIterator = labels.keySet().iterator();
        while (labelIterator.hasNext()) {
            int label = (Integer)labelIterator.next();
            if (label < Translator.getMinObjectCode()) {
                errors.add("ung\u00fcltiges Label f\u00fcr '" + (String)labels.get(label) + "'");
                continue;
            }
            if (Translator.ting2code(label) >= 0) continue;
            errors.add("unbekanntes Label f\u00fcr '" + (String)labels.get(label) + "'");
        }
        return errors;
    }

    public void generate(File target) throws IOException, IllegalArgumentException {
        LinkedList<String> labelErrors = this.searchForLabelConflicts();
        if (labelErrors.size() > 0) {
            throw new IllegalArgumentException(labelErrors.getFirst());
        }
        AndersichtBookGenerator.generate(this, target);
    }

    public StringBuffer checkLabels() {
        StringBuffer sb = new StringBuffer();
        LinkedList<String> labelErrors = this.searchForLabelConflicts();
        if (labelErrors.isEmpty()) {
            return null;
        }
        Iterator i = labelErrors.iterator();
        while (i.hasNext()) {
            sb.append((String)i.next()).append("\n");
        }
        return sb;
    }

    public StringBuffer checkMp3s() {
        StringBuffer sb = new StringBuffer();
        LinkedList<String> mp3Errors = this.searchForMissingMp3s();
        if (mp3Errors.isEmpty()) {
            return null;
        }
        Iterator i = mp3Errors.iterator();
        while (i.hasNext()) {
            sb.append((String)i.next()).append("\n");
        }
        return sb;
    }

    private String toLength(String s, int l) {
        if (s.length() > l) {
            s = s.substring(0, l - 3) + "...";
        }
        while (s.length() < l) {
            s = s + " ";
        }
        return s;
    }

    private String tab(int i) {
        String s = "";
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < 6; ++k) {
                s = s + " ";
            }
        }
        return s;
    }

    public void generateLabelReport(PrintWriter out) throws IOException {
        out.println("Buchname : " + this.getName());
        out.println("Buch ID  : " + this.getBookId());
        out.println("Pen      : " + this.getPen().toString());
        out.println();
        out.println();
        out.println("Sprachlayer:");
        for (int ll = 0; ll < this.getLanguageLayerCount(); ++ll) {
            int tingId = this.getLanguageLayer(ll).getLabel();
            String label = Integer.toString(tingId);
            if (!(this.getPen() instanceof Ting)) {
                label = this.getPen().fromTingId(tingId) + " (" + label + ")";
            }
            out.println(this.tab(2) + this.toLength(this.getLanguageLayer(ll).getName(), 25) + " : " + label);
        }
        out.println();
        out.println();
        for (int g = 0; g < this.getGroupCount(); ++g) {
            AndersichtGroup group = this.getGroup(g);
            out.println(group.getName());
            for (int o = 0; o < group.getObjectCount(); ++o) {
                AndersichtObject object = group.getObject(o);
                out.println(this.tab(1) + object.getName());
                for (int l = 0; l < this.getDescriptionLayerCount(); ++l) {
                    AndersichtDescriptionLayer dLayer = this.getDescriptionLayer(l);
                    int tingId = object.getLabelAsInt(dLayer);
                    String label = Integer.toString(tingId);
                    if (!(this.getPen() instanceof Ting)) {
                        label = this.getPen().fromTingId(tingId) + " (" + label + ")";
                    }
                    out.println(this.tab(2) + this.toLength(dLayer.getName(), 25) + " : " + label);
                }
                out.println();
            }
            out.println();
        }
    }
}

