/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import tingeltangel.cli_ng.CLI;
import tingeltangel.cli_ng.CliCmd;

class SetEntryScript
extends CliCmd {
    SetEntryScript() {
    }

    @Override
    String getName() {
        return "set-entry-script";
    }

    @Override
    String getDescription() {
        return "set-entry-script <oid> <script-file>";
    }

    @Override
    int execute(String[] args) {
        int oid;
        if (args.length != 2) {
            return this.error("falsche Anzahl von Parametern");
        }
        try {
            oid = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            return this.error("OID keine Zahl zw. 15001 und 65535");
        }
        File scriptFile = new File(args[1]);
        if (!scriptFile.canRead()) {
            return this.error("angebebene Skript-Datei ist nicht lesbar");
        }
        if (!CLI.bookOpened()) {
            return this.error("kein Buch ge\u00f6ffnet");
        }
        if (!CLI.getBook().entryForTingIDExists(oid)) {
            CLI.getBook().addEntry(oid);
        }
        try {
            String row;
            BufferedReader in = new BufferedReader(new FileReader(scriptFile));
            StringBuilder sb = new StringBuilder();
            while ((row = in.readLine()) != null) {
                sb.append(row).append("\n");
            }
            in.close();
            CLI.getBook().getEntryByOID(oid).setCode();
            CLI.getBook().getEntryByOID(oid).getScript().setCode(sb.toString());
        }
        catch (IOException ex) {
            return this.error("Script konnte nicht hinzugef\u00fcgt werden", ex);
        }
        return this.ok();
    }
}

