/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.Codes;

class SetCodeConfig
extends CliCmd {
    static final String PATTERN = "pattern";
    static final String DOT = "dot";
    static final String DELTA = "delta";
    static final String DPI_600 = "600";
    static final String DPI_1200 = "1200";

    SetCodeConfig() {
    }

    @Override
    String getName() {
        return "set-code-config";
    }

    @Override
    String getDescription() {
        return "set-code-config 600|1200 pattern|dot|delta <value>";
    }

    @Override
    int execute(String[] args) {
        if (args.length != 3) {
            return this.error("falsche Anzahl von Parametern");
        }
        try {
            args[0] = args[0].trim();
            args[1] = args[1].trim();
            int value = Integer.parseInt(args[2].trim());
            if (args[0].equals(DPI_600) && args[1].equals(PATTERN)) {
                Codes.setPatternSize600(value);
            } else if (args[0].equals(DPI_600) && args[1].equals(DOT)) {
                Codes.setDotSize600(value);
            } else if (args[0].equals(DPI_600) && args[1].equals(DELTA)) {
                Codes.setDeltaSize600(value);
            } else if (args[0].equals(DPI_1200) && args[1].equals(PATTERN)) {
                Codes.setPatternSize1200(value);
            } else if (args[0].equals(DPI_1200) && args[1].equals(DOT)) {
                Codes.setDotSize1200(value);
            } else if (args[0].equals(DPI_1200) && args[1].equals(DELTA)) {
                Codes.setDeltaSize1200(value);
            } else {
                return this.error("unbekante Parameterkombination: " + args[0] + " " + args[1]);
            }
            Codes.saveProperties();
        }
        catch (NumberFormatException e) {
            return this.error("keine Zahl als dritten Parameter angegeben");
        }
        return this.ok();
    }
}

