/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import tingeltangel.core.Book;
import tingeltangel.core.Stick;
import tingeltangel.core.scripting.SyntaxError;
import tingeltangel.gui.EditorFrame;
import tingeltangel.tools.FileEnvironment;
import tingeltangel.tools.Progress;
import tingeltangel.tools.ProgressDialog;

public class StickPanel
extends JPanel {
    private JLabel label = new JLabel("keinen Stift gefunden");
    private JButton button;
    private boolean online = false;
    private static final Logger log = LogManager.getLogger(StickPanel.class);

    public StickPanel(final EditorFrame frame) {
        this.add(this.label);
        this.button = new JButton("deployen");
        this.button.setEnabled(false);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final Book book = frame.getBook();
                try {
                    book.save();
                    new Progress(frame, "erzeuge Buch (TTS)"){

                        @Override
                        public void action(ProgressDialog progressDialog) {
                            try {
                                book.generateTTS(progressDialog);
                                new Progress(frame, "erzeuge Buch (ouf)"){

                                    @Override
                                    public void action(ProgressDialog progressDialog) {
                                        try {
                                            book.export(FileEnvironment.getDistDirectory(book.getID()), progressDialog);
                                            Stick stick = Stick.getAnyStick();
                                            if (stick != null) {
                                                File dest = stick.getBookDir();
                                                File[] files = FileEnvironment.getDistDirectory(book.getID()).listFiles(new FilenameFilter(){

                                                    @Override
                                                    public boolean accept(File dir, String name) {
                                                        return (name = name.toLowerCase()).endsWith(".ouf") || name.endsWith(".src") || name.endsWith(".png") || name.endsWith(".txt");
                                                    }
                                                });
                                                for (int i = 0; i < files.length; ++i) {
                                                    String destName = files[i].getName();
                                                    if (stick.isBookii()) {
                                                        destName = destName.substring(0, destName.length() - ".ouf".length()) + ".kii";
                                                    }
                                                    FileEnvironment.copy(files[i], new File(dest, files[i].getName()));
                                                }
                                                stick.activateBook(book.getID());
                                                JOptionPane.showMessageDialog(frame, "Buch auf den Stift kopiert");
                                            }
                                        }
                                        catch (IOException e) {
                                            log.error("failed to generate book", e);
                                            JOptionPane.showMessageDialog(frame, "Buchgenerierung fehlgeschlagen");
                                        }
                                        catch (IllegalArgumentException e) {
                                            log.error("failed to generate book", e);
                                            JOptionPane.showMessageDialog(frame, "Buchgenerierung fehlgeschlagen: " + e.getMessage());
                                        }
                                        catch (SyntaxError e) {
                                            log.error("failed to generate book", e);
                                            JOptionPane.showMessageDialog(frame, "Buchgenerierung fehlgeschlagen: Syntax Error in Skript " + e.getTingID() + " in Zeile " + e.getRow() + " (" + e.getMessage() + ")");
                                        }
                                    }
                                };
                            }
                            catch (IOException ioe) {
                                JOptionPane.showMessageDialog(frame, "Buchgenerierung fehlgeschlagen: " + ioe.getMessage());
                            }
                        }
                    };
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(frame, "Das Buch konnte nicht gespeichert werden");
                    log.error("failed to save book", ex);
                }
            }
        });
        this.add(this.button);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    Stick stick = Stick.getAnyStick();
                    if (StickPanel.this.online && stick == null) {
                        StickPanel.this.online = false;
                        StickPanel.this.button.setEnabled(false);
                        StickPanel.this.label.setText("keinen Stift gefunden");
                    } else if (!StickPanel.this.online && stick != null) {
                        StickPanel.this.online = true;
                        StickPanel.this.button.setEnabled(true);
                        StickPanel.this.label.setText("Stift gefunden (" + stick.getType() + ")");
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        };
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.scheduleAtFixedRate(task, 3L, 3L, TimeUnit.SECONDS);
    }
}

