/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.andersicht.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import tingeltangel.Tingeltangel;
import tingeltangel.core.Tupel;
import tingeltangel.tools.Callback;
import tingeltangel.tools.FileEnvironment;

public class AndersichtChooseBook
extends JDialog {
    private final LinkedList<Tupel<Integer, String>> idList = new LinkedList();
    private static final Logger LOG = LogManager.getLogger(AndersichtChooseBook.class);
    private JList bookList = new JList();
    private JButton button = new JButton();
    private JScrollPane jScrollPane = new JScrollPane();

    public AndersichtChooseBook(Frame parent, final Callback<Integer> callback) {
        super(parent, false);
        this.setTitle(Tingeltangel.MAIN_FRAME_TITLE + " - Buch laden");
        this.setSize(300, 400);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        this.getContentPane().add((Component)this.button, "South");
        this.jScrollPane.setViewportView(this.bookList);
        MyListModel model = new MyListModel();
        this.bookList.setModel(model);
        this.button.setText("OK");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = AndersichtChooseBook.this.bookList.getSelectedIndex();
                if (index != -1) {
                    int id = (Integer)((Tupel)((AndersichtChooseBook)AndersichtChooseBook.this).idList.get((int)index)).a;
                    callback.callback(id);
                    AndersichtChooseBook.this.dispose();
                }
            }
        });
        this.setDefaultCloseOperation(2);
        File[] books = FileEnvironment.getAndersichtDirectory().listFiles();
        for (int i = 0; i < books.length; ++i) {
            if (!books[i].isDirectory()) continue;
            try {
                int id = Integer.parseInt(books[i].getName());
                if (id == 15000) continue;
                this.idList.add(new Tupel<Integer, String>(id, this.getLabel(id)));
                continue;
            }
            catch (NumberFormatException nfe) {
                LOG.warn("unable to parse book", nfe);
                continue;
            }
            catch (IOException ioe) {
                LOG.warn("unable to parse book", ioe);
            }
        }
        model.refresh();
        this.setFocusable(false);
        this.setVisible(true);
    }

    private String getLabel(int bookId) throws IOException {
        File file = FileEnvironment.getAndersichtBookFile(Integer.toString(bookId));
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        String label = in.readUTF();
        in.close();
        return label;
    }

    class MyListModel
    implements ListModel {
        private LinkedList<ListDataListener> listeners = new LinkedList();

        MyListModel() {
        }

        @Override
        public int getSize() {
            return AndersichtChooseBook.this.idList.size();
        }

        public Object getElementAt(int index) {
            return ((Tupel)((AndersichtChooseBook)AndersichtChooseBook.this).idList.get((int)index)).b;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        public void refresh() {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((ListDataListener)i.next()).contentsChanged(null);
            }
        }
    }
}

