/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.andersicht;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import tingeltangel.andersicht.AndersichtBook;
import tingeltangel.andersicht.AndersichtObject;

public class AndersichtGroup
implements TreeNode {
    private String name = "Gruppenname";
    private String description = "Gruppenbeschreibung";
    private final AndersichtBook book;
    private final List<AndersichtObject> objects = new LinkedList<AndersichtObject>();

    AndersichtGroup(String name, String description, AndersichtBook book) {
        this.name = name;
        this.description = description;
        this.book = book;
    }

    public String toString() {
        return this.name;
    }

    public AndersichtBook getBook() {
        return this.book;
    }

    public AndersichtObject addObject(String name, String description) {
        AndersichtObject object = new AndersichtObject(name, description, this);
        this.objects.add(object);
        this.book.changeMade();
        return object;
    }

    public void removeObject(AndersichtObject object) {
        this.objects.remove(object);
        this.book.changeMade();
    }

    public void setName(String name) {
        if (!this.name.equals(name)) {
            this.name = name;
            this.book.changeMade();
        }
    }

    public void setDescription(String description) {
        if (!this.description.equals(description)) {
            this.description = description;
            this.book.changeMade();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public int getObjectCount() {
        return this.objects.size();
    }

    public AndersichtObject getObject(int i) {
        return this.objects.get(i);
    }

    static AndersichtGroup load(AndersichtBook book, DataInputStream in) throws IOException {
        String name = in.readUTF();
        String description = in.readUTF();
        AndersichtGroup group = new AndersichtGroup(name, description, book);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            group.objects.add(AndersichtObject.load(group, in));
        }
        return group;
    }

    void save(DataOutputStream out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.description);
        out.writeInt(this.objects.size());
        for (int i = 0; i < this.objects.size(); ++i) {
            this.objects.get(i).save(out);
        }
    }

    public int getObjectIndex(AndersichtObject object) {
        return this.objects.indexOf(object);
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.getObject(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.getObjectCount();
    }

    @Override
    public TreeNode getParent() {
        return this.book;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (!(node instanceof AndersichtObject)) {
            return -1;
        }
        return this.getObjectIndex((AndersichtObject)node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public Enumeration children() {
        return new Enumeration(){
            int pos = -1;

            @Override
            public boolean hasMoreElements() {
                return this.pos < AndersichtGroup.this.getObjectCount();
            }

            public Object nextElement() {
                ++this.pos;
                return AndersichtGroup.this.getObject(this.pos);
            }
        };
    }
}

