/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.andersicht;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import tingeltangel.andersicht.AndersichtBook;

public class AndersichtDescriptionLayer {
    private String name = "Name";
    private String description = "Beschreibung";
    private int id = 0;
    private final AndersichtBook book;

    AndersichtDescriptionLayer(String name, String description, AndersichtBook book) {
        this.name = name;
        this.description = description;
        this.book = book;
    }

    public String toString() {
        return this.name;
    }

    public AndersichtBook getBook() {
        return this.book;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.book.changeMade();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.book.changeMade();
    }

    int getId() {
        return this.id;
    }

    void setId(int id) {
        this.id = id;
    }

    static AndersichtDescriptionLayer load(AndersichtBook book, DataInputStream in) throws IOException {
        String name = in.readUTF();
        String description = in.readUTF();
        AndersichtDescriptionLayer layer = new AndersichtDescriptionLayer(name, description, book);
        layer.id = in.readInt();
        return layer;
    }

    void save(DataOutputStream out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.description);
        out.writeInt(this.id);
    }
}

