/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.util.NameUtil;
import org.apache.logging.log4j.message.LocalizedMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;

public class Category {
    private static LoggerFactory loggerFactory = new PrivateFactory();
    private static final Map<LoggerContext, ConcurrentMap<String, Logger>> CONTEXT_MAP = new WeakHashMap<LoggerContext, ConcurrentMap<String, Logger>>();
    private static final String FQCN = Category.class.getName();
    protected ResourceBundle bundle = null;
    private final org.apache.logging.log4j.core.Logger logger;

    protected Category(LoggerContext context, String name) {
        this.logger = context.getLogger(name);
    }

    protected Category(String name) {
        this((LoggerContext)PrivateManager.getContext(), name);
    }

    private Category(org.apache.logging.log4j.core.Logger logger) {
        this.logger = logger;
    }

    public static Category getInstance(String name) {
        return Category.getInstance((LoggerContext)PrivateManager.getContext(), name, loggerFactory);
    }

    static Category getInstance(LoggerContext context, String name) {
        return Category.getInstance(context, name, loggerFactory);
    }

    static Category getInstance(LoggerContext context, String name, LoggerFactory factory) {
        ConcurrentMap<String, Logger> loggers = Category.getLoggersMap(context);
        Logger logger = (Logger)loggers.get(name);
        if (logger != null) {
            return logger;
        }
        logger = factory.makeNewLoggerInstance(context, name);
        Logger prev = loggers.putIfAbsent(name, logger);
        return prev == null ? logger : prev;
    }

    public static Category getInstance(Class clazz) {
        return Category.getInstance(clazz.getName());
    }

    static Category getInstance(LoggerContext context, Class clazz) {
        return Category.getInstance(context, clazz.getName());
    }

    public final String getName() {
        return this.logger.getName();
    }

    org.apache.logging.log4j.core.Logger getLogger() {
        return this.logger;
    }

    public final Category getParent() {
        org.apache.logging.log4j.core.Logger parent = this.logger.getParent();
        if (parent == null) {
            return null;
        }
        ConcurrentMap<String, Logger> loggers = Category.getLoggersMap(this.logger.getContext());
        Logger l = (Logger)loggers.get(parent.getName());
        return l == null ? new Category(parent) : l;
    }

    public static Category getRoot() {
        return Category.getInstance("");
    }

    static Category getRoot(LoggerContext context) {
        return Category.getInstance(context, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap<String, Logger> getLoggersMap(LoggerContext context) {
        Map<LoggerContext, ConcurrentMap<String, Logger>> map = CONTEXT_MAP;
        synchronized (map) {
            ConcurrentMap<String, Logger> map2 = CONTEXT_MAP.get(context);
            if (map2 == null) {
                map2 = new ConcurrentHashMap<String, Logger>();
                CONTEXT_MAP.put(context, map2);
            }
            return map2;
        }
    }

    @Deprecated
    public static Enumeration getCurrentCategories() {
        return LogManager.getCurrentLoggers();
    }

    public final Level getEffectiveLevel() {
        switch (this.logger.getLevel().getStandardLevel()) {
            case ALL: {
                return Level.ALL;
            }
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case FATAL: {
                return Level.FATAL;
            }
            case OFF: {
                return Level.OFF;
            }
        }
        return Level.OFF;
    }

    public final Priority getChainedPriority() {
        return this.getEffectiveLevel();
    }

    public final Level getLevel() {
        return this.getEffectiveLevel();
    }

    public void setLevel(Level level) {
        this.logger.setLevel(org.apache.logging.log4j.Level.toLevel(level.levelStr));
    }

    public final Level getPriority() {
        return this.getEffectiveLevel();
    }

    public void setPriority(Priority priority) {
        this.logger.setLevel(org.apache.logging.log4j.Level.toLevel(priority.levelStr));
    }

    public void debug(Object message) {
        this.maybeLog(FQCN, org.apache.logging.log4j.Level.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.maybeLog(FQCN, org.apache.logging.log4j.Level.DEBUG, message, t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void error(Object message) {
        this.maybeLog(FQCN, org.apache.logging.log4j.Level.ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.maybeLog(FQCN, org.apache.logging.log4j.Level.ERROR, message, t);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void warn(Object message) {
        this.maybeLog(FQCN, org.apache.logging.log4j.Level.WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.maybeLog(FQCN, org.apache.logging.log4j.Level.WARN, message, t);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void fatal(Object message) {
        this.maybeLog(FQCN, org.apache.logging.log4j.Level.FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.maybeLog(FQCN, org.apache.logging.log4j.Level.FATAL, message, t);
    }

    public boolean isFatalEnabled() {
        return this.logger.isFatalEnabled();
    }

    public void info(Object message) {
        this.maybeLog(FQCN, org.apache.logging.log4j.Level.INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.maybeLog(FQCN, org.apache.logging.log4j.Level.INFO, message, t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void trace(Object message) {
        this.maybeLog(FQCN, org.apache.logging.log4j.Level.TRACE, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.maybeLog(FQCN, org.apache.logging.log4j.Level.TRACE, message, t);
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isEnabledFor(Priority level) {
        org.apache.logging.log4j.Level lvl = org.apache.logging.log4j.Level.toLevel(level.toString());
        return this.isEnabledFor(lvl);
    }

    public void addAppender(Appender appender) {
    }

    public void callAppenders(LoggingEvent event) {
    }

    public Enumeration getAllAppenders() {
        return NullEnumeration.getInstance();
    }

    public Appender getAppender(String name) {
        return null;
    }

    public boolean isAttached(Appender appender) {
        return false;
    }

    public void removeAllAppenders() {
    }

    public void removeAppender(Appender appender) {
    }

    public void removeAppender(String name) {
    }

    public static void shutdown() {
    }

    public void forcedLog(String fqcn, Priority level, Object message, Throwable t) {
        org.apache.logging.log4j.Level lvl = org.apache.logging.log4j.Level.toLevel(level.toString());
        Message msg = message instanceof Message ? (Message)message : new ObjectMessage(message);
        this.logger.logMessage(fqcn, lvl, null, msg, t);
    }

    public boolean exists(String name) {
        return PrivateManager.getContext().hasLogger(name);
    }

    public boolean getAdditivity() {
        return this.logger.isAdditive();
    }

    public void setAdditivity(boolean additivity) {
        this.logger.setAdditive(additivity);
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public ResourceBundle getResourceBundle() {
        if (this.bundle != null) {
            return this.bundle;
        }
        String name = this.logger.getName();
        ConcurrentMap<String, Logger> loggers = Category.getLoggersMap(this.logger.getContext());
        while ((name = NameUtil.getSubName(name)) != null) {
            ResourceBundle rb;
            if (!loggers.containsKey(name) || (rb = ((Logger)loggers.get((Object)name)).bundle) == null) continue;
            return rb;
        }
        return null;
    }

    public void assertLog(boolean assertion, String msg) {
        if (!assertion) {
            this.error(msg);
        }
    }

    public void l7dlog(Priority priority, String key, Throwable t) {
        if (this.isEnabledFor(priority)) {
            LocalizedMessage msg = new LocalizedMessage(this.bundle, key, null);
            this.forcedLog(FQCN, priority, msg, t);
        }
    }

    public void l7dlog(Priority priority, String key, Object[] params, Throwable t) {
        if (this.isEnabledFor(priority)) {
            LocalizedMessage msg = new LocalizedMessage(this.bundle, key, params);
            this.forcedLog(FQCN, priority, msg, t);
        }
    }

    public void log(Priority priority, Object message, Throwable t) {
        if (this.isEnabledFor(priority)) {
            ObjectMessage msg = new ObjectMessage(message);
            this.forcedLog(FQCN, priority, msg, t);
        }
    }

    public void log(Priority priority, Object message) {
        if (this.isEnabledFor(priority)) {
            ObjectMessage msg = new ObjectMessage(message);
            this.forcedLog(FQCN, priority, msg, null);
        }
    }

    public void log(String fqcn, Priority priority, Object message, Throwable t) {
        if (this.isEnabledFor(priority)) {
            ObjectMessage msg = new ObjectMessage(message);
            this.forcedLog(fqcn, priority, msg, t);
        }
    }

    private void maybeLog(String fqcn, org.apache.logging.log4j.Level level, Object message, Throwable throwable) {
        if (this.logger.isEnabled(level, null, message, throwable)) {
            this.logger.logMessage(FQCN, level, null, new ObjectMessage(message), throwable);
        }
    }

    private boolean isEnabledFor(org.apache.logging.log4j.Level level) {
        return this.logger.isEnabled(level, null, null);
    }

    private static class PrivateManager
    extends org.apache.logging.log4j.LogManager {
        private static final String FQCN = Category.class.getName();

        private PrivateManager() {
        }

        public static org.apache.logging.log4j.spi.LoggerContext getContext() {
            return PrivateManager.getContext(FQCN, false);
        }

        public static org.apache.logging.log4j.Logger getLogger(String name) {
            return PrivateManager.getLogger(FQCN, name);
        }
    }

    private static class PrivateFactory
    implements LoggerFactory {
        private PrivateFactory() {
        }

        @Override
        public Logger makeNewLoggerInstance(LoggerContext context, String name) {
            return new Logger(context, name);
        }
    }
}

