/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import tingeltangel.core.Tupel;
import tingeltangel.gui.TreeElement;
import tingeltangel.tools.Callback;

public class MasterFrameMenu
implements ActionListener {
    private static final LinkedList<String> keys = new LinkedList();
    private static final HashMap<String, Tupel<String, Boolean>> values = new HashMap();
    private static final HashMap<String, JMenuItem> items = new HashMap();
    private static Callback<String> callback = null;
    private String id;

    private MasterFrameMenu(String id) {
        this.id = id;
    }

    public static void setEnabled(String id, boolean enabled) {
        items.get(id).setEnabled(enabled);
    }

    public static void setMenuCallback(Callback<String> menuCallback) {
        callback = menuCallback;
    }

    private static JMenuItem generateMenuItem(TreeElement element) {
        if (element.isLeaf()) {
            JMenuItem item = new JMenuItem(element.getCaption());
            item.getAccessibleContext().setAccessibleDescription(item.getLabel());
            item.addActionListener(new MasterFrameMenu(element.getFullID()));
            if (element.isHidden()) {
                item.setEnabled(false);
            } else if (!element.getEnabled()) {
                item.setEnabled(false);
            }
            items.put(element.getFullID(), item);
            return item;
        }
        JMenu menu = new JMenu(element.getCaption());
        menu.getAccessibleContext().setAccessibleDescription(menu.getLabel());
        Iterator<TreeElement> i = element.getChilds();
        while (i.hasNext()) {
            menu.add(MasterFrameMenu.generateMenuItem(i.next()));
        }
        if (element.isHidden()) {
            menu.setEnabled(false);
        }
        items.put(element.getFullID(), menu);
        return menu;
    }

    public static JMenuBar getMenuBar() {
        TreeElement root = new TreeElement(null);
        Iterator keyIterator = keys.iterator();
        while (keyIterator.hasNext()) {
            String rawKey = ((String)keyIterator.next()).trim();
            TreeElement element = root.get(rawKey.split("\\."));
            Tupel<String, Boolean> t = values.get(rawKey);
            element.setCaption((String)t.a);
            element.setEnabled((Boolean)t.b);
        }
        JMenuBar menuBar = new JMenuBar();
        Iterator<TreeElement> i = root.getChilds();
        while (i.hasNext()) {
            TreeElement element = i.next();
            menuBar.add((JMenu)MasterFrameMenu.generateMenuItem(element));
        }
        return menuBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (callback == null) {
            throw new Error();
        }
        callback.callback(this.id);
    }

    static {
        try {
            String row;
            BufferedReader in = new BufferedReader(new InputStreamReader(MasterFrameMenu.class.getResourceAsStream("/menu.properties"), "UTF8"));
            while ((row = in.readLine()) != null) {
                if ((row = row.trim()).isEmpty() || row.startsWith("#")) continue;
                int p = row.indexOf("=");
                String key = row.substring(0, p).trim();
                String value = row.substring(p + 1).trim();
                boolean enabled = true;
                if (key.startsWith("*")) {
                    enabled = false;
                    key = key.substring(1);
                }
                keys.add(key);
                values.put(key, new Tupel<String, Boolean>(value, enabled));
            }
        }
        catch (Exception e) {
            throw new Error("unable to load menu from 'menu.properties'");
        }
    }
}

